// import Slider from "react-slick";
import React from "react";
// import "slick-carousel/slick/slick.css";
// import "slick-carousel/slick/slick-theme.css";
// import LayoutNavbar from "../components/userLayouts/navbar/LayoutNavbar";
// import LayoutFooter from "../components/userLayouts/footer/LayoutFooter";
import aboutUsImg from "../../../../public/assets/about/about-us-img.png";
import ourMissionImg from "../../../../public/assets/about/our-mission.png";
import background from "../../../../public/assets/userLayouts/backgroundImage.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope, faArrowRight } from "@fortawesome/free-solid-svg-icons";
// import image1 from "../../../public/assets/userLayouts/img1.png";
// import image2 from "../../../public/assets/userLayouts/img2.png";
// import image3 from "../../../public/assets/userLayouts/img3.png";
// import image4 from "../../../public/assets/userLayouts/img4.png";
// import image5 from "../../../public/assets/userLayouts/img5.png";
import Link from "next/link";
const About = () => {
  const expertiseData = [
    {
      title: "Expertise",
      description:
        "With years of experience in the travel industry, the Marvalist team brings unparalleled knowledge to the table. We’ve traveled extensively and understand the best destinations, hidden gems, and insider tips that ensure your trip is nothing short of extraordinary.",
    },
    {
      title: "Tailored Itineraries",
      description:
        "We don’t believe in generic trips. Our team works closely with you to design personalized itineraries that reflect your interests, budget, and schedule. Whether you're seeking adventure, relaxation, or cultural immersion, we create journeys that are uniquely yours.",
    },
    {
      title: "End-to-End Service",
      description:
        "From the moment you book until you return home, Marvalist ensures every aspect of your trip is meticulously planned and handled. We manage everything from flights and accommodations to excursions, transportation, and local guides, so you can focus on enjoying your vacation.",
    },
    {
      title: "Customer-Centered Focus",
      description:
        "Your satisfaction is at the heart of everything we do. Our team is committed to providing exceptional customer service, ensuring that your travel experience with us is smooth, stress-free, and unforgettable.",
    },
  ];
  return (
    <div className="pt-[120px] z-0">
      <div>
        {/* First Section */}
        <div class="bg-[#F2F2F2] h-[200px] lg:h-[354px] flex items-center justify-center">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 ">
            <div className="text-center">
              <h2 className="lg:text-7xl md:text-5xl text-4xl font-bold py-8">
                About <span className="text-[#0689BE] ml-2">Us</span>
              </h2>
            </div>
          </div>
        </div>
        <div class="max-w-7xl md:px-5 mx-auto">
          <div className="mb-10 flex flex-col md:flex-row md:gap-4 gap-10 items-center pt-10  justify-between px-4 md:px-0">
            <div className="md:max-w-[450px]">
              <p className=" md:text-5xl text-3xl leading-10  font-bold mb-4">
                About Us
              </p>

              <p className="text-[#838189] text-lg ">
                Welcome to Marvalist, your trusted travel companion in exploring
                the world’s most breathtaking destinations. We are a passionate
                team of travel experts dedicated to making your journey not only
                memorable but also seamless. Whether you're dreaming of a
                relaxing beach retreat, an exhilarating adventure, or an
                immersive cultural experience, Marvalist provides the perfect
                travel solutions for every kind of traveler.
              </p>
              <div className="pt-10 ">
                <Link href="/contact-us">
                  <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold">
                    Contact Us
                  </button>
                </Link>
              </div>
            </div>
            <div className="">
              <Image
                src={aboutUsImg}
                alt=""
                className="w-[344px] h-[100%] sm:w-[370px] sm:h-[100%]  md:w-[650px] md:h-[100%] lg:w-[500px] lg:h-[100%] object-contain"
              />
            </div>
          </div>
          <div className="py-10 flex flex-col-reverse md:flex-row md:gap-4 gap-10 items-center  justify-between px-4 md:px-0">
            <div className="">
              <Image
                src={ourMissionImg}
                alt=""
                className="w-[344px] h-[100%] sm:w-[370px] sm:h-[100%]  md:w-[650px] md:h-[100%] lg:w-[500px] lg:h-[100%]  object-contain"
              />
            </div>
            <div className="md:max-w-[450px]">
              <p className=" md:text-5xl text-3xl   font-bold mb-4">
                {" "}
                Our Mission
              </p>
              <p className="text-[#838189] text-lg ">
                At Marvalist, our mission is clear: to inspire and empower
                travelers to explore the world with ease and excitement. We
                believe that travel is more than just visiting new places; it’s
                about creating experiences that will stay with you forever.
                Combining expert knowledge, personalized service, and innovative
                technology, we craft unforgettable travel experiences tailored
                to your unique preferences.
              </p>
              <div className="pt-10 ">
                <Link href="/contact-us">
                  <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold">
                    Contact Us
                  </button>
                </Link>
              </div>
            </div>
          </div>
        </div>
        {/* <div className=" py-10">
        <Slider {...settings}>
          {sliderData.map((item, index) => (
            <div key={index} className=" text-center ">
              <Link href={item.link} className="">
                <Image src={item.img} alt="" className="h-[32px] " />
              </Link>
            </div>
          ))}
        </Slider>
      </div> */}
        {/* Second Section */}
        <div className="bg-white py-12 md:mt-6 lg:mt-12">
          <div className="max-w-7xl px-5 mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center">
              <h2 className="md:text-5xl text-4xl leading-10  font-bold mb-4">
                What Sets Us Apart
              </h2>
            </div>
            <div className="mt-8 grid gap-8 md:grid-cols-2 lg:grid-cols-4 pt-10">
              {/* Expertise Card */}
              {expertiseData.map((item, index) => (
                <div key={index} className="bg-gray-100 p-6 rounded-lg ">
                  <h3 className="text-lg font-bold text-gray-900">
                    {item.title}
                  </h3>
                  <p className="mt-2 text-gray-600">{item.description}</p>
                </div>
              ))}
            </div>
          </div>
        </div>
        <div className="bg-white py-12 md:mt-6 lg:mt-12">
          <div className="max-w-7xl px-5 mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center">
              <h2 className="md:text-5xl text-4xl leading-10  font-bold mb-4">
                Join Us on a Journey
              </h2>
            </div>
            <div className="pt-5">
              <p className="text-[#838189] text-lg text-center">
                Let Marvalist be your guide to the world. Whether you’re a
                seasoned traveler or planning your first getaway, we’ll ensure
                your journey is everything you’ve dreamed of and more. Discover
                new places, create lifelong memories, and explore the world with
                confidence and ease.
              </p>
            </div>
            <div className="pt-5 text-center">
              <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-lg font-semibold">
                Contact Us
              </button>
            </div>
          </div>
        </div>
      </div>

      <div className="  md:h-[641px] bg-secondary  pb-16 lg:mt-10">
        <div className="relative mx-auto  max-w-7xl md:h-[641px]">
          <Image
            className=" absolute z-0  top-0 bottom-0 left-0  object-cover md:h-[641px]"
            src={background}
            alt="Background-Image"
          />
          <div className="md:h-[641px] flex flex-col gap-10 justify-center  px-8 relative z-1">
            <div className="text-center flex flex-col items-center">
              <p className="text-primary text-2xl  py-7 font-normal ">
                Subscribe to our Newsletter
              </p>
              <p className="text-white md:text-5xl text-3xl pb-7  max-w-[900px]">
                Prepare yourself & let’s explore the beauty of the world
              </p>
            </div>
            <div className=" flex md:flex-row flex-col md:gap-4 gap-4 justify-center">
              <div className="relative w-full lg:w-[60%]">
                <input
                  type="text"
                  placeholder="Your Email"
                  className="bg-white px-10 py-3 rounded-3xl w-full outline-none h-[50px]"
                />
                <FontAwesomeIcon
                  icon={faEnvelope}
                  className=" absolute left-3 md:top-4 top-[16px] h-[19px] w-[19px]"
                />
              </div>
              <button className="bg-primary rounded-3xl py-2 px-5 font-semibold text-[14px] text-white md:min-w-[170px] h-[50px]">
                Subscribe
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
export default About;
