
// import Slider from "react-slick";
import React from "react";
// import "slick-carousel/slick/slick.css";
// import "slick-carousel/slick/slick-theme.css";

import aboutUsImg from "../../../../public/assets/about/about-us-img.png";
import ourMissionImg from "../../../../public/assets/about/our-mission.png";
import background from "../../../../public/assets/userLayouts/backgroundImage.png";
import discover from "../../../../public/assets/userLayouts/discover.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope, faArrowRight } from "@fortawesome/free-solid-svg-icons";
// import image1 from "../../../public/assets/userLayouts/img1.png";
// import image2 from "../../../public/assets/userLayouts/img2.png";
// import image3 from "../../../public/assets/userLayouts/img3.png";
// import image4 from "../../../public/assets/userLayouts/img4.png";
// import image5 from "../../../public/assets/userLayouts/img5.png";
import Link from "next/link";
const page = () => {
  //  const sliderData = [
  //     {
  //       img: image1,
  //       link: "/",
  //     },
  //     {
  //       img: image2,
  //       link: "/",
  //     },
  //     {
  //       img: image3,
  //       link: "/",
  //     },
  //     {
  //       img: image4,
  //       link: "/",
  //     },
  //     {
  //       img: image5,
  //       link: "/",
  //     },
  //   ];
  //   var settings = {
  //     infinite: false,
  //     speed: 500,
  //     slidesToShow: 5,
  //     slidesToScroll: 5,
  //     initialSlide: 0,
  //     responsive: [
  //       {
  //         breakpoint: 1024,
  //         settings: {
  //           slidesToShow: 4,
  //           slidesToScroll: 2,
  //           infinite: true,
  //         },
  //       },
  //       {
  //         breakpoint: 600,
  //         settings: {
  //           slidesToShow: 3,
  //           slidesToScroll: 2,
  //           initialSlide: 2,
  //         },
  //       },
  //       {
  //         breakpoint: 480,
  //         settings: {
  //           slidesToShow: 2,
  //           slidesToScroll: 2,
  //         },
  //       },
  //     ],
  //   };
  const expertiseData = [
    {
      title: "Beach Escapes",
      description: " Picture yourself lounging on white sandy beaches, the warm sun on your skin, and the sound of waves crashing nearby. Explore tropical paradises like the Maldives, Bora Bora, and Phuket, where relaxation and luxury await."
    },
    {
      title: "City Adventures",
      description: "From the dazzling skyline of New York City to the historic charm of Paris, the world’s cities are filled with exciting things to do, see, and experience. Whether it’s indulging in fine dining, shopping in designer boutiques, or visiting world-renowned museums, our city escapes offer endless possibilities."
    },
    {
      title: "Nature and Wildlife",
      description: "For nature lovers and wildlife enthusiasts, we offer trips to the most scenic and diverse landscapes on the planet. Go on safari in Kenya, hike through the rainforests of Costa Rica, or immerse yourself in the natural wonders of New Zealand."
    },
    {
      title: "Cultural Journeys",
      description: "Dive deep into the heart of the world’s cultures. From exploring ancient temples in Egypt to walking through the vibrant streets of Tokyo, our cultural journeys give you a chance to learn, experience, and connect with the local traditions and histories of each destination."
    }
  ];
  const curatedTravelExperiencesData = [
    {
      title: "Luxury Escapes",
      description: " Indulge in the finest accommodations, private tours, and VIP experiences. From five-star resorts to private yacht charters, our luxury escapes are designed for those who seek the best in comfort and elegance."
    },
    {
      title: "Adventure Travel",
      description: "Whether it’s hiking the Inca Trail, diving in the Great Barrier Reef, or trekking to Everest Base Camp, our adventure travel experiences cater to those who seek an adrenaline rush and a challenge."
    },
    {
      title: "Family Getaways",
      description: "Traveling with the family? We offer family-friendly destinations and activities that are perfect for all ages. From theme parks to nature reserves, we ensure your family has fun while making memories that last a lifetime."
    },
    {
      title: "Wellness Retreats",
      description: "Unplug and unwind with our wellness retreats. Whether it's yoga in Bali or a detox retreat in Thailand, our wellness experiences are designed to restore your body, mind, and soul."
    }
  ];
  return (
    <div className="overflow-x-hidden">

      <div className="pt-[120px] z-0">
        <div>
          <div class="bg-[#F2F2F2] h-[200px] lg:h-[354px] flex items-center justify-center">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 ">
              <div className="text-center">
                <h2 className="lg:text-7xl md:text-5xl text-4xl font-bold py-8">Discover</h2>
              </div>
            </div>
          </div>
          <div className="bg-white py-12 mt:mt-6 lg:mt-12">
            <div className="max-w-7xl md:px-5 mx-auto px-4 sm:px-6 lg:px-8">
              <div className="text-center">
                <h2 className="md:text-5xl text-3xl leading-10  font-bold mb-4">Explore Our Destinations</h2>
                <p className="mt-2 text-gray-600">The world is full of incredible places to visit, and we're here to help you find the ones that match your travel dreams. From the golden beaches of Bali to the majestic mountains of the Swiss Alps, discover destinations that offer unique experiences, stunning landscapes, and rich cultures. Let Marvalist guide you to the destinations that will leave you with memories to cherish forever.</p>
              </div>
              <div className="mt-8 grid gap-8 md:grid-cols-2 lg:grid-cols-4 md:pt-10">
                {expertiseData.map((item, index) => (
                  <div
                    key={index}
                    className="bg-gray-100 p-6 rounded-lg "
                  >
                    <h3 className="text-lg font-bold text-gray-900">{item.title}</h3>
                    <p className="mt-2 text-gray-600">{item.description}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
          <div class="max-w-7xl px-5 mx-auto">
            <div className="mb-10 flex flex-col md:flex-row md:gap-4 gap-10 items-center md:pt-10  justify-between px-4 md:px-0">
              <div className="lg:max-w-[450px]">
                <p className=" md:text-5xl text-4xl leading-10  font-bold mb-4">
                  Discover with <span className="text-primary">Marvalist</span>
                </p>

                <p className="text-[#838189] text-lg ">
                  Welcome to the world of endless possibilities. At Marvalist, we believe that the best way to experience the world is through exploration. Our "Discover" page is your gateway to exciting destinations, curated itineraries, and unforgettable travel experiences. Whether you're planning a relaxing beach getaway, an adrenaline-pumping adventure, or a cultural exploration, we’ve got something to suit every type of traveler.
                </p>
                <div className="pt-10 ">
                <Link href="/contact-us">
                  <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full bg-[#0689BE] text-base font-semibold">
                    Contact Us
                  </button>
                  </Link>
                </div>
              </div>
              <div className="">
                <Image
                  src={discover}
                  alt=""
                  className="w-[344px] h-[100%] sm:w-[370px] sm:h-[100%]  md:w-[900px] md:h-[100%] lg:w-[500px] lg:h-[100%] object-cover"
                />
              </div>
            </div>
          </div>
          <div className="bg-white py-12 mt:mt-6 lg:mt-12">
            <div className="max-w-7xl md:px-5 mx-auto px-4 sm:px-6 lg:px-8">
              <div className="text-center">
                <h2 className="md:text-5xl text-3xl leading-10  font-bold mb-4">Curated Travel Experiences</h2>
                <p className="mt-2 text-gray-600">At Marvalist, we believe every traveler is unique, and so is their ideal trip. That’s why we offer a wide range of curated travel experiences, from luxury tours to adventurous expeditions. We work with you to design the perfect itinerary based on your interests, schedule, and budget, so you can make the most of your time away.</p>
              </div>
              <div className="mt-8 grid gap-8 md:grid-cols-2 lg:grid-cols-4 md:pt-10">
                {/* Expertise Card */}
                {curatedTravelExperiencesData.map((item, index) => (
                  <div
                    key={index}
                    className="bg-gray-100 p-6 rounded-lg "
                  >
                    <h3 className="text-lg font-bold text-gray-900">{item.title}</h3>
                    <p className="mt-2 text-gray-600">{item.description}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
          <div className="bg-white md:py-12 mt:mt-6 lg:mt-12">
            <div className="max-w-7xl md:px-5 mx-auto px-4 sm:px-6 lg:px-8">
              <div className="text-center">
                <h2 className="md:text-5xl text-3xl leading-10  font-bold mb-4">Begin Your Adventure with Marvalist</h2>
              </div>
              <div className="pt-5">
                <p className="text-[#838189] text-lg text-center">
                  Your next adventure is just a click away. Browse through our selection of carefully curated travel experiences, discover new destinations, and let us take care of all the details. At Marvalist, we are committed to creating extraordinary trips that will exceed your expectations.<br />
                  Ready to embark on the journey of a lifetime? Explore the world with us, and let your adventure begin.
                </p>
              </div>
              <div className="pt-5 text-center">
                <Link href="/contact-us">
                  <button className="capitalize shadow-custom_blue  py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full bg-[#0689BE] text-base font-semibold">
                    Contact Us
                  </button>
                </Link>
              </div>
            </div>
          </div>
        </div>

        <div className="  md:h-[641px] bg-secondary  pb-16 mt-10">
          <div className="relative mx-auto  max-w-7xl md:h-[641px]">
            <Image
              className=" absolute z-0  top-0 bottom-0 left-0  object-cover  xl:max-w-7xl lg:max-w-[1000px]  md:max-w-[800px] sm:max-w-[600px]  max-w-[350px] md:h-[641px]"
              src={background}
              alt="Background-Image"
            />
            <div className="md:h-[641px] flex flex-col gap-10 justify-center  px-8 relative z-1">
              <div className="text-center flex flex-col items-center">
                <p className="text-primary text-2xl  py-7 font-normal ">
                  Subscribe to our Newsletter
                </p>
                <p className="text-white md:text-5xl text-3xl pb-7  max-w-[900px]">
                  Prepare yourself & let’s explore the beauty of the world
                </p>
              </div>
              <div className=" flex md:flex-row flex-col md:gap-4 gap-4 justify-center">
                <div className="relative w-full lg:w-[60%]">
                  <input
                    type="text"
                    placeholder="Your Email"
                    className="bg-white px-10 py-3 rounded-3xl w-full outline-none h-[50px]"
                  />
                  <FontAwesomeIcon
                    icon={faEnvelope}
                    className=" absolute left-3 md:top-4 top-3 h-[19px] w-[19px]"
                  />
                </div>
                <button className="bg-primary rounded-3xl py-2 px-5 font-semibold text-[14px] text-white md:min-w-[170px]">
                  Subscribe
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  );
}


export default page;

