"use client";
import Image from "next/image";
import React from "react";
import Slider from "react-slick";
import { useSelector } from "react-redux";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import homeTop from "../../../../public/assets/userLayouts/homeTop.png";
import explore from "../../../../public/assets/userLayouts/explore.svg";
import image1 from "../../../../public/assets/userLayouts/img1.png";
import image2 from "../../../../public/assets/userLayouts/img2.png";
import image3 from "../../../../public/assets/userLayouts/img3.png";
import image4 from "../../../../public/assets/userLayouts/img4.png";
import image5 from "../../../../public/assets/userLayouts/img5.png";
import Link from "next/link";
const page = () => {
  const sliderData = [
    {
      img: image1,
      link: "/",
    },
    {
      img: image2,
      link: "/",
    },
    {
      img: image3,
      link: "/",
    },
    {
      img: image4,
      link: "/",
    },
    {
      img: image5,
      link: "/",
    },
  ];
  const userDetail = useSelector((state) => state.auth.userDetail);
  var settings = {
    infinite: false,
    speed: 500,
    slidesToShow: 5,
    slidesToScroll: 5,
    initialSlide: 0,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 2,
          infinite: true,
        },
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
        },
      },
    ],
  };
  return (
    <div className="">
      <div className="max-w-7xl px-5 mx-auto ">
        <div className="py-10">
          <div className="flex flex-col md:flex-row md:gap-4 gap-10 items-center  justify-between px-4 md:px-0">
            <div className="lg:max-w-[482px]">
              <div className=" ">
                <button className="w-[190px] flex items-center justify-center shadow-xl bg-white p-2  rounded-full text-[#0689BE] text-[14px] ">
                  Explore the world!
                  <Image src={explore} alt="Explore" className="ml-2 w-5 h-5" />
                </button>
              </div>
              <p className="xl:text-7xl text-4xl py-8 font-bold">
                <span className="  ">
                  Travel
                  <span className="text-[#0689BE] ml-2">Top Destination </span>
                  Of The World
                </span>
              </p>
              <p className="text-[#838189] text-lg ">
                We always make our customer happy by providing as many choices
                as possible
              </p>
              <div className="pt-10 flex gap-4 flex-wrap">
                <Link  href={userDetail?.role === 'user' ? '/flights' : '/sign-up'}>
                <button className=" shadow-custom_blue py-1 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold leading-10">
                  Get Started
                </button>
                </Link>
                <Link href="/about-us">
                <button className="shadow-custom py-1 px-5 min-w-[170px] text-center text-[#000000] rounded-full  bg-white text-base font-semibold bor leading-10">
                  Learn More
                </button>
                </Link>   
              </div>
            </div>
            <div className="">
              <Image
                src={homeTop}
                alt=""
                className="w-[344px] h-[164px] sm:w-[370px] sm:h-[170px]  md:w-[650px] md:h-[250px] lg:w-[700px] lg:h-[320px] object-contain"
              />
            </div>
          </div>
        </div>
        <div className=" py-10">
          <Slider {...settings}>
            {sliderData.map((item, index) => (
              <div key={index} className=" text-center ">
                <Link href={item.link} className="">
                  <Image src={item.img} alt="" className="h-[32px] mx-auto" />
                </Link>
              </div>
            ))}
          </Slider>
        </div>
      </div>
    </div>
  );
};

export default page;
