import axios from "axios";
import Cookies from "js-cookie";

const authToken = Cookies.get("authToken");
const baseURL = "https://tracking.logoinnovators.com/backend/api/";
const axiosInstance = axios.create({
  baseURL,
  headers: {
    "Content-Type": "application/json",
  },
});

async function GetRequest(endpoint, params = {}, headers = {}) {
  try {
    const res = await axiosInstance.get(endpoint, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    console.error("Error in GetRequest:", error);
    throw error;
  }
}

// POST request
async function PostLoginAndSignup(endpoint, data, headers = {}) {
  try {
    const res = await axiosInstance.post(endpoint, data, {
      headers: { ...axiosInstance.defaults.headers, ...headers },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}
async function PostRequest(endpoint, data, params = {}, headers = {}) {
  try {
    console.log("hfgasgasy");
    const res = await axiosInstance.post(endpoint, data, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    console.log("result :", res.data);
    return res.data;
  } catch (error) {
    throw error;
  }
}

// DELETE request
async function DeleteRequest(endpoint, headers = {}) {
  try {
    const res = await axiosInstance.delete(endpoint, {
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

// PUT request
async function PutRequest(endpoint, data, params = {}, headers = {}) {
  try {
    const res = await axiosInstance.put(endpoint, data, {
      params,
      headers: {
        ...axiosInstance.defaults.headers,
        Authorization: `Bearer ${authToken}`,
        ...headers,
      },
    });
    return res.data;
  } catch (error) {
    throw error;
  }
}

export {
  GetRequest,
  PostLoginAndSignup,
  PostRequest,
  DeleteRequest,
  PutRequest,
};
