"use client";
import React, { useState, useEffect } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faBars,
  faBell,
  faXmark,
  faUser,
  faTachometerAlt,
} from "@fortawesome/free-solid-svg-icons";

import navLogo from "../../../../../public/assets/sidebar/nav-logo.png";
import logoutLogo from "../../../../../public/assets/sidebar/logout.png";
import userLogo from "../../../../../public/assets/sidebar/user.png";
import moneyLogo from "../../../../../public/assets/sidebar/money.png";
import avatar from "../../../../../public/assets/profile/Avatar.png";
import loginSuccessIcon from "../../../../../public/assets/loginForm/login-success.svg";
import Image from "next/image";
import Link from "next/link";
import { usePathname, useRouter } from "next/navigation";
import { useSelector } from "react-redux";
import Cookies from "js-cookie";
import toast from "react-hot-toast";
import { useDispatch } from "react-redux";
import { userLogout } from "@/redux/authSlice";
import AvatarDropdown from "../../avatardropdown/avatardropdown";

// Updated import
const Modal = ({ isModalVisible, closeModal }) => {
  return (
    <div
      className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${
        isModalVisible
          ? "opacity-100 pointer-events-auto"
          : "opacity-0 pointer-events-none"
      } transition-opacity duration-500 z-50`}
    >
      <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
        <Image src={loginSuccessIcon} alt="" className=" max-w-[45px] " />
        <h2
          className="text-xl font-bold mt-3 text-center"
          style={{ color: "#0689BE" }}
        >
          Log out Successful
        </h2>
      </div>
    </div>
  );
};
const Logout = ({
  isModalVisibleLogout,
  closeModalLogout,
  messageLogout,
  iconLogout,
  onConfirmLogout,
  setIsModalVisibleLogout,
}) => {
  return (
    <div
      className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex  items-center justify-center ${
        isModalVisibleLogout
          ? "opacity-100 pointer-events-auto"
          : "opacity-0 pointer-events-none"
      } transition-opacity duration-500 z-50`}
    >
      <div className="bg-white rounded-lg shadow-lg p-6 w-[450px] relative  mx-4 sm:mx-0">
        <h2
          className="text-xl font-bold text-left"
          style={{ color: "#0689BE" }}
        >
          Confirmation
        </h2>
        <p class="text-[#838189] text-[14px] mt-1">
          Are you sure you want to log out?
        </p>
        <div class="pt-10 flex gap-4 justify-end">
          <button
            class="shadow-custom py-1 w-[130px] text-center text-[#000000] rounded-full  bg-white text-[16px] font-bold "
            onClick={() => setIsModalVisibleLogout(false)}
          >
            Cancel
          </button>
          <button
            class=" shadow-custom_blue py-1 w-[130px] text-center text-white rounded-full  bg-[#0689BE] text-[16px] font-bold"
            onClick={() => {
              onConfirmLogout();
              setIsModalVisibleLogout(false);
            }}
          >
            Log out
          </button>
        </div>
      </div>
    </div>
  );
};
const SideBar = () => {
  const pathname = usePathname();
  const router = useRouter();
  const dispatch = useDispatch();
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [isModalVisibleLogout, setIsModalVisibleLogout] = useState(false);
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const linkClasses = (path) =>
    `flex gap-3 py-3 ${
      pathname.startsWith(path) ? "bg-[#0689BE] rounded-md text-white" : ""
    }`;
  const closeModalLogout = () => {
    setIsModalVisibleLogout(false);
  };
  const [isSidebarOpen, setIsSidebarOpen] = useState(false);
  useEffect(() => {
    const timer = setTimeout(() => {
      setIsModalVisible(false);
    }, 1000); // 500ms delay

    return () => clearTimeout(timer); // Cleanup on component unmount
  }, []);

  const toggleSidebar = () => {
    setIsSidebarOpen(!isSidebarOpen);
  };
  const closeModal = () => {
    setIsModalVisible(false);
  };
  const handleLogout = () => {
    // Clear the cookies
    dispatch(userLogout(null));
    Cookies.remove("authToken");
    Cookies.remove("role");
    localStorage.clear();
    // Redirect to the login page
    // toast.success("Logout Successful", {
    //   position: "top-center",
    // });
    setIsModalVisible(true);
    setTimeout(() => {
      setIsModalVisible(false); // Hide modal
      router.push("/login"); // Redirect to login page
    }, 1000);
  };

  return (
    <div>
      <Modal isModalVisible={isModalVisible} closeModal={closeModal} />
      <Logout
        isModalVisibleLogout={isModalVisibleLogout}
        closeModal={closeModalLogout}
        onConfirmLogout={handleLogout}
        setIsModalVisibleLogout={setIsModalVisibleLogout}
      />
      {/* Mobile View  */}
      <div className="fixed z-20 lg:hidden sm:h-[100px] w-full bg-[#0689BE] rounded-bl-[50px] rounded-br-[50px] md:px-10 sm:px-8 px-4 py-6 flex items-center">
        <div className="w-full flex justify-between items-center">
          <div>
            <button onClick={toggleSidebar}>
              <FontAwesomeIcon icon={faBars} className="h-6 w-6 text-white" />
            </button>
          </div>
          <div className="flex gap-4">
            <button>
              <FontAwesomeIcon icon={faBell} className="h-6 w-6 text-white" />
            </button>
            {/* <Image src={avatar} alt="profile" className="h-8 w-8" /> */}
            <AvatarDropdown />
            {/* <img
              src={
                globalProfileImg
                  ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`
                  : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"
              }
              alt="Profile Picture"
              className="w-10 h-10 rounded-full object-cover"
            /> */}
          </div>
        </div>
      </div>

      {/* Desktop View  */}
      <div
        className={`fixed lg:block ${
          isSidebarOpen ? "block" : "hidden"
        } w-[260px] bg-[#FFFFFF] min-h-screen z-20`}
      >
        <div className="min-h-screen w-full flex flex-col justify-between">
          <div>
            <div className="flex justify-center mt-6">
              <Image
                className="h-full w-[170px] object-cover"
                src={navLogo}
                alt="nav-logo"
              />
            </div>
            <div className="px-4 mt-10">
              <ul className="text-[#031926] flex flex-col text-[15px] font-semibold gap-1">
                <li>
                  <Link
                    href="/dashboard"
                    className={`${linkClasses(
                      "/dashboard"
                    )} flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group`}
                  >
                    <FontAwesomeIcon icon={faTachometerAlt} />
                    Dashboard
                  </Link>
                </li>
                <li>
                  <Link
                    href="/users"
                    className={`${linkClasses(
                      "/users"
                    )} flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group`}
                  >
                    <FontAwesomeIcon icon={faUser} />
                    Users
                  </Link>
                </li>
                <li>
                  <Link
                    href="/billingsubscription"
                    className={`${linkClasses(
                      "/billingsubscription"
                    )} flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group`}
                  >
                    <Image
                      src={moneyLogo}
                      alt="billing-logo"
                      // className="h-5 w-5"
                      className={`h-5 w-5 ${
                        pathname === "/billingsubscription" ||
                        pathname === "/billingsubscription/addsubscription"
                          ? "filter brightness-0 invert"
                          : "group-hover:filter group-hover:brightness-0 group-hover:invert"
                      }`}
                    />
                    Billing & Subscription
                  </Link>
                </li>
              </ul>
            </div>
          </div>
          {/* <div className="border-t border-gray-400 py-4 pl-8">
            <button
              onClick={() => setIsModalVisibleLogout(true)}
              className="text-[#031926] flex gap-2 items-center text-lg font-normal"
            >
              <Image src={logoutLogo} alt="logout-logo" className="h-5 w-5" />
              Log out
            </button>
          </div> */}
        </div>
      </div>

      {isSidebarOpen && (
        <div
          className="fixed inset-0 bg-black opacity-30 z-10 lg:hidden"
          onClick={toggleSidebar}
        >
          <button
            className="absolute z-20 right-4 top-4 text-white"
            onClick={toggleSidebar}
          >
            <FontAwesomeIcon
              icon={faXmark}
              size="2x"
              className="text-white opacity-100"
            />
          </button>
        </div>
      )}
    </div>
  );
};

export default SideBar;
