import React, { useEffect, useState } from "react";
import download from "../../../../../public/assets/subscription/download.png";
import search from "../../../../../public/assets/subscription/search.png";
import arrowUpDown from "../../../../../public/assets/subscription/arrow-up-down.png";
import Image from "next/image";
import moment from "moment/moment";

const AdminBilling = ({ usersData }) => {
  const [searchTerm, setSearchTerm] = useState("");
  const [filteredData, setFilteredData] = useState(usersData);

  const handleSearch = (e) => {
    const value = e.target.value;
    setSearchTerm(value);
  };

  useEffect(() => {
    if (searchTerm === "") {
      setFilteredData(usersData);
    } else {
      const lowercasedTerm = searchTerm.toLowerCase();
      const filtered = usersData.filter((data) => {
        return (
          data?.id.toString().includes(lowercasedTerm) ||
          data?.plan.toLowerCase().includes(lowercasedTerm) ||
          data?.status.toLowerCase().includes(lowercasedTerm)
        );
      });
      setFilteredData(filtered);
    }
  }, [searchTerm, usersData]);

  return (
    <div>
      {usersData === null ? (
        <div className="md:h-[354px] h-[250px] flex items-center justify-center border border-[#E2E8F0] p-4 rounded-2xl mt-4">
          <div class="flex justify-center items-center bg-white">
            <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
          </div>
        </div>
      ) : usersData?.length <= 0 && searchTerm.length == 0 ? (
        <div className="md:h-[354px] h-[250px] flex items-center justify-center">
          <p className="text-[18px] text-center">
            Currently, there are no billing records available.
          </p>
        </div>
      ) : (
        <div className={`Billing Section`}>
          <div className="border border-[#E2E8F0] p-4 rounded-2xl mt-6">
            <div className="flex justify-between items-center mb-4 flex-wrap">
              <span className="text-[#667085] font-normal text-[12px]">
                Total {filteredData?.length} billings
              </span>
              <div className="flex gap-3">
                <div className="relative">
                  <input
                    type="text"
                    className=" w-[200px] md:w-[272px] h-full  pl-8 bg-[#F6F9FB] rounded-md outline-none"
                    placeholder="Search"
                    value={searchTerm}
                    onChange={handleSearch}
                  />
                  <Image
                    src={search}
                    alt="search"
                    className=" absolute top-2 left-1"
                  />
                </div>
                <button className="bg-[#0689BE] p-2 rounded-md">
                  <Image src={download} alt="download" className="" />
                </button>
              </div>
            </div>
            <div className="overflow-x-auto border border-[#E2E8F0] rounded-2xl h-[354px] md:h-[600px] overflow-y-auto">
              <table className="table-auto w-full min-w-[800px]">
                <thead className="text-md font-bold capitalize py-4 text-black bg-gray-50 sticky top-0 z-10">
                  <tr>
                    <th className="p-2 pl-4 whitespace-nowrap">
                      <div className="font-semibold text-left flex items-center gap-2">
                        <input
                          type="checkbox"
                          className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                        />
                        <span className=" flex  items-center gap-2">
                          billing id
                          <Image src={arrowUpDown} alt="" className="" />
                        </span>
                      </div>
                    </th>
                    <th className="p-2 py-4 whitespace-nowrap">
                      <div className="font-semibold text-left">
                        <span className=" flex  items-center gap-2">
                          Subscription
                          <Image src={arrowUpDown} alt="" className="" />
                        </span>
                      </div>
                    </th>
                    <th className="p-2 whitespace-nowrap">
                      <div className="font-semibold text-left">
                        <span className=" flex  items-center gap-2">
                          Payment
                          <Image src={arrowUpDown} alt="" className="" />
                        </span>
                      </div>
                    </th>
                    <th className="p-2 whitespace-nowrap">
                      <div className="font-semibold text-left">Status</div>
                    </th>
                    <th className="p-2 whitespace-nowrap">
                      <div className="font-semibold text-left">
                        Payment Date
                      </div>
                    </th>
                  </tr>
                </thead>
                <tbody className="text-sm divide-y divide-gray-100">
                  {filteredData?.map((data, index) => {
                    return (
                      <tr key={index}>
                        <td className="p-2 pl-4 whitespace-nowrap">
                          <div className="flex items-center">
                            <div className="font-medium text-gray-800 flex gap-2 items-center">
                              <input
                                type="checkbox"
                                className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                              />
                              <span className="uppercase flex  items-center gap-2">
                                #{data?.id}
                              </span>
                            </div>
                          </div>
                        </td>
                        <td className="p-2 whitespace-nowrap">
                          <div className="text-left">
                            <p className="text-[#1F2336] font-normal">
                              {data?.plan}
                            </p>
                            <p className="text-[#9A9EAD]">ID:{data?.id}</p>
                          </div>
                        </td>
                        <td className="p-2 whitespace-nowrap">
                          <div className="text-left text-[#1F2336] font-normal">
                            ${data?.price}
                          </div>
                        </td>
                        <td className=" whitespace-nowrap">
                          <div
                            className={`text-[#1F2336] font-normal text-[14px] text-left`}
                          >
                            <span
                              className={`p-2 rounded-3xl text-white ${
                                data.status === "active"
                                  ? "bg-[#52B98E]"
                                  : "bg-[#FF3F3F]"
                              }`}
                            >
                              {data?.status}
                            </span>
                          </div>
                        </td>
                        <td className="p-2 whitespace-nowrap">
                          <div className="text-[#1F2336] font-normal text-left">
                            {moment(data?.created_at).format("DD-MM-YYYY")}
                          </div>
                        </td>
                      </tr>
                    );
                  })}
                </tbody>
              </table>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

export default AdminBilling;
