"use client";
import React, { useEffect, useState } from "react";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import Slider from "react-slick";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCheck } from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";
import { DeleteRequest, GetRequest } from "@/app/axios/axiosRequests";
import toast from "react-hot-toast";
import { useGetSubsPlansQuery } from "@/services/Api";
import { useRouter } from "next/navigation";

const AdminSubscription = () => {
  const [plans, setPlans] = useState([]);
  const router = useRouter();

  const handleDeletePlan = async (planId) => {
    const confirmed = window.confirm(
      "Are you sure you want to delete this plan?"
    );
    if (confirmed) {
      try {
        await DeleteRequest(`/admin/subscription-plans/${planId}`);
        toast.success("Plan deleted successfully", { position: "top-center" });
        setPlans(plans.filter((plan) => plan.id !== planId));
      } catch (error) {
        console.error("Failed to delete subscription plan", error);
        toast.error("Failed to delete plan", { position: "top-center" });
      }
    }
  };
  useEffect(() => {
    const slickList = document.querySelector(".slick-list");

    if (slickList) {
      slickList.style.paddingTop = "20px";
    }
  }, []);
  const { data: getSubsPlans, refetch: getSubsPlansRefetch } =
    useGetSubsPlansQuery();

  useEffect(() => {
    if (getSubsPlans) {
      setPlans(getSubsPlans?.plans);
    }
  }, [getSubsPlans]);

  useEffect(() => {
    getSubsPlansRefetch();
  }, []);

  const editPlanHandler = (plan) => {
    router.push(`/billingsubscription/updatesubscription?id=${plan?.id}`);
  };

  var settings = {
    infinite: false,
    speed: 500,
    slidesToShow: 4,
    slidesToScroll: 1,

    responsive: [
      {
        breakpoint: 1400,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          infinite: true,
          dots: true,
        },
      },
      {
        breakpoint: 1200,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
          dots: true,
        },
      },

      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <div className="">
      <style jsx>{`
        .plan-container {
          border: 1px solid #ccc;
          border-radius: 20px;
          min-height: 550px;
          width: 200px;
          padding: 16px;
          background-color: #fff;
          color: #1d2127;
          transition: all 0.3s ease-in-out;
        }

        .plan-container:hover {
          color: white;
          background-color: #0689be;
          transform: translateY(-20px); /* Moves the element up on hover */
        }
      `}</style>
      <div className="mt-4 text-right">
        <Link
          href="/billingsubscription/addsubscription"
          // className=" p-2 rounded-md text-base font-bold text-[#484F61] border border-[#484F61]"
          className="py-2 bg-[#0689BE] w-[170px] rounded-md border border-[#0689BE] text-white text-center inline-block px-4 hover:bg-[#0689BE] hover:bg-[#fff] hover:text-[#0689BE]"
        >
          Add Subscription
        </Link>
      </div>
      {getSubsPlans === undefined ? (
        <div className="h-[354px] flex items-center justify-center">
          Subscription column is loading...
        </div>
      ) : (
        <div className="slider-container">
          <Slider {...settings}>
            {plans &&
              plans.map((plan) => (
                <div
                  key={plan.id}
                  className="group  plan-container hover:text-white hover:bg-[#0689BE] my-8 border text-[#1D2127] border-gray-300 rounded-3xl  w-[20px] py-4 px-4"
                >
                  <div className="flex flex-col gap-2 justify-between min-h-[600px]">
                    <div className="">
                      <p className="text-[14px]  font-semibold">{plan.name}</p>
                      <div className="flex justify-between">
                        <p className="flex flex-col  gap-2 my-4">
                          <span className="  text-[27px] font-extrabold">
                            ${plan.amount_per_year}
                          </span>
                          <span className="w-[100px] text-[#B9BEC1] text-[10px] font-normal">
                            per editor/month billed monthly
                          </span>
                        </p>
                        <p className="flex flex-col  gap-2 my-4">
                          <span className="  text-[27px] font-extrabold">
                            ${plan.amount_per_month}
                          </span>
                          <span className="w-[100px] text-[#B9BEC1] text-[10px] font-normal">
                            per editor/month billed monthly
                          </span>
                        </p>
                      </div>

                      <div className="">
                        {plan.benefits && (
                          <p className="flex flex-col gap-2">
                            <span className="font-semibold">Benefits:</span>
                            {plan.benefits.split(",").map((feature, index) => (
                              <p
                                key={index}
                                className="flex items-center gap-2"
                              >
                                <span className="bg-[#EBEFF0] group-hover:bg-black rounded-full h-3 w-3 flex items-center justify-center">
                                  <FontAwesomeIcon
                                    icon={faCheck}
                                    className="w-2 h-2 text-gray-400 group-hover:text-white"
                                  />
                                </span>
                                {feature.trim()}
                              </p>
                            ))}
                          </p>
                        )}
                      </div>
                    </div>
                    <div className="flex gap-3">
                      <button
                        onClick={() => editPlanHandler(plan)}
                        className="bg-[#0689BE] py-2 text-center w-full rounded-xl text-white group-hover:text-[#0689BE] group-hover:bg-white"
                      >
                        Edit Plan
                      </button>
                      <button
                        onClick={() => handleDeletePlan(plan.id)}
                        className="bg-[#0689BE] py-2 text-center w-full rounded-xl text-white group-hover:text-[#0689BE] group-hover:bg-white"
                      >
                        Delete Plan
                      </button>
                    </div>
                  </div>
                </div>
              ))}
          </Slider>
        </div>
      )}
    </div>
  );
};

export default AdminSubscription;
