"use client";
import React, { useEffect, useState } from "react";
import Breadcrumbs from "../../breadcrumbs/Breadcrumbs";
import bellLogo from "../../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../../public/assets/profile/Avatar.png";
import Image from "next/image";
import Billing from "./AdminBilling";
import AdminBilling from "./AdminBilling";
import AdminSubscription from "./AdminSubscription";
import { useGetAdminSubsQuery } from "@/services/Api";
import { useSelector } from "react-redux";
import AvatarDropdown from "../../avatardropdown/avatardropdown";

const BillingSubscription = () => {

  const [openBillingSection, setOpenBillingSection] = useState(true);
  const [openSubscriptionSection, setOpenSubscriptionSection] = useState(false);
  const [userBillingData, setUserBillingData] = useState(null);
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);

  const {
    data: getAdminSubs,
    refetch: getAdminSubsRefetch
  } = useGetAdminSubsQuery();

  // console.log("getAdminSubs", getAdminSubs);

  useEffect(()=>{
    if(getAdminSubs !== undefined){
      
      let subscribedFilter = getAdminSubs.users.filter(item => item.subscriptions.length > 0);
      let subscribedData = []
      subscribedFilter.map(item => subscribedData.push(item.subscriptions))
      
      setUserBillingData(subscribedData.flat());
      
    } else{
      setUserBillingData(null);
    }
  }, [getAdminSubs])


  useEffect(() => {
    getAdminSubsRefetch();
  }, []);

  const toggleSubscriptionSection = () => {
    setOpenSubscriptionSection(true);
    setOpenBillingSection(false);
  };

  const toggleBillingSection = () => {
    setOpenBillingSection(true);
    setOpenSubscriptionSection(false);
  };

  return (
    <div className=" lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
        <p class=" md:text-3xl text-2xl leading-10  font-bold ">Billing & Subscription</p>
        <div className=" hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
          <AvatarDropdown />
        </div>
      </div>
      <div className="bg-white rounded-2xl md:py-4 lg:px-6 ">
        <div className=" flex gap-4 border-b">
          <button
            className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${openBillingSection
              ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
              : "text-[#031926]"
              } `}
            onClick={toggleBillingSection}
          >
            Billing
          </button>
          <button
            className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${openSubscriptionSection
              ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
              : "text-[#031926]"
              } `}
            onClick={toggleSubscriptionSection}
          >
            Subscription
          </button>
        </div>
        {/* {openBillingSection && !openSubscriptionSection && <AdminBilling usersData={getAdminSubs?.users} />} */}
        {openBillingSection && !openSubscriptionSection && <AdminBilling usersData={userBillingData} />}
        {openSubscriptionSection && !openBillingSection && (
          <AdminSubscription />
        )}
      </div>
    </div>
  );
};

export default BillingSubscription;
