"use client";
import React, { useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowRight } from "@fortawesome/free-solid-svg-icons";
import { useFormik } from "formik";
import * as Yup from "yup";
import { PostRequest } from "@/app/axios/axiosRequests";
import Link from "next/link";
import toast from "react-hot-toast";
import Image from "next/image";
import bellLogo from "../../../../../../public/assets/profile/bell-logo.png";
import AvatarDropdown from "@/app/components/avatardropdown/avatardropdown";

export default function AddSubscription() {
  const [benefits, setBenefits] = useState([]);
  const [newBenefit, setNewBenefit] = useState("");
  const [planCreatedSuccessful, setPlanCreatedSuccessful] = useState(false);
  const [error, setError] = useState("");

  const validationSchema = Yup.object({
    currency: Yup.string().required("Currency is required"),
    name: Yup.string().required("Subscription name is required"),
    amount_per_month: Yup.number()
      .required("Amount per month is required")
      .positive("Amount must be positive")
      .integer("Amount must be an integer"),
    amount_per_year: Yup.number()
      .required("Amount per year is required")
      .positive("Amount must be positive")
      .integer("Amount must be an integer"),
  });

  const formik = useFormik({
    initialValues: {
      currency: "",
      name: "",
      amount_per_month: "",
      amount_per_year: "",
      benefits: "",
    },
    validationSchema,
    onSubmit: async (values, { setSubmitting }) => {
      const dataToSubmit = {
        ...values,
        benefits: benefits.join(", "), // Join the benefits array into a comma-separated string
      };

      try {
        const response = await PostRequest(
          "/admin/subscription-plans-create",
          dataToSubmit
        );

        if (response) {
          toast.success("Plan Created Successfully", {
            position: "top-center",
          });
          setPlanCreatedSuccessful(true);
        }
      } catch (error) {
        console.error("Error submitting form:", error);
        if (error.response) {
          console.error("Server responded with status:", error.response.status);
          console.error("Response data:", error.response.data);
          setError(error.response.data.error);
        } else if (error.request) {
          console.error("No response received:", error.request);
        } else {
          console.error("Error setting up request:", error.message);
        }
      } finally {
        setSubmitting(false);
      }
    },
  });

  const handleBenefitChange = (e) => {
    setNewBenefit(e.target.value);
  };

  const addBenefitField = () => {
    if (newBenefit.trim() !== "") {
      setBenefits([...benefits, newBenefit]);
      setNewBenefit("");
    }
  };

  return (
    <>
      <div className=" lg:bg-[#F8F9FC] min-h-screen px-4 md:px-8 overflow-x-hidden">
        <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
          <h1 class=" md:text-3xl text-2xl leading-10  font-bold mb-5 lg:mb-0">
            Add Subscription Plan Details
          </h1>
          <div className=" hidden lg:flex items-center gap-4">
            <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
            {/* <img
                          src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
                          alt="Profile Picture"
                          className="w-11 h-11 rounded-full object-cover"
                        /> */}
            <AvatarDropdown />
          </div>
        </div>

        {planCreatedSuccessful ? (
          <div className="flex flex-col justify-center items-center h-[354px] md:h-[600px] border border-[#E2E8F0] rounded-2xl bg-white">
            <h3 className="mb-4 text-xl md:text-2xl font-bold">
              Subscription plan created successfully!
            </h3>
            <Link
              href="/billingsubscription"
              className="text-primary underline "
            >
              Go to Subscription page
            </Link>
          </div>
        ) : (
          <>
            <div className="bg-white   rounded-2xl lg:p-6 ">
              <h3 className="mb-4 text-xl md:text-2xl font-bold hidden lg:block">
                Subscription Plan Details
              </h3>
              <form onSubmit={formik.handleSubmit}>
                <div className="grid grid-cols-1 sm:grid-cols-2 w-full justify-between gap-x-6">
                  <div className="mb-3">
                    <label
                      className="block text-gray-700 text-sm font-bold mb-2"
                      htmlFor="currency"
                    >
                      Currency
                    </label>
                    <input
                      name="currency"
                      type="text"
                      className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                      placeholder="Currency"
                      value={formik.values.currency}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                    />
                    {formik.touched.currency && formik.errors.currency ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.currency}
                      </div>
                    ) : null}
                  </div>
                  <div className="mb-3">
                    <label
                      className="block text-gray-700 text-sm font-bold mb-2"
                      htmlFor="name"
                    >
                      Subscription Name
                    </label>
                    <input
                      name="name"
                      type="text"
                      className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                      placeholder="Professional Plan"
                      value={formik.values.name}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                    />
                    {formik.touched.name && formik.errors.name ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.name}
                      </div>
                    ) : null}
                  </div>
                  <div className="mb-3">
                    <label
                      className="block text-gray-700 text-sm font-bold mb-2"
                      htmlFor="amount_per_month"
                    >
                      Add Price / Month
                    </label>
                    <input
                      name="amount_per_month"
                      type="text"
                      className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                      placeholder="$320"
                      value={formik.values.amount_per_month}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                    />
                    {formik.touched.amount_per_month &&
                    formik.errors.amount_per_month ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.amount_per_month}
                      </div>
                    ) : null}
                  </div>
                  <div className="mb-3">
                    <label
                      className="block text-gray-700 text-sm font-bold mb-2"
                      htmlFor="amount_per_year"
                    >
                      Add Price / Year
                    </label>
                    <input
                      name="amount_per_year"
                      type="text"
                      className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                      placeholder="$320"
                      value={formik.values.amount_per_year}
                      onChange={formik.handleChange}
                      onBlur={formik.handleBlur}
                    />
                    {formik.touched.amount_per_year &&
                    formik.errors.amount_per_year ? (
                      <div className="text-red-500 text-sm">
                        {formik.errors.amount_per_year}
                      </div>
                    ) : null}
                  </div>
                </div>
                <div className="mb-3">
                  <label
                    className="block text-gray-700 text-sm font-bold mb-2"
                    htmlFor="benefits"
                  >
                    Add Benefits
                  </label>
                  <input
                    type="text"
                    className="w-full p-3 border rounded-md bg-gray-100 mb-2 outline-none"
                    placeholder="Benefit"
                    value={newBenefit}
                    onChange={handleBenefitChange}
                  />
                  <div className="text-end">
                    <button
                      type="button"
                      onClick={addBenefitField}
                      className="text-primary text-sm mt-2 underline"
                    >
                      Add more
                    </button>
                  </div>
                </div>
                {benefits.length > 0 && (
                  <div className="mb-3">
                    <h4 className="text-lg font-semibold mb-4">Benefits</h4>
                    <ul className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 list-disc pl-5">
                      {benefits.map((benefit, index) => (
                        <li key={index} className="flex items-center gap-2">
                          <input
                            type="checkbox"
                            checked
                            className="h-4 w-4 accent-primary"
                          />
                          {benefit}
                        </li>
                      ))}
                    </ul>
                  </div>
                )}

                {/* <div className="bg-white p-4 rounded-md mb-6">
              <label
                className="block text-gray-700 text-sm font-bold mb-2"
                htmlFor="currency"
              >
                Currency
              </label>
              <input
                name="currency"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="Currency"
                value={formik.values.currency}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.currency && formik.errors.currency ? (
                <div className="text-red-500 text-sm">
                  {formik.errors.currency}
                </div>
              ) : null}
            </div>

            <div className="bg-white p-4 rounded-md mb-6">
              <label
                className="block text-gray-700 text-sm font-bold mb-2"
                htmlFor="name"
              >
                Subscription Name
              </label>
              <input
                name="name"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="Professional Plan"
                value={formik.values.name}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.name && formik.errors.name ? (
                <div className="text-red-500 text-sm">{formik.errors.name}</div>
              ) : null}
            </div>

            <div className="bg-white p-4 rounded-md mb-6">
              <label
                className="block text-gray-700 text-sm font-bold mb-2"
                htmlFor="amount_per_month"
              >
                Add Price / Month
              </label>
              <input
                name="amount_per_month"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="$320"
                value={formik.values.amount_per_month}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.amount_per_month &&
              formik.errors.amount_per_month ? (
                <div className="text-red-500 text-sm">
                  {formik.errors.amount_per_month}
                </div>
              ) : null}
            </div>

            <div className="bg-white p-4 rounded-md mb-6">
              <label
                className="block text-gray-700 text-sm font-bold mb-2"
                htmlFor="amount_per_year"
              >
                Add Price / Year
              </label>
              <input
                name="amount_per_year"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="$320"
                value={formik.values.amount_per_year}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.amount_per_year &&
              formik.errors.amount_per_year ? (
                <div className="text-red-500 text-sm">
                  {formik.errors.amount_per_year}
                </div>
              ) : null}
            </div>

            <div className="bg-white p-4 rounded-md mb-6">
              <label
                className="block text-gray-700 text-sm font-bold mb-2"
                htmlFor="benefits"
              >
                Add Benefits
              </label>
              <input
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 mb-2 outline-none"
                placeholder="Benefit"
                value={newBenefit}
                onChange={handleBenefitChange}
              />
              <div className="text-end">
                <button
                  type="button"
                  onClick={addBenefitField}
                  className="text-primary text-sm mt-2 underline"
                >
                  Add more
                </button>
              </div>
            </div>

            <div className="p-4 bg-white rounded-md mb-6">
              <h4 className="text-lg font-semibold mb-4">Benefits</h4>
              <ul className="grid grid-cols-2 list-disc pl-5">
                {benefits.map((benefit, index) => (
                  <li key={index} className="flex items-center gap-2">
                    <input
                      type="checkbox"
                      checked
                      className="h-4 w-4 accent-primary"
                    />
                    {benefit}
                  </li>
                ))}
              </ul>
            </div> */}
                <div className=" text-center text-red-500">{error}</div>

                <div className=" flex justify-end mb-5">
                  <button
                    type="submit"
                    className="bg-primary text-white py-2 px-4 rounded-md flex items-center gap-2"
                  >
                    Create
                    <FontAwesomeIcon icon={faArrowRight} />
                  </button>
                </div>
              </form>
            </div>
          </>
        )}
      </div>
      {/* <div className="bg-gray-100 min-h-screen flex justify-center items-center">
        {!planCreatedSuccessful && (
          <div className="rounded-md w-full max-w-3xl">
            <form className="px-8" onSubmit={formik.handleSubmit}>
              <h3 className="text-2xl font-bold text-center mb-6">
                Subscription Plan Details
              </h3>

              <div className="bg-white p-4 rounded-md mb-6">
                <label
                  className="block text-gray-700 text-sm font-bold mb-2"
                  htmlFor="currency"
                >
                  Currency
                </label>
                <input
                  name="currency"
                  type="text"
                  className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                  placeholder="Currency"
                  value={formik.values.currency}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                />
                {formik.touched.currency && formik.errors.currency ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.currency}
                  </div>
                ) : null}
              </div>

              <div className="bg-white p-4 rounded-md mb-6">
                <label
                  className="block text-gray-700 text-sm font-bold mb-2"
                  htmlFor="name"
                >
                  Subscription Name
                </label>
                <input
                  name="name"
                  type="text"
                  className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                  placeholder="Professional Plan"
                  value={formik.values.name}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                />
                {formik.touched.name && formik.errors.name ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.name}
                  </div>
                ) : null}
              </div>

              <div className="bg-white p-4 rounded-md mb-6">
                <label
                  className="block text-gray-700 text-sm font-bold mb-2"
                  htmlFor="amount_per_month"
                >
                  Add Price / Month
                </label>
                <input
                  name="amount_per_month"
                  type="text"
                  className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                  placeholder="$320"
                  value={formik.values.amount_per_month}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                />
                {formik.touched.amount_per_month &&
                formik.errors.amount_per_month ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.amount_per_month}
                  </div>
                ) : null}
              </div>

              <div className="bg-white p-4 rounded-md mb-6">
                <label
                  className="block text-gray-700 text-sm font-bold mb-2"
                  htmlFor="amount_per_year"
                >
                  Add Price / Year
                </label>
                <input
                  name="amount_per_year"
                  type="text"
                  className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                  placeholder="$320"
                  value={formik.values.amount_per_year}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                />
                {formik.touched.amount_per_year &&
                formik.errors.amount_per_year ? (
                  <div className="text-red-500 text-sm">
                    {formik.errors.amount_per_year}
                  </div>
                ) : null}
              </div>

              <div className="bg-white p-4 rounded-md mb-6">
                <label
                  className="block text-gray-700 text-sm font-bold mb-2"
                  htmlFor="benefits"
                >
                  Add Benefits
                </label>
                <input
                  type="text"
                  className="w-full p-3 border rounded-md bg-gray-100 mb-2 outline-none"
                  placeholder="Benefit"
                  value={newBenefit}
                  onChange={handleBenefitChange}
                />
                <div className="text-end">
                  <button
                    type="button"
                    onClick={addBenefitField}
                    className="text-primary text-sm mt-2 underline"
                  >
                    Add more
                  </button>
                </div>
              </div>

              <div className="p-4 bg-white rounded-md mb-6">
                <h4 className="text-lg font-semibold mb-4">Benefits</h4>
                <ul className="grid grid-cols-2 list-disc pl-5">
                  {benefits.map((benefit, index) => (
                    <li key={index} className="flex items-center gap-2">
                      <input
                        type="checkbox"
                        checked
                        className="h-4 w-4 accent-primary"
                      />
                      {benefit}
                    </li>
                  ))}
                </ul>
              </div>
              <div className=" text-center text-red-500">{error}</div>

              <div className=" flex justify-end">
                <button
                  type="submit"
                  className="bg-primary text-white py-2 px-4 rounded-md flex items-center gap-2"
                >
                  Create
                  <FontAwesomeIcon icon={faArrowRight} />
                </button>
              </div>
            </form>
          </div>
        )}
      </div> */}
      
        {/* {planCreatedSuccessful && (
          <div className="flex flex-col justify-center items-center">
            <h1 className="text-4xl font-bold text-black">
              Subscription plan created successfully!
            </h1>
            <Link
              href="/billingsubscription"
              className="text-primary underline "
            >
              Go to Subscription page
            </Link>
          </div>
        )} */}
    </>
  );
}
