// "use client";
// import React, { useEffect, useState } from "react";
// import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
// import { faArrowRight } from "@fortawesome/free-solid-svg-icons";
// import { useFormik } from "formik";
// import * as Yup from "yup";
// import { PostRequest } from "@/app/axios/axiosRequests";
// import Link from "next/link";
// import toast from "react-hot-toast";
// import { useGetSubsPlanByIdQuery } from "@/services/Api";
// import { useSearchParams } from "next/navigation";

// export default function UpdateSubscription() {
//   const [benefits, setBenefits] = useState([]);
//   const [newBenefit, setNewBenefit] = useState("");
//   const [planCreatedSuccessful, setPlanCreatedSuccessful] = useState(false);
//   const [error, setError] = useState("");
//   const searchParams = useSearchParams();
//   const planId = searchParams.get('id');

//   const {
//     data: getSubsPlanById,
//     refetch: getSubsPlanByIdRefetch
//   } = useGetSubsPlanByIdQuery({ id: planId });

//   const validationSchema = Yup.object({
//     currency: Yup.string().required("Currency is required"),
//     name: Yup.string().required("Subscription name is required"),
//     amount_per_month: Yup.number()
//       .required("Amount per month is required")
//       .positive("Amount must be positive")
//       .integer("Amount must be an integer"),
//     amount_per_year: Yup.number()
//       .required("Amount per year is required")
//       .positive("Amount must be positive")
//       .integer("Amount must be an integer"),
//   });

//   const formik = useFormik({
//     initialValues: {
//       currency: "",
//       name: "",
//       amount_per_month: "",
//       amount_per_year: "",
//       benefits: "",
//     },
//     validationSchema,
//     onSubmit: async (values, { setSubmitting }) => {
//       const dataToSubmit = {
//         ...values,
//         benefits: benefits.join(", "),
//       };

//       try {
//         const response = await PostRequest(
//           "/admin/subscription-plans-create",
//           dataToSubmit
//         );

//         if (response) {
//           toast.success("Plan Created Successfully", {
//             position: "top-center",
//           });
//           setPlanCreatedSuccessful(true);
//         }
//       } catch (error) {
//         console.error("Error submitting form:", error);
//         if (error.response) {
//           console.error("Server responded with status:", error.response.status);
//           console.error("Response data:", error.response.data);
//           setError(error.response.data.error);
//         } else if (error.request) {
//           console.error("No response received:", error.request);
//         } else {
//           console.error("Error setting up request:", error.message);
//         }
//       } finally {
//         setSubmitting(false);
//       }
//     },
//   });

//   const handleBenefitChange = (e) => {
//     setNewBenefit(e.target.value);
//   };

//   const addBenefitField = () => {
//     if (newBenefit.trim() !== "") {
//       setBenefits([...benefits, newBenefit]);
//       setNewBenefit("");
//     }
//   };

//   useEffect(() => {
//     getSubsPlanByIdRefetch();
//   }, []);

//   useEffect(() => {
//     if (getSubsPlanById) {
//       const { currency, name, amount_per_month, amount_per_year, benefits: fetchedBenefits } = getSubsPlanById?.plan;

//       formik.setValues({
//         currency,
//         name,
//         amount_per_month,
//         amount_per_year,
//         benefits: fetchedBenefits || "",
//       });

//       // Parse and set benefits as an array
//       setBenefits(fetchedBenefits ? fetchedBenefits.split(", ") : []);
//     }
//   }, [getSubsPlanById]);

//   return (
//     <div className="bg-gray-100 min-h-screen flex justify-center items-center">
//       {!planCreatedSuccessful && (
//         <div className="rounded-md w-full max-w-3xl mb-5">
//           <div className="p-3 bg-white flex justify-between items-center mb-6">
//             <h2 className="text-xl font-semibold">
//               Update Subscription Plan Details
//             </h2>
//           </div>
//           <form className="px-8" onSubmit={formik.handleSubmit}>
//             <h3 className="text-2xl font-bold text-center mb-6">
//               Subscription Plan Details
//             </h3>

//             <div className="bg-white p-4 rounded-md mb-6">
//               <label
//                 className="block text-gray-700 text-sm font-bold mb-2"
//                 htmlFor="currency"
//               >
//                 Currency
//               </label>
//               <input
//                 name="currency"
//                 type="text"
//                 className="w-full p-3 border rounded-md bg-gray-100 outline-none"
//                 placeholder="Currency"
//                 value={formik.values.currency}
//                 onChange={formik.handleChange}
//                 onBlur={formik.handleBlur}
//               />
//               {formik.touched.currency && formik.errors.currency ? (
//                 <div className="text-red-500 text-sm">
//                   {formik.errors.currency}
//                 </div>
//               ) : null}
//             </div>

//             <div className="bg-white p-4 rounded-md mb-6">
//               <label
//                 className="block text-gray-700 text-sm font-bold mb-2"
//                 htmlFor="name"
//               >
//                 Subscription Name
//               </label>
//               <input
//                 name="name"
//                 type="text"
//                 className="w-full p-3 border rounded-md bg-gray-100 outline-none"
//                 placeholder="Professional Plan"
//                 value={formik.values.name}
//                 onChange={formik.handleChange}
//                 onBlur={formik.handleBlur}
//               />
//               {formik.touched.name && formik.errors.name ? (
//                 <div className="text-red-500 text-sm">{formik.errors.name}</div>
//               ) : null}
//             </div>

//             <div className="bg-white p-4 rounded-md mb-6">
//               <label
//                 className="block text-gray-700 text-sm font-bold mb-2"
//                 htmlFor="amount_per_month"
//               >
//                 Add Price / Month
//               </label>
//               <input
//                 name="amount_per_month"
//                 type="text"
//                 className="w-full p-3 border rounded-md bg-gray-100 outline-none"
//                 placeholder="$320"
//                 value={formik.values.amount_per_month}
//                 onChange={formik.handleChange}
//                 onBlur={formik.handleBlur}
//               />
//               {formik.touched.amount_per_month &&
//                 formik.errors.amount_per_month ? (
//                 <div className="text-red-500 text-sm">
//                   {formik.errors.amount_per_month}
//                 </div>
//               ) : null}
//             </div>

//             <div className="bg-white p-4 rounded-md mb-6">
//               <label
//                 className="block text-gray-700 text-sm font-bold mb-2"
//                 htmlFor="amount_per_year"
//               >
//                 Add Price / Year
//               </label>
//               <input
//                 name="amount_per_year"
//                 type="text"
//                 className="w-full p-3 border rounded-md bg-gray-100 outline-none"
//                 placeholder="$320"
//                 value={formik.values.amount_per_year}
//                 onChange={formik.handleChange}
//                 onBlur={formik.handleBlur}
//               />
//               {formik.touched.amount_per_year &&
//                 formik.errors.amount_per_year ? (
//                 <div className="text-red-500 text-sm">
//                   {formik.errors.amount_per_year}
//                 </div>
//               ) : null}
//             </div>

//             <div className="bg-white p-4 rounded-md mb-6">
//               <label
//                 className="block text-gray-700 text-sm font-bold mb-2"
//                 htmlFor="benefits"
//               >
//                 Add Benefits
//               </label>
//               <input
//                 type="text"
//                 className="w-full p-3 border rounded-md bg-gray-100 mb-2 outline-none"
//                 placeholder="Benefit"
//                 value={newBenefit}
//                 onChange={handleBenefitChange}
//               />
//               <div className="text-end">
//                 <button
//                   type="button"
//                   onClick={addBenefitField}
//                   className="text-primary text-sm mt-2 underline"
//                 >
//                   Add more
//                 </button>
//               </div>
//             </div>

//             <div className="p-4 bg-white rounded-md mb-6">
//               <h4 className="text-lg font-semibold mb-4">Benefits</h4>
//               <ul className="grid grid-cols-2 list-disc pl-5">
//                 {benefits.map((benefit, index) => (
//                   <li key={index} className="flex items-center gap-2">
//                     <input
//                       type="checkbox"
//                       checked
//                       className="h-4 w-4 accent-primary"
//                     />
//                     {benefit}
//                   </li>
//                 ))}
//               </ul>
//             </div>
//             <div className=" text-center text-red-500">{error}</div>

//             <div className=" flex justify-end">
//               <button
//                 type="submit"
//                 className="bg-primary text-white py-2 px-4 rounded-md flex items-center gap-2"
//               >
//                 Update
//                 <FontAwesomeIcon icon={faArrowRight} />
//               </button>
//             </div>
//           </form>
//         </div>
//       )}

//       {planCreatedSuccessful && (
//         <div className="flex flex-col justify-center items-center">
//           <h1 className="text-4xl font-bold text-black">
//             Subscription plan created successfully!
//           </h1>
//           <Link href="/billingsubscription" className="text-primary underline ">
//             Go to Subscription page
//           </Link>
//         </div>
//       )}
//     </div>
//   );
// }


"use client";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faArrowRight } from "@fortawesome/free-solid-svg-icons";
import { useFormik } from "formik";
import * as Yup from "yup";
import { PostRequest, PutRequest } from "@/app/axios/axiosRequests"; // Ensure you have a PutRequest utility for updating
import Link from "next/link";
import toast from "react-hot-toast";
import { useGetSubsPlanByIdQuery } from "@/services/Api";
import { useSearchParams } from "next/navigation";

export default function UpdateSubscription() {
  const [benefits, setBenefits] = useState([]);
  const [newBenefit, setNewBenefit] = useState("");
  const [planUpdatedSuccessful, setPlanUpdatedSuccessful] = useState(false);
  const [error, setError] = useState("");
  const searchParams = useSearchParams();
  const planId = searchParams.get("id");

  const { data: getSubsPlanById, refetch: getSubsPlanByIdRefetch } =
    useGetSubsPlanByIdQuery({ id: planId });

  const validationSchema = Yup.object({
    currency: Yup.string().required("Currency is required"),
    name: Yup.string().required("Subscription name is required"),
    amount_per_month: Yup.number()
      .required("Amount per month is required")
      .positive("Amount must be positive")
      .integer("Amount must be an integer"),
    amount_per_year: Yup.number()
      .required("Amount per year is required")
      .positive("Amount must be positive")
      .integer("Amount must be an integer"),
  });

  const formik = useFormik({
    initialValues: {
      currency: "",
      name: "",
      amount_per_month: "",
      amount_per_year: "",
      benefits: "",
    },
    validationSchema,
    onSubmit: async (values, { setSubmitting }) => {
      const dataToSubmit = {
        ...values,
        benefits: benefits.join(", "),
      };

      try {
        const response = await PostRequest(`/admin/subscription-plans/update/${planId}`, dataToSubmit);

        if (response) {
          toast.success("Plan Updated Successfully", {
            position: "top-center",
          });
          setPlanUpdatedSuccessful(true);
        }
      } catch (error) {
        console.error("Error updating plan:", error);
        if (error.response) {
          console.error("Server responded with status:", error.response.status);
          setError(error.response.data.error);
        } else if (error.request) {
          console.error("No response received:", error.request);
        } else {
          console.error("Error setting up request:", error.message);
        }
      } finally {
        setSubmitting(false);
      }
    },
  });

  const handleBenefitChange = (e) => {
    setNewBenefit(e.target.value);
  };

  const addBenefitField = () => {
    if (newBenefit.trim() !== "") {
      setBenefits([...benefits, newBenefit]);
      setNewBenefit("");
    }
  };

  useEffect(() => {
    if (getSubsPlanById) {
      const { currency, name, amount_per_month, amount_per_year, benefits: fetchedBenefits } = getSubsPlanById?.plan;
      formik.setValues({
        currency,
        name,
        amount_per_month,
        amount_per_year,
        benefits: fetchedBenefits || "",
      });

      // Parse and set benefits as an array
      setBenefits(fetchedBenefits ? fetchedBenefits.split(", ") : []);
    }
  }, [getSubsPlanById]);

  return (
    <div className="bg-gray-100 min-h-screen flex justify-center items-center">
      {!planUpdatedSuccessful && (
        <div className="rounded-md w-full max-w-3xl mb-5">
          <div className="p-3 bg-white flex justify-between items-center mb-6">
            <h2 className="text-xl font-semibold">
              Update Subscription Plan Details
            </h2>
          </div>
          <form className="px-8" onSubmit={formik.handleSubmit}>
            <h3 className="text-2xl font-bold text-center mb-6">
              Subscription Plan Details
            </h3>

            {/* Currency Input */}
            <div className="bg-white p-4 rounded-md mb-6">
              <label className="block text-gray-700 text-sm font-bold mb-2" htmlFor="currency">
                Currency
              </label>
              <input
                name="currency"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="Currency"
                value={formik.values.currency}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.currency && formik.errors.currency ? (
                <div className="text-red-500 text-sm">{formik.errors.currency}</div>
              ) : null}
            </div>

            {/* Subscription Name Input */}
            <div className="bg-white p-4 rounded-md mb-6">
              <label className="block text-gray-700 text-sm font-bold mb-2" htmlFor="name">
                Subscription Name
              </label>
              <input
                name="name"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="Professional Plan"
                value={formik.values.name}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.name && formik.errors.name ? (
                <div className="text-red-500 text-sm">{formik.errors.name}</div>
              ) : null}
            </div>

            {/* Price per Month */}
            <div className="bg-white p-4 rounded-md mb-6">
              <label className="block text-gray-700 text-sm font-bold mb-2" htmlFor="amount_per_month">
                Add Price / Month
              </label>
              <input
                name="amount_per_month"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="$320"
                value={formik.values.amount_per_month}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.amount_per_month && formik.errors.amount_per_month ? (
                <div className="text-red-500 text-sm">{formik.errors.amount_per_month}</div>
              ) : null}
            </div>

            {/* Price per Year */}
            <div className="bg-white p-4 rounded-md mb-6">
              <label className="block text-gray-700 text-sm font-bold mb-2" htmlFor="amount_per_year">
                Add Price / Year
              </label>
              <input
                name="amount_per_year"
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 outline-none"
                placeholder="$320"
                value={formik.values.amount_per_year}
                onChange={formik.handleChange}
                onBlur={formik.handleBlur}
              />
              {formik.touched.amount_per_year && formik.errors.amount_per_year ? (
                <div className="text-red-500 text-sm">{formik.errors.amount_per_year}</div>
              ) : null}
            </div>

            {/* Add Benefits */}
            <div className="bg-white p-4 rounded-md mb-6">
              <label className="block text-gray-700 text-sm font-bold mb-2" htmlFor="benefits">
                Add Benefits
              </label>
              <input
                type="text"
                className="w-full p-3 border rounded-md bg-gray-100 mb-2 outline-none"
                placeholder="Benefit"
                value={newBenefit}
                onChange={handleBenefitChange}
              />
              <div className="text-end">
                <button
                  type="button"
                  onClick={addBenefitField}
                  className="text-primary text-sm mt-2 underline"
                >
                  Add more
                </button>
              </div>
            </div>

            {/* Display Benefits */}
            <div className="p-4 bg-white rounded-md mb-6">
              <h4 className="text-lg font-semibold mb-4">Benefits</h4>
              <ul className="grid grid-cols-2 list-disc pl-5">
                {benefits.map((benefit, index) => (
                  <li key={index} className="flex items-center gap-2">
                    <input
                      type="checkbox"
                      checked
                      className="h-4 w-4 accent-primary"
                    />
                    {benefit}
                  </li>
                ))}
              </ul>
            </div>
            <div className="text-center text-red-500">{error}</div>

            {/* Submit Button */}
            <div className="flex justify-end">
              <button
                type="submit"
                className="bg-primary text-white py-2 px-4 rounded-md flex items-center gap-2"
              >
                Update
                <FontAwesomeIcon icon={faArrowRight} />
              </button>
            </div>
          </form>
        </div>
      )}

      {planUpdatedSuccessful && (
        <div className="flex flex-col justify-center items-center">
          <h1 className="text-4xl font-bold text-black">
            Subscription plan updated successfully!
          </h1>
          <Link href="/billingsubscription" className="text-primary underline ">
            Go to Subscription page
          </Link>
        </div>
      )}
    </div>
  );
}
