"use client";
import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faWallet,
  faUser,
  faChartBar,
  faShoppingCart,
  faPlane,
} from "@fortawesome/free-solid-svg-icons";
import bellLogo from "../../../../../public/assets/profile/bell-logo.png";
import Image from "next/image";
import { Line } from "react-chartjs-2";
import { Pie } from "react-chartjs-2";
import AvatarDropdown from "../../avatardropdown/avatardropdown";
import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend,
  ArcElement,
} from "chart.js";

ChartJS.register(
  CategoryScale,
  LinearScale,
  PointElement,
  LineElement,
  Title,
  Tooltip,
  Legend,
  ArcElement
);

const Dashboard = () => {
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const auth = useSelector((data) => data?.auth);

  const [dashboardData, setDashboardData] = useState(null);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await fetch(
          `https://tracking.logoinnovators.com/backend/api/admin/dashboard-analytics`,
          {
            method: "GET",
            headers: {
              "Content-Type": "application/json",
              Authorization: `Bearer ${auth?.token}`,
            },
          }
        );

        if (!response.ok) {
          console.error("Failed to fetch data:", response.statusText);
          return;
        }

        const userDashboardData = await response.json();

        if (userDashboardData?.data) {
          console.log(userDashboardData);
          console.log(userDashboardData.data);
          setDashboardData(userDashboardData);
        }
      } catch (error) {
        console.error("Error fetching flight data:", error);
      }
    };

    fetchData();
  }, []);

  const lineData = {
    labels: ["January", "February", "March", "April", "May", "June"],
    datasets: [
      {
        label: "Revenue",
        data: [65, 59, 80, 81, 56, 55],
        fill: false,
        borderColor: "#0689BE",
        tension: 0.1,
      },
    ],
  };

  const pieData = {
    labels: [
      "Agent Fee",
      "Mortgage Interest",
      "Percentage Expense",
      "Total Expense",
    ],
    datasets: [
      {
        data: [25, 20, 30, 25],
        backgroundColor: ["#0689BE", "#68d28d", "#f3a845", "#e94e77"],
        hoverOffset: 4,
      },
    ],
  };
  const pieOptions = {
    responsive: true,
    maintainAspectRatio: false,
    plugins: {
      legend: {
        display: false,
      },
      tooltip: {
        callbacks: {
          label: (tooltipItem) => `${tooltipItem.label}: ${tooltipItem.raw}%`,
        },
      },
    },
  };
  const stats = [
    {
      title: "Today's Money",
      value: "$53k",
      change: "+55% than last week",
      changeType: "positive",
      icon: faWallet,
    },
    {
      title: "Today's Users",
      value: "2300",
      change: "+3% than last month",
      changeType: "positive",
      icon: faUser,
    },
    {
      title: "Ads Views",
      value: "3,462",
      change: "-2% than yesterday",
      changeType: "negative",
      icon: faChartBar,
    },
    {
      title: "Sales",
      value: "$103,430",
      change: "+5% than yesterday",
      changeType: "positive",
      icon: faShoppingCart,
    },
  ];

  // Chart options
  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: "top",
      },
      tooltip: {
        mode: "index",
        intersect: false,
      },
    },
    scales: {
      x: {
        beginAtZero: true,
      },
      y: {
        beginAtZero: true,
      },
    },
  };

  return (
    <div className=" lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
        <div className="text-[#0689BE] text-[20px] pl-4 md:pl-0">
          {/* <Breadcrumbs /> */}
        </div>
        <div className="hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
          {/* <img
            src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
            alt="Profile Picture"
            className="w-11 h-11 rounded-full object-cover"
          /> */}
          <AvatarDropdown />
        </div>
      </div>

      <div className="">
        {/* Line Chart */}
        <div>
          <p class=" md:text-3xl text-2xl leading-10  font-bold ">Dashboard</p>
          <p class="text-[#838189] text-md">
            Track your revenue effortlessly with real-time analytics and
            insights
          </p>
        </div>
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mt-8">
          {/* {stats.map((stat, index) => (
            <div
              key={index}
              className="flex items-center justify-between p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300"
            >
              <div>
                <h3 className="text-sm font-medium text-gray-500">
                  {stat.title}
                </h3>
                <p className="text-2xl font-bold text-gray-900">{stat.value}</p>
                <p
                  className={`text-sm font-medium ${
                    stat.changeType === "positive"
                      ? "text-green-500"
                      : "text-red-500"
                  }`}
                >
                  {stat.change}
                </p>
              </div>
              <div
                className="w-10 h-10  text-white flex items-center justify-center rounded-lg"
                style={{ backgroundColor: "#0689BE" }}
              >
                <FontAwesomeIcon icon={stat.icon} className="text-lg" />
              </div>
            </div>
          ))} */}
          <div className="flex items-center justify-between p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
            <div>
              <h3 className="text-sm font-medium text-gray-500">Total User</h3>
              <p className="text-2xl font-bold text-gray-900">
                {dashboardData?.data?.total_users}
              </p>
              {/* <p
                className={`text-sm font-medium ${
                  stat.changeType === "positive"
                    ? "text-green-500"
                    : "text-red-500"
                }`}
              >
                {stat.change}
              </p> */}
            </div>
            <div
              className="w-10 h-10  text-white flex items-center justify-center rounded-lg"
              style={{ backgroundColor: "#0689BE" }}
            >
              <FontAwesomeIcon icon={faUser} className="text-lg" />
            </div>
          </div>
          <div className="flex items-center justify-between p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
            <div>
              <h3 className="text-sm font-medium text-gray-500">
                Total Flights
              </h3>
              <p className="text-2xl font-bold text-gray-900">
                {dashboardData?.data?.total_flights}
              </p>
              {/* <p
                className={`text-sm font-medium ${
                  stat.changeType === "positive"
                    ? "text-green-500"
                    : "text-red-500"
                }`}
              >
                {stat.change}
              </p> */}
            </div>
            <div
              className="w-10 h-10  text-white flex items-center justify-center rounded-lg"
              style={{ backgroundColor: "#0689BE" }}
            >
              <FontAwesomeIcon icon={faPlane} className="text-lg" />
            </div>
          </div>
          <div className="flex items-center justify-between p-4 bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
            <div>
              <h3 className="text-sm font-medium text-gray-500">
                Total Subscriptions
              </h3>
              <p className="text-2xl font-bold text-gray-900">
                {dashboardData?.data?.total_subscriptions}
              </p>
              {/* <p
                className={`text-sm font-medium ${
                  stat.changeType === "positive"
                    ? "text-green-500"
                    : "text-red-500"
                }`}
              >
                {stat.change}
              </p> */}
            </div>
            <div
              className="w-10 h-10  text-white flex items-center justify-center rounded-lg"
              style={{ backgroundColor: "#0689BE" }}
            >
              <FontAwesomeIcon icon={faWallet} className="text-lg" />
            </div>
          </div>
        </div>
        <div className="flex gap-8 mt-8 flex-wrap justify-between">
          <div className="bg-white rounded-2xl py-4 px-6 w-full md:w-[60%] shadow-md">
            <h3 className="text-xl font-semibold mb-4">Users</h3>
            <div
              style={{ width: "100%", height: "100%", position: "relative" }}
            >
              <Line data={lineData} options={options} />
            </div>
          </div>

          {/* Pie Chart */}
          <div className="bg-white rounded-2xl py-6 px-8 w-full md:w-[36%] shadow-md">
            <h3 className="text-lg font-semibold">Expense Distribution</h3>
            <p className="text-sm text-gray-500 mb-4">
              Analytics from 20 Aug, 2024 to 19 Sep, 2024.
            </p>
            <div className="relative max-h-[320px] h-[320px]">
              <Pie data={pieData} options={pieOptions} />
            </div>
            <div className="mt-4 grid grid-cols-2 gap-2 text-sm text-gray-700">
              {pieData.labels.map((label, index) => (
                <div
                  key={index}
                  className="flex items-center justify-start md:justify-center gap-2"
                >
                  <div
                    className="w-3 h-3 rounded-full"
                    style={{
                      backgroundColor:
                        pieData.datasets[0].backgroundColor[index],
                    }}
                  ></div>
                  <span>{label}</span>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Dashboard;
