"use client";
import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import Breadcrumbs from "../../breadcrumbs/Breadcrumbs";
import bellLogo from "../../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../../public/assets/profile/Avatar.png";
import download from "../../../../../public/assets/subscription/download.png";
import search from "../../../../../public/assets/subscription/search.png";
import arrowUpDown from "../../../../../public/assets/subscription/arrow-up-down.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faEllipsisVertical,
  faAngleDown,
  faEye,
  faTrash,
} from "@fortawesome/free-solid-svg-icons";
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import Link from "next/link";
import { DeleteRequest } from "@/app/axios/axiosRequests";
import toast from "react-hot-toast";
import { useGetAllUserQuery } from "@/services/Api";
import { parsePhoneNumberFromString } from "libphonenumber-js";
import AvatarDropdown from "../../avatardropdown/avatardropdown";

const formatPhone = (phone) => {
  const cleaned = phone.replace(/\D/g, "");

  if (cleaned.length === 11 && cleaned[0] === "1") {
    return `+1 (${cleaned.slice(1, 4)}) ${cleaned.slice(4, 7)}-${cleaned.slice(
      7
    )}`;
  }

  if (cleaned.length === 10) {
    return `+1 (${cleaned.slice(0, 3)}) ${cleaned.slice(3, 6)}-${cleaned.slice(
      6
    )}`;
  }
  return phone;
};

const Users = () => {
  const [startDate, setStartDate] = useState(new Date());
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const [yearPickerOpen, setYearPickerOpen] = useState(false);
  const [monthPickerOpen, setMonthPickerOpen] = useState(false);
  const [openDropdown, setOpenDropdown] = useState(null);
  const [usersData, setUsersData] = useState(null);
  const [totalUsers, setTotalUsers] = useState(0);
  const [searchTerm, setSearchTerm] = useState("");
  const [searchQuery, setSearchQuery] = useState("");
  const [debouncedQuery, setDebouncedQuery] = useState(searchQuery);
  const [dateFilter, setDateFilter] = useState({
    startDate: "",
    endDate: "",
  });
  const [deleteModal, setDeleteModal] = useState({
    id: "",
    show: false,
  });

  const handleChange = (e) => {
    setSearchQuery(e.target.value);
  };

  const toggleDropdown = (index) => {
    setOpenDropdown(openDropdown === index ? null : index);
  };

  const formatMonth = (date) =>
    date.toLocaleString("default", { month: "long" });
  const formatYear = (date) => date.getFullYear();

  const { data: getAllUser, refetch: getAllUserRefetch } =
    useGetAllUserQuery(searchTerm);
  const handleSearch = (event) => {
    setSearchTerm(event.target.value);
  };

  useEffect(() => {
    if (getAllUser) {
      setUsersData(getAllUser);
    } else {
      setUsersData(null);
    }
  }, [getAllUser]);

  useEffect(() => {
    getAllUserRefetch();
  }, []);
  

  const handleDeleteUser = async (userId) => {
    try {
      const response = await DeleteRequest(`/admin/user/${userId}`);
      setUsersData(usersData.filter((user) => user.id !== userId));

      getAllUserRefetch();

      setDeleteModal({
        show: false,
        id: null,
      });
      toast.success("User deleted successfully", {
        position: "top-center",
      });
    } catch (error) {
      console.error("Failed to delete user:", error);
      setDeleteModal({
        show: false,
        id: null,
      });
      toast.error("Failed to delete user. Please try again.", {
        position: "top-center",
      });
    }
  };

  const handleDateFilter = async () => {
    let start_date = new Date(dateFilter.startDate);
    let end_date = new Date(dateFilter.endDate);

    start_date.setHours(0, 0, 0, 0);
    end_date.setHours(23, 59, 59, 999)
    
    const filteredItems = getAllUser.filter((item) => {
      const arrivalDate = new Date(item.created_at);
      arrivalDate.setHours(0, 0, 0, 0);

      return arrivalDate >= start_date && arrivalDate <= end_date;
    });
    setUsersData(filteredItems);
  };

  return (
    <>
      <div className=" lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
        <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
          <p class=" md:text-3xl text-2xl leading-10  font-bold ">User List</p>
          <div className=" hidden lg:flex items-center gap-4">
            <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
            {/* <img
                    src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
                    alt="Profile Picture"
                    className="w-11 h-11 rounded-full object-cover"
                  /> */}
            <AvatarDropdown />
          </div>
        </div>
        <div className="bg-white   rounded-2xl md:py-4 lg:px-6 ">
          <div className="">
            <div className="flex text-lg items-center font-semibold gap-4 py-2 mb-3 flex-wrap">
              {/* <div className="">Select Date:</div>
            <div className="">
              <button
                className="relative flex items-center gap-1 border p-2 rounded-lg"
                onClick={() => setMonthPickerOpen(!monthPickerOpen)}
              >
                {formatMonth(startDate)}
                <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
              </button>
              {monthPickerOpen && (
                <div className="absolute z-20">
                  <DatePicker
                    selected={startDate}
                    onChange={(date) => {
                      setStartDate(date);
                      setMonthPickerOpen(false);
                      console.log(date);
                    }}
                    dateFormat="MM"
                    showFullMonthYearPicker
                    inline
                  />
                </div>
              )}
            </div>
            <div className="">
              <button
                className="relative flex items-center gap-1 border p-2 rounded-lg"
                onClick={() => setYearPickerOpen(!yearPickerOpen)}
              >
                {formatYear(startDate)}
                <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
              </button>
              {yearPickerOpen && (
                <div className="absolute z-20">
                  <DatePicker
                    selected={startDate}
                    onChange={(date) => {
                      setStartDate(date);
                      setYearPickerOpen(false);
                    }}
                    showYearPicker
                    dateFormat="yyyy"
                    inline
                  />
                </div>
              )}
            </div> */}
              <div>
                <label className="form-label block">Start Date:</label>
                <input
                  type="date"
                  name="startDate"
                  min={new Date().toISOString()}
                  max={new Date().toISOString().split("T")[0]}
                  onChange={(e) =>
                    setDateFilter((prev) => {
                      return {
                        ...prev,
                        startDate: e.target.value,
                      };
                    })
                  }
                  value={dateFilter.startDate}
                  className="relative border p-2 rounded-lg text-[14px] w-[150px] sm:w-[200px] font-medium"
                  required
                />
              </div>
              <div>
                <label className="form-label block">End Date:</label>
                <input
                  type="date"
                  name="endDate"
                  // disabled={account.startdate === "" ? true: false}
                  min={new Date().toISOString()}
                  max={new Date().toISOString().split("T")[0]}
                  className="relative border p-2 rounded-lg text-[14px] w-[150px] sm:w-[200px] font-medium"
                  value={dateFilter.endDate}
                  onChange={(e) =>
                    setDateFilter((prev) => {
                      return {
                        ...prev,
                        endDate: e.target.value,
                      };
                    })
                  }
                  required
                />
              </div>
              <div className="flex self-end">
                <button
                  disabled={dateFilter.startDate === "" || dateFilter.endDate === "" ? true : false}
                  type="button"
                  className={`flex py-2 text-[14px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group ${dateFilter.startDate === "" || dateFilter.endDate === "" ? "opacity-75" : ""}`}
                  onClick={handleDateFilter}
                >
                  Search
                </button>
              </div>
              <div className="flex self-end">
                <button
                  disabled={dateFilter.startDate === "" && dateFilter.endDate === "" ? true : false}
                  type="button"
                  className={`flex py-2 text-[14px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group ${dateFilter.startDate === "" && dateFilter.endDate === "" ? "opacity-75" : ""}`}
                  onClick={() => {
                    setDateFilter({
                      endDate: "",
                      startDate: "",
                    });
                    setUsersData(getAllUser);
                  }}
                >
                  Reset
                </button>
              </div>
            </div>
          </div>

          <div className={`Billing Section `}>
            {usersData === null ? (
              <div className="md:h-[354px] h-[250px] flex items-center justify-center border border-[#E2E8F0] p-4 rounded-2xl">
                <div class="flex justify-center items-center bg-white">
                  <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
                </div>
              </div>
            ) : (
              <>
                {usersData?.length <= 0 && searchTerm.length == 0 ? (
                  <div className="md:h-[354px] h-[250px] flex items-center justify-center">
                    <p className="text-[18px] text-center">
                      There is no user currently available.
                    </p>
                  </div>
                ) : (
                  <div className="border border-[#E2E8F0] p-4 rounded-2xl">
                    <div className="flex justify-between items-center mb-4 flex-wrap">
                      <span className="text-[#667085] font-normal text-[12px]">
                        Total {usersData.length} users
                      </span>
                      <div className="flex gap-3">
                        <div className="relative">
                          <input
                            type="text"
                            className="w-[200px] md:w-[272px] h-full  pl-8 bg-[#F6F9FB] rounded-md outline-none"
                            placeholder="Search"
                            value={searchTerm}
                            onChange={handleSearch}
                          />
                          <Image
                            src={search}
                            alt="search"
                            className=" absolute top-2 left-1"
                          />
                        </div>
                        <button className="bg-[#0689BE] p-2 rounded-md">
                          <Image src={download} alt="download" className="" />
                        </button>
                      </div>
                    </div>
                    <div className="overflow-x-auto border border-[#E2E8F0] rounded-2xl h-[354px] md:h-[600px] overflow-y-auto ">
                      <table className="table-auto w-full min-w-[800px]">
                        <thead className="text-md font-bold capitalize text-black bg-gray-50 sticky top-0 z-10">
                          <tr>
                            <th className="p-2 pl-4 whitespace-nowrap">
                              <div className="font-semibold text-left flex items-center gap-2">
                                <input
                                  type="checkbox"
                                  className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                                />
                                <span className="flex  items-center gap-2">
                                  Name
                                </span>
                              </div>
                            </th>
                            <th className="p-2 py-4 whitespace-nowrap">
                              <div className="font-semibold text-left">
                                <span className="flex  items-center gap-2">
                                  Email
                                </span>
                              </div>
                            </th>
                            <th className="p-2 whitespace-nowrap">
                              <div className="font-semibold text-left">
                                Phone Number
                              </div>
                            </th>
                            <th className="p-2 whitespace-nowrap">
                              <div className="font-semibold text-left">
                                <span className="flex  items-center gap-2">
                                  Flights
                                  <Image
                                    src={arrowUpDown}
                                    alt=""
                                    className=""
                                  />
                                </span>
                              </div>
                            </th>
                            <th className="p-2 whitespace-nowrap">
                              <div className="font-semibold text-center">
                                Actions
                              </div>
                            </th>
                          </tr>
                        </thead>
                        <tbody className="text-sm divide-y divide-gray-100">
                          {usersData &&
                            usersData.map((data) => (
                              <tr key={data.id} className="">
                                <td className="p-2 pl-4 whitespace-nowrap">
                                  <div className="flex items-center ">
                                    <div className="font-medium text-gray-800 flex gap-2">
                                      <input
                                        type="checkbox"
                                        className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer mt-1"
                                      />
                                      <p className="uppercase  flex flex-col ">
                                        {data.name}
                                        {/* <span className="text-[11px] font-normal text-[#9A9EAD]">
                                          {data.cnic}
                                          xxxxx-xxxxxxxx-x
                                        </span> */}
                                      </p>
                                    </div>
                                  </div>
                                </td>
                                <td className="p-2 whitespace-nowrap">
                                  <div className="text-left ">
                                    <p className="text-[#1F2336] font-normal ">
                                      {data.email}
                                    </p>
                                  </div>
                                </td>
                                <td className="p-2 whitespace-nowrap">
                                  <div className="text-left text-[#1F2336] font-normal">
                                    {data.phone ? (
                                      <div>{formatPhone(data.phone)}</div>
                                    ) : (
                                      <div></div>
                                    )}
                                  </div>
                                </td>
                                <td className="p-2 whitespace-nowrap">
                                  <div className="text-[#1F2336] font-normal text-left">
                                    {data.flights_count}
                                  </div>
                                </td>

                                <td className="p-2 whitespace-nowrap">
                                  <div className="flex gap-3 items-center justify-center">
                                    {/* <FontAwesomeIcon
                              icon={faEllipsisVertical}
                              className="cursor-pointer px-5 "
                              onClick={() => toggleDropdown(data.id)}
                            /> */}
                                    <Link
                                      className="bg-[#0689BE] w-[36px] h-[36px] rounded-md flex items-center justify-center"
                                      href={`/users/${data.name.replace(
                                        /\s+/g,
                                        "-"
                                      )}`}
                                      onClick={() => {
                                        localStorage.setItem("userId", data.id);
                                      }}
                                    >
                                      <FontAwesomeIcon
                                        icon={faEye}
                                        className="text-white text-[12px]"
                                      />
                                    </Link>
                                    <button
                                      onClick={() => {
                                        setDeleteModal({
                                          show: true,
                                          id: data.id,
                                        });
                                      }}
                                      type="button"
                                      className="bg-red-500 w-[36px] p-2 rounded-md"
                                    >
                                      <FontAwesomeIcon
                                        icon={faTrash}
                                        className="text-white text-[12px]"
                                      />
                                    </button>
                                    {/* <FontAwesomeIcon icon={faTrash} className="cursor-pointer text-red-500" /> */}
                                    {/* {openDropdown === data.id && (
                              <div className="absolute z-20 right-0 top-4 bg-white shadow-lg p-2 rounded-md">
                                <div className="flex flex-col">
                                  <Link
                                    href={`/users/${data.name.replace(
                                      /\s+/g,
                                      "-"
                                    )}`}
                                    onClick={() => {
                                      localStorage.setItem("userId", data.id);
                                    }}
                                    className=" px-4 py-2 text-sm text-gray-700 hover:bg-gray-100"
                                  >
                                    View User Detail
                                  </Link>
                                  <button
                                    className=" px-4 py-2 text-sm text-gray-700 hover:bg-gray-100"
                                    onClick={() => {
                                      handleDeleteUser(data.id);
                                    }}
                                  >
                                    Delete User
                                  </button>
                                </div>
                              </div>
                            )} */}
                                  </div>
                                </td>
                              </tr>
                            ))}
                        </tbody>
                      </table>
                    </div>
                  </div>
                )}
              </>
            )}
          </div>
        </div>
      </div>
      {deleteModal.show && (
        <div
          className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center transition-opacity duration-500 z-50`}
        >
          <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
            {/* <Image src={loginSuccessIcon} alt="" className="max-w-[45px]" /> */}
            <svg
              xmlns="http://www.w3.org/2000/svg"
              className="w-[36px] h-[36px] text-red-400 border-b-2 border-t-2 border-l-2 border-r-2 rounded-full p-2 border-red-500"
              fill="none"
              viewBox="0 0 24 24"
              stroke="currentColor"
              strokeWidth={3}
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                d="M6 18L18 6M6 6l12 12"
              />
            </svg>
            <p className="mt-2 text-gray-600">
              Are you sure you want to delete this user?
            </p>
            <div className="mt-4 flex gap-3">
              <button
                className="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition"
                onClick={() => handleDeleteUser(deleteModal.id)}
              >
                Yes, Delete
              </button>
              <button
                className="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 transition"
                onClick={() =>
                  setDeleteModal({
                    show: false,
                    id: null,
                  })
                }
              >
                Cancel
              </button>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default Users;
