"use client";
import React, { useState } from "react";
import bellLogo from "../../../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../../../public/assets/profile/Avatar.png";
import Image from "next/image";
import Breadcrumbs from "../../../breadcrumbs/Breadcrumbs";
import UserProfile from "./UserProfile";
import UserFlights from "./UserFlights";
import UserSubscription from "./UserSubscription";
import { useSelector } from "react-redux";
import AvatarDropdown from "@/app/components/avatardropdown/avatardropdown";

const UserDetail = (props) => {
  const { userName } = props;
  const [profileOpen, setProfileOpen] = useState(true);
  const [flightsOpen, setFlightsOpen] = useState(false);
  const [subscriptionOpen, setSubscriptionOpen] = useState(false);
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const handleProfileComponent = () => {
    setProfileOpen(true);
    setFlightsOpen(false);
    setSubscriptionOpen(false);
  };
  const handleFlightsComponent = () => {
    setProfileOpen(false);
    setFlightsOpen(true);
    setSubscriptionOpen(false);
  };
  const handleSubscriptionComponent = () => {
    setProfileOpen(false);
    setFlightsOpen(false);
    setSubscriptionOpen(true);
  };

  return (
    <div className=" lg:bg-[#F8F9FC] min-h-screen md:px-8 overflow-x-hidden">
      <div className="lg:h-[100px] flex justify-between items-center">
        <div className="text-[#0689BE] text-[20px] pl-4 md:pl-0 ">
          {/* <Breadcrumbs /> */}
        </div>
        <div className=" hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
          {/* <Image src={profilePic} alt="" className="h-11 w-11" /> */}
          {/* <img
            src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
            alt="Profile Picture"
            className="w-12 h-12 rounded-full object-cover"
          /> */}
          <AvatarDropdown />
        </div>
      </div>
      <div className="bg-white rounded-2xl py-4 px-6">
        <div className="flex md:flex-row  flex-col justify-between md:items-center border-b mb-4 sm:md-6 md:mb-10">
          <div className=" flex gap-4 cursor-pointer">
            <div
              className={` font-bold py-1 text-[14px] md:text-[16px] ${profileOpen
                  ? "font-bold py-3 px-2 sm:px-4 text-[#0689BE]  border-b-2 border-[#0689BE]"
                  : "font-bold py-3 px-2 sm:px-4 text-[#031926]"
                }`}
              onClick={handleProfileComponent}
            >
              User Profile
            </div>
            <div
              className={` font-bold py-1 text-[14px] md:text-[16px] ${flightsOpen
                  ? "font-bold py-3 px-2 sm:px-4 text-[#0689BE]  border-b-2 border-[#0689BE]"
                  : "font-bold py-3 px-2 sm:px-4 text-[#031926]"
                }`}
              onClick={handleFlightsComponent}
            >
              Flights
            </div>
            <div
              className={` font-bold py-1 text-[14px] md:text-[16px] ${subscriptionOpen
                  ? "font-bold py-3 px-2 sm:px-4 text-[#0689BE]  border-b-2 border-[#0689BE]"
                  : "font-bold py-3 px-2 sm:px-4 text-[#031926]"
                }`}
              onClick={handleSubscriptionComponent}
            >
              Subscription
            </div>
          </div>

        </div>
        {profileOpen && <UserProfile name={userName} />}
        {flightsOpen && <UserFlights />}
        {subscriptionOpen && <UserSubscription />}
      </div>
    </div>
  );
};

export default UserDetail;
