"use client";
import React, { useState, useEffect } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faAngleDown } from "@fortawesome/free-solid-svg-icons";
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import UserFlightsDetail from "./UserFlightsDetail";
import { useSelector } from "react-redux";
import { GetRequest, PostRequest } from "@/app/axios/axiosRequests";
import toast from "react-hot-toast";
import { faCalendarAlt } from "@fortawesome/free-solid-svg-icons";
import { useFormik } from "formik";
import * as Yup from "yup";

const Popup = ({ onClose, onFlightAdded }) => {
  const userDetail = useSelector((state) => state.auth.userDetail);
  const [loading, setLoading] = useState(false);
  const userId = localStorage.getItem("userId");
  // Formik initial values and validation schema
  const formik = useFormik({
    initialValues: {
      carrierCode: "",
      flightNumber: "",
      departureDate: null,
    },
    validationSchema: Yup.object({
      carrierCode: Yup.string().required("Carrier Code is required"),
      flightNumber: Yup.string().required("Flight Number is required"),
      departureDate: Yup.string().required("Departure Date is required"),
    }),

    onSubmit: async (values) => {
      setLoading(true);
      try {
        const url = "/admin/flight-details";
        const date = values.departureDate;
        const offsetDate = new Date(
          date.getTime() - date.getTimezoneOffset() * 60000
        );
        const formattedDate = offsetDate.toISOString().split("T")[0];
        console.log("date old" + formattedDate);
        const response = await GetRequest(url, {
          carrier_code: values.carrierCode,
          flight_number: values.flightNumber,
          departure_date: formattedDate,
          user_id: userId,
        });
        console.log("Flight details added:", response);
        toast.success("Successfully added the flight!", {
          position: "top-center",
        });
        onClose();
        onFlightAdded();
      } catch (error) {
        console.error("Error:", error);
        let errorMessage =
          error.response.data.message || "An unknown error occurred.";
        toast.error(errorMessage, {
          position: "top-center",
        });
      } finally {
        setLoading(false);
      }
    },
  });

  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex justify-center items-center z-50">
      <div className="bg-white p-6 rounded-lg shadow-lg max-w-md w-full relative">
        {/* Close Button */}
        <button
          onClick={onClose}
          className="absolute top-2 right-2 text-gray-500 hover:text-gray-700 text-[30px]"
        >
          &times;
        </button>
        <h2 className="text-xl font-bold mb-4 text-[#0689BE]">
          Add New Flight
        </h2>
        <form onSubmit={formik.handleSubmit}>
          {/* Carrier Code */}
          <input
            type="text"
            placeholder="Carrier Code"
            {...formik.getFieldProps("carrierCode")}
            className={`border p-2 mb-3 rounded-md  w-full ${
              formik.touched.carrierCode && formik.errors.carrierCode
                ? "border-red-500"
                : ""
            }`}
          />
          {formik.touched.carrierCode && formik.errors.carrierCode && (
            <div className="text-red-500 text-sm mb-3">
              {formik.errors.carrierCode}
            </div>
          )}

          {/* Flight Number */}
          <input
            type="text"
            placeholder="Flight Number"
            {...formik.getFieldProps("flightNumber")}
            className={`border p-2 mb-3 rounded-md w-full ${
              formik.touched.flightNumber && formik.errors.flightNumber
                ? "border-red-500"
                : ""
            }`}
          />
          {formik.touched.flightNumber && formik.errors.flightNumber && (
            <div className="text-red-500 text-sm mb-3">
              {formik.errors.flightNumber}
            </div>
          )}

          {/* Departure Date */}
          <div className="mb-3 w-full main-date-picker">
            <DatePicker
              selected={formik.values.departureDate}
              onChange={(date) => {
                formik.setFieldValue("departureDate", date);
              }}
              dateFormat="dd/MM/yyyy"
              placeholderText="Select a Departure Date"
              wrapperClassName="w-full"
              className={`border p-2 w-full rounded ${
                formik.touched.departureDate && formik.errors.departureDate
                  ? "border-red-500"
                  : ""
              }`}
            />
            {formik.touched.departureDate && formik.errors.departureDate && (
              <div className="text-red-500 text-sm mb-3">
                {formik.errors.departureDate}
              </div>
            )}
          </div>

          <button
            type="submit"
            className={`bg-primary text-white uppercase px-3 py-2 rounded-md w-full ${
              loading ? "opacity-50 cursor-not-allowed" : ""
            }`}
            disabled={loading}
          >
            {loading ? "Loading..." : "Save Flight"}
          </button>
        </form>
      </div>
    </div>
  );
};

const UserFlights = () => {
  const [isPopupOpen, setIsPopupOpen] = useState(false);
  const [startDate, setStartDate] = useState(null);
  const [yearPickerOpen, setYearPickerOpen] = useState(false);
  const [monthPickerOpen, setMonthPickerOpen] = useState(false);
  const [showFlights, setShowFlights] = useState(true);
  const [selectedFlightId, setSelectedFlightId] = useState(null);
  const [flights, setFlights] = useState([]);
  const userDetail = useSelector((state) => state.auth.userDetail);
  const [isLoading, setIsLoading] = useState(false);
  const [flightsData, setFlightsData] = useState([]);
  const day = startDate ? startDate.getDate() : null;
  const month = startDate ? startDate.getMonth() + 1 : null;
  const year = startDate ? startDate.getFullYear() : null;
  const [dateFilter, setDateFilter] = useState({
    startDate: "",
    endDate: "",
  });
  const [flightTab, setFlightTab] = useState("upcoming flight");
  const [upcomingFlights, setUpcomingFlights] = useState([]);
  const [previousFlights, setPreviousFlights] = useState([]);

  const handleAddNewFlight = () => {
    setIsPopupOpen(true);
  };

  const handleClosePopup = () => {
    setIsPopupOpen(false);
  };

  const formatMonth = (date) => {
    if (!date) return "select a month and date";
    return date.toLocaleString("default", { month: "long" });
  };

  const formatYear = (date) => {
    if (!date) return "select a year";
    return date.getFullYear();
  };

  const fetchFlights = async () => {
    const userId = localStorage.getItem("userId");
    if (userDetail?.id) {
      const getFlightInfoUrl = `/user/${userId}/flights`;
      setIsLoading(true);
      try {
        const flightInfoResponse = await GetRequest(getFlightInfoUrl);
        const updatedFlights = flightInfoResponse.map((flight) => ({
          ...flight,
          check: false,
        }));
        setFlights(updatedFlights);

        previousFlightGetHandler(updatedFlights);

        let upcomingFlightFilter = updatedFlights.filter(
          (item) =>
            new Date().setHours(0, 0, 0, 0) <=
            new Date(item.arrival_time).setHours(23, 59, 59, 999)
        );
        setUpcomingFlights(upcomingFlightFilter);
      } catch (error) {
        console.error("Failed to fetch flight data:", error);
        toast.error("Failed to fetch flight data", { position: "top-center" });
      } finally {
        setIsLoading(false);
      }
    }
  };

  const previousFlightGetHandler = (flightData) => {
    let previousFlightFilter = flightData.filter(
      (item) =>
        new Date().setHours(0, 0, 0, 0) >=
        new Date(item.arrival_time).setHours(23, 59, 59, 999)
    );

    setPreviousFlights(previousFlightFilter);
  };

  useEffect(() => {
    fetchFlights();
  }, [startDate, userDetail]);

  const handleCheckToggle = (flightId) => {
    setFlights(
      flights.map((flight) =>
        flight.id === flightId ? { ...flight, check: !flight.check } : flight
      )
    );
  };

  const numberOfFlights = flights.length;
  // Corrected this
  const selectedFlightData = flights.find(
    (flight) => flight.id === selectedFlightId
  );

  const handleFlightDetails = (flight) => {
    setFlightsData(flight);
    console.log(flight);
    setShowFlights(false);
  };

  const handleGoBack = () => {
    setShowFlights(true);
    setSelectedFlightId(null);
  };

  const handleDateFilter = async () => {
    let start_date = new Date(dateFilter.startDate);
    let end_date = new Date(dateFilter.endDate);

    start_date.setHours(0, 0, 0, 0);
    end_date.setHours(23, 59, 59, 999);

    const filteredItems = flights.filter((item) => {
      const arrivalDate = new Date(item.created_at);
      arrivalDate.setHours(0, 0, 0, 0);

      return arrivalDate >= start_date && arrivalDate <= end_date;
    });
    setPreviousFlights(filteredItems);
  };

  return (
    <div className="">
      {showFlights && (
        <div className="bg-[#FFFFFF] p-4 md:p-6 rounded-2xl border">
          <div className="flex justify-between items-center gap-4 flex-wrap mb-3 md:mb-0">
            <h2 class="md:mb-2 lg:mb-4 text-xl md:text-2xl font-bold">
              Flights Details
            </h2>
            <div className="text-end pl-3">
              <button
                className="border border-primary text-primary rounded-md p-2 4 text-[14px] md:text-[16px] min-w-[120px] md:min-w-[150px]"
                onClick={handleAddNewFlight}
              >
                Add New Flight
              </button>
            </div>
          </div>
          <div className=" flex gap-4 border-b mb-6">
            <button
              className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${
                flightTab === "upcoming flight"
                  ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
                  : "text-[#031926]"
              } `}
              onClick={() => setFlightTab("upcoming flight")}
            >
              Upcoming Flights
            </button>
            <button
              className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${
                flightTab === "previous flight"
                  ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
                  : "text-[#031926]"
              } `}
              onClick={() => setFlightTab("previous flight")}
            >
              Previous Flights
            </button>
          </div>
          {/* <div className="flex text-lg items-center font-semibold gap-6 py-2">
              <div class="text-[16px]">Select Date:</div>
              <div className="">
                  <button
                    className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[170px] justify-between font-medium"
                    onClick={() => setMonthPickerOpen(!monthPickerOpen)}
                  >
                    {formatMonth(startDate)}
                    <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
                  </button>

                  {monthPickerOpen && (
                    <div className="absolute z-20">
                      <DatePicker
                        selected={startDate}
                        onChange={(date) => {
                          setStartDate(date);
                          setMonthPickerOpen(false);
                        }}
                        dateFormat="MM/yyyy"
                        inline
                      />
                    </div>
                  )}
            </div>
      <div>
        <button
          className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[140px] justify-between font-medium"
          onClick={() => setYearPickerOpen(!yearPickerOpen)}
        >
          {formatYear(startDate)}
          <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
        </button>

        {yearPickerOpen && (
          <div className="absolute z-20">
            <DatePicker
              selected={startDate}
              onChange={(date) => {
                setStartDate(date);
                setYearPickerOpen(false);
              }}
              dateFormat="yyyy"
              inline
              showYearPicker
            />
          </div>
        )}
        </div>
              <button className="border border-primary text-primary rounded-md p-2 text-[16px] min-w-[150px]" onClick={handleAddNewFlight}>
                Add New Flight
              </button>
            </div> */}
          {flightTab === "previous flight" && (
            <div className="flex text-lg items-center font-semibold gap-4 py-2 mb-3">
              <div>
                <label className="form-label block">Start Date:</label>
                <input
                  type="date"
                  name="startDate"
                  min={new Date().toISOString()}
                  max={new Date().toISOString().split("T")[0]}
                  onChange={(e) =>
                    setDateFilter((prev) => {
                      return {
                        ...prev,
                        startDate: e.target.value,
                      };
                    })
                  }
                  value={dateFilter.startDate}
                  className="relative border p-2 rounded-lg text-[14px] w-[200px] font-medium"
                  required
                />
              </div>
              <div>
                <label className="form-label block">End Date:</label>
                <input
                  type="date"
                  name="endDate"
                  // disabled={account.startdate === "" ? true: false}
                  min={new Date().toISOString()}
                  max={new Date().toISOString().split("T")[0]}
                  className="relative border p-2 rounded-lg text-[14px] w-[200px] font-medium"
                  value={dateFilter.endDate}
                  onChange={(e) =>
                    setDateFilter((prev) => {
                      return {
                        ...prev,
                        endDate: e.target.value,
                      };
                    })
                  }
                  required
                />
              </div>
              <div className="flex align-end">
                <button
                  type="button"
                  className="flex py-2 text-[14px] mt-[28px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group"
                  onClick={handleDateFilter}
                >
                  Search
                </button>
              </div>
              <div className="flex align-end">
                <button
                  type="button"
                  className="flex py-2 text-[14px] mt-[28px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group"
                  onClick={() => {
                    setDateFilter({
                      endDate: "",
                      startDate: "",
                    });
                    previousFlightGetHandler(flights);
                  }}
                >
                  Reset
                </button>
              </div>
            </div>
          )}
          {isLoading && (
            <div className="md:h-[354px] h-[250px] flex items-center justify-center p-4 rounded-2xl">
              <div class="flex justify-center items-center bg-white">
                <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
              </div>
            </div>
          )}
          {!isLoading &&
            upcomingFlights.length <= 0 &&
            flightTab === "upcoming flight" && (
              <div className="md:h-[354px] h-[250px] flex items-center justify-center">
                <p className="text-[18px] text-center">
                  The user currently does not have any booked flights.
                </p>
              </div>
            )}
          {!isLoading &&
            flightTab === "previous flight" &&
            previousFlights.length <= 0 && (
              <div className="md:h-[354px] h-[250px] flex items-center justify-center">
                <p className="text-[18px] text-center mt-5">
                  Sorry, User don't have any previous flight data.
                </p>
              </div>
            )}
          {flightTab === "upcoming flight" &&
            upcomingFlights &&
            upcomingFlights.length > 0 && (
              <div className="grid xl:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 py-5">
                {upcomingFlights.map((flight, index) => (
                  <div
                    onClick={() => handleFlightDetails(flight)} // Corrected this
                    key={flight.id}
                    className="relative shadow-custom rounded-3xl min-w-[323px] md:max-w-[450px] cursor-pointer transition ease-in-out hover:-translate-y-2"
                  >
                    <div className="absolute -top-3 left-[37%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                      <div className="text-center z-10 py-1 text-[16px] font-semibold">
                        <span className="mr-1">ID:</span>
                        <span className="">{flight.id}</span>
                      </div>
                    </div>
                    <div className="flex items-center gap-2 text-[18px] font-medium py-8 px-8 border-b border-gray-300">
                      <p className="text-[#667085] font-normal text-base">
                        Flight From:
                      </p>
                      {flight.departure_airport} to {flight.arrival_airport}
                    </div>
                    <div className="py-6">
                      <div className="grid grid-cols-2 gap-x-2 gap-y-6 px-12 gap-2 mb-6">
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Date of Flight
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {new Date(
                              flight.departure_time
                            ).toLocaleDateString()}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Airfield
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {flight.airline_name}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Departure time
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {new Date(flight.departure_time).toLocaleTimeString(
                              [],
                              { hour: "2-digit", minute: "2-digit" }
                            )}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Flight duration
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {flight.duration_formatted}
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
            )}
          {flightTab === "previous flight" &&
            previousFlights &&
            previousFlights.length > 0 && (
              <div className="grid xl:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 py-5">
                {previousFlights.map((flight, index) => (
                  <div
                    onClick={() => handleFlightDetails(flight)} // Corrected this
                    key={flight.id}
                    className="relative shadow-custom rounded-3xl min-w-[323px] md:max-w-[450px] cursor-pointer transition ease-in-out hover:-translate-y-2"
                  >
                    <div className="absolute -top-3 left-[37%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                      <div className="text-center z-10 py-1 text-[16px] font-semibold">
                        <span className="mr-1">ID:</span>
                        <span className="">{flight.id}</span>
                      </div>
                    </div>
                    <div className="flex items-center gap-2 text-[18px] font-medium py-8 px-8 border-b border-gray-300">
                      <p className="text-[#667085] font-normal text-base">
                        Flight From:
                      </p>
                      {flight.departure_airport} to {flight.arrival_airport}
                    </div>
                    <div className="py-6">
                      <div className="grid grid-cols-2 gap-x-2 gap-y-6 px-12 gap-2 mb-6">
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Date of Flight
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {new Date(
                              flight.departure_time
                            ).toLocaleDateString()}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Airfield
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {flight.airline_name}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Departure time
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {new Date(flight.departure_time).toLocaleTimeString(
                              [],
                              { hour: "2-digit", minute: "2-digit" }
                            )}
                          </p>
                        </div>
                        <div className="">
                          <p className="text-[#667085] font-normal text-base">
                            Flight duration
                          </p>
                          <p className="text-[#1D2939] font-semibold text-base">
                            {flight.duration_formatted}
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                ))}
              </div>
            )}
          {/* {flights.length > 0 && (
            <div className="grid xl:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 py-5">
              {flights.map((flight) => (
                <div
                  onClick={() => handleFlightDetails(flight)} // Corrected this
                  key={flight.id}
                  className="relative shadow-custom rounded-3xl min-w-[323px] max-w-[450px] cursor-pointer transition ease-in-out hover:-translate-y-2"
                >
                  <div className="absolute -top-3 left-[37%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                    <div className="text-center z-10 py-1 text-[16px] font-semibold">
                      <span className="mr-1">ID:</span>
                      <span className="">{flight.id}</span>
                    </div>
                  </div>
                  <div className="flex items-center gap-2 text-[18px] font-medium py-8 px-8 border-b border-gray-300">
                    <p className="">Flight From:</p>
                    {flight.departure_airport} to {flight.arrival_airport}
                  </div>
                  <div className="py-6">
                    <div className="grid grid-cols-2 gap-x-2 gap-y-6 px-12 gap-2 mb-6">
                      <div className="">
                        <p className="text-[#667085] font-normal text-base">
                          Date of Flight
                        </p>
                        <p className="text-[#1D2939] font-semibold text-base">
                          {new Date(flight.departure_time).toLocaleDateString()}
                        </p>
                      </div>
                      <div className="">
                        <p className="text-[#667085] font-normal text-base">
                          Airfield
                        </p>
                        <p className="text-[#1D2939] font-semibold text-base">
                          {flight.airline_name}
                        </p>
                      </div>
                      <div className="">
                        <p className="text-[#667085] font-normal text-base">
                          Departure time
                        </p>
                        <p className="text-[#1D2939] font-semibold text-base">
                          {new Date(flight.departure_time).toLocaleTimeString(
                            [],
                            { hour: "2-digit", minute: "2-digit" }
                          )}
                        </p>
                      </div>
                      <div className="">
                        <p className="text-[#667085] font-normal text-base">
                          Flight duration
                        </p>
                        <p className="text-[#1D2939] font-semibold text-base">
                          {flight.duration_formatted}
                        </p>
                      </div>
                    </div>
                  </div>
                </div>
              ))}
            </div>
          )} */}
        </div>
      )}
      {!showFlights && flightsData && (
        <UserFlightsDetail flightData={flightsData} onGoBack={handleGoBack} />
      )}
      {isPopupOpen && (
        <Popup onClose={handleClosePopup} onFlightAdded={fetchFlights} />
      )}
    </div>
  );
};

export default UserFlights;
