"use client";
import React, { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faAngleDown } from "@fortawesome/free-solid-svg-icons";
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import { useGetUserBillingAndSubsQuery } from "@/services/Api";
import moment from "moment/moment";

const UserSubscription = () => {
  const [startDate, setStartDate] = useState(new Date());
  const [yearPickerOpen, setYearPickerOpen] = useState(false);
  const [monthPickerOpen, setMonthPickerOpen] = useState(false);
  const userId = localStorage.getItem("userId");
  // const [loader, setLoader] = useState(false);

  const formatMonth = (date) =>
    date.toLocaleString("default", { month: "long" });
  const formatYear = (date) => date.getFullYear();

  const { data: getUserBillingAndSubs, refetch: getUserBillingAndSubsRefetch } =
    useGetUserBillingAndSubsQuery({ id: userId });

  const activeObject = getUserBillingAndSubs?.subscriptions?.find(
    (item) => item?.stripe_status == "active"
  );

  useEffect(() => {
    getUserBillingAndSubsRefetch();
  }, []);

  // useEffect(() => {
  //   if (activeObject === undefined) {
  //     setLoader(true);
  //     console.log("loader true")
  //   } else {
  //     setLoader(false);
  //     console.log("loader false")
  //   }
  //   console.log(activeObject);
  // }, [activeObject]);

  const subscriptionData = [
    {
      id: 1,
      subscriptionType: "Monthly subscription",
      billingDate: "30.07.2022",
      expiryDate: "30.07.2023",
    },

    {
      id: 2,
      subscriptionType: "Yearly subscription",
      billingDate: "30.07.2022",
      expiryDate: "30.07.2024",
    },
    {
      id: 3,
      subscriptionType: "Custom",
      billingDate: "30.07.2022",
      expiryDate: "30.07.2023",
    },
  ];

  return (
    <div className="">
      <div className="bg-[#FFFFFF] p-4 md:p-6 rounded-2xl border">
        <h2 class="mb-4 text-xl md:text-2xl font-bold">User Subscriptions</h2>
        {/* <div className="flex text-lg items-center font-semibold gap-4 py-2 mb-3">
          <div>
            <label className="form-label block">Start Date:</label>
            <input
              type="date"
              name="startDate"
              min={new Date().toISOString()}
              // onChange={(e) =>
              //   setDateFilter((prev) => {
              //     return {
              //       ...prev,
              //       startDate: e.target.value,
              //     };
              //   })
              // }
              // value={dateFilter.startDate}
              className="relative border p-2 rounded-lg text-[14px] w-[200px] font-medium"
              required
            />
          </div>
          <div>
            <label className="form-label block">End Date:</label>
            <input
              type="date"
              name="endDate"
              // disabled={account.startdate === "" ? true: false}
              min={new Date().toISOString()}
              className="relative border p-2 rounded-lg text-[14px] w-[200px] font-medium"
              // value={dateFilter.endDate}
              // onChange={(e) =>
              //   setDateFilter((prev) => {
              //     return {
              //       ...prev,
              //       endDate: e.target.value,
              //     };
              //   })
              // }
              required
            />
          </div>
          <div className="flex align-end">
            <button
              type="button"
              className="flex py-2 text-[14px] mt-[28px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group"
              // onClick={handleDateFilter}
            >
              Search
            </button>
          </div>
          <div className="flex align-end">
            <button
              type="button"
              className="flex py-2 text-[14px] mt-[28px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group"
              // onClick={() => {
              //   setDateFilter({
              //     endDate: "",
              //     startDate: "",
              //   });
              //   setUsersData(getAllUser);
              // }}
            >
              Reset
            </button>
          </div>
        </div> */}
        {/* <div className="flex text-lg items-center font-semibold gap-6 py-2">
          <div class="text-[16px]">Select Date:</div>
          <div className="">
            <button
              className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[170px] justify-between font-medium"
              onClick={() => setMonthPickerOpen(!monthPickerOpen)}
            >
              {formatMonth(startDate)}
              <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
            </button>
            {monthPickerOpen && (
              <div className="absolute z-20">
                <DatePicker
                  selected={startDate}
                  onChange={(date) => {
                    setStartDate(date);
                    setMonthPickerOpen(false);
                    console.log(date);
                  }}
                  dateFormat="MM"
                  showFullMonthYearPicker
                  inline
                />
              </div>
            )}
          </div>
          <div className="">
            <button
              className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[140px] justify-between font-medium"
              onClick={() => setYearPickerOpen(!yearPickerOpen)}
            >
              {formatYear(startDate)}
              <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
            </button>
            {yearPickerOpen && (
              <div className="absolute z-20">
                <DatePicker
                  selected={startDate}
                  onChange={(date) => {
                    setStartDate(date);
                    setYearPickerOpen(false);
                  }}
                  showYearPicker
                  dateFormat="yyyy"
                  inline
                />
              </div>
            )}
          </div>
        </div> */}
        {activeObject > 0 && activeObject ? (
          <div className="grid xl:grid-cols-3 md:grid-cols-2 grid-cols-1 pt-6">
            <div className=" relative  shadow-custom rounded-3xl  min-w-[323px] max-w-[350px] ">
              <div className=" absolute -top-3 left-[35%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                <div className=" text-center z-10 py-1 text-[16px] font-semibold ">
                  <span className="mr-1">ID:</span>
                  <span className="">{activeObject?.id}</span>
                </div>
              </div>
              <div className="flex items-center gap-2 text-[18px] font-medium py-8  justify-center border-b border-gray-300">
                <p className="">Name:</p>
                {activeObject?.plan}
              </div>
              <div className="py-6">
                <div className="grid grid-cols-2 gap-x-2  gap-y-6 px-12 gap-2 mb-6">
                  <div className="">
                    <p className="text-[#667085] font-normal text-base">
                      Billing Date
                    </p>
                    <p className="text-[#1D2939] font-semibold text-base">
                      {moment(activeObject?.created_at).format("DD-MM-YYYY")}
                    </p>
                  </div>
                  <div className="">
                    <p className="text-[#667085] font-normal text-base">
                      Expiry
                    </p>
                    <p className="text-[#1D2939] font-semibold text-base">
                      {moment(activeObject?.end_date).format("DD-MM-YYYY")}
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        ) : null}
        {activeObject === undefined  && (
          <div className="md:h-[354px] h-[250px] flex items-center justify-center">
            <p className="text-[18px] text-center">
              User does not have an active plan at the moment.
            </p>
          </div>
        )}
        {/* {loader && (
          <div className="h-[354px] flex items-center justify-center p-4 rounded-2xl">
            <div class="flex justify-center items-center bg-white">
              <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
            </div>
          </div>
        )} */}
      </div>
    </div>
  );
};

export default UserSubscription;
