import React, { useState } from "react";
import { useSelector } from "react-redux";
import Image from "next/image";
import { useDispatch } from "react-redux";
import { userLogout } from "@/redux/authSlice";
import { usePathname, useRouter } from "next/navigation";
import Cookies from "js-cookie";

export default function AvatarDropdown() {
  const dispatch = useDispatch();
  const router = useRouter();

  const [isOpen, setIsOpen] = useState(false);
  const globalProfileImg = useSelector((state) => state?.auth?.globalProfileImg);
  const adminRole = useSelector((state) => state?.auth?.userDetail?.role);

  const toggleDropdown = () => {
    setIsOpen(!isOpen);
  };
  const closeDropdown = () => {
    setIsOpen(false);
  };

  const handleLogout = () => {
    dispatch(userLogout(null));
    // Clear the cookies
    Cookies.remove("authToken");
    Cookies.remove("role");
    localStorage.clear();
    // Redirect to the login page
    // toast.success("Logout Successful", {
    //   position: "top-center",
    // });
    // setIsModalVisible(true);
    // setTimeout(() => {
    //   setIsModalVisible(false); // Hide modal
    router.push("/login"); // Redirect to login page
    // }, 1000);
  };

  return (
    <div className="relative">
      <button
        type="button"
        onClick={toggleDropdown}
        className="flex gap-2 items-center"
      >
        <div className="h-11 w-11 rounded-full overflow-hidden">
          {globalProfileImg === null ? (
            <img
              src={
                "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"
              }
              alt="Profile Picture"
              className="w-11 h-11 rounded-full object-cover"
            />
          ) : (
            <img
              src={`https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`}
              alt=""
              className="h-100 w-100 object-cover"
            />
          )}
        </div>

        <svg
          class="w-2 h-2"
          aria-hidden="true"
          xmlns="http://www.w3.org/2000/svg"
          fill="none"
          viewBox="0 0 10 6"
        >
          <path
            stroke="#000"
            stroke-linecap="round"
            stroke-linejoin="round"
            stroke-width="2"
            d="m1 1 4 4 4-4"
            className="hidden lg:block"
          />
          <path
            stroke="#fff"
            stroke-linecap="round"
            stroke-linejoin="round"
            stroke-width="2"
            d="m1 1 4 4 4-4"
            className="lg:hidden"
          />
        </svg>
      </button>
      {isOpen && (
        <div className="origin-top-right absolute right-0 top-5 mt-8 min-w-[170px] rounded-lg shadow-lg bg-white ring-1 ring-black ring-opacity-5 overflow-hidden">
          <ul
            role="menu"
            aria-orientation="vertical"
            aria-labelledby="options-menu"
          >
            {adminRole === "admin" ? (
              ""
            ) : (
              <li>
                <a
                  href="/profile"
                  className="block px-4 py-2 text-[14px] font-semibold text-gray-700 hover:bg-[#0689BE] hover:text-white"
                  onClick={closeDropdown}
                >
                  Profile
                </a>
              </li>
            )}
            <li>
              <a
                href="#"
                className="block px-4 py-2 text-[14px] font-semibold text-gray-700 hover:bg-[#0689BE] hover:text-white"
                onClick={() => handleLogout()}
              >
                Logout
              </a>
            </li>
          </ul>
        </div>
      )}
    </div>
  );
}
