"use client";
import React, { useEffect, useState } from "react";
import Breadcrumbs from "../breadcrumbs/Breadcrumbs";
import bellLogo from "../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../public/assets/profile/Avatar.png";
import download from "../../../../public/assets/subscription/download.png";
import search from "../../../../public/assets/subscription/search.png";
import arrowUpDown from "../../../../public/assets/subscription/arrow-up-down.png";
import Image from "next/image";
import Subscription from "./Subscription";
import { useGetUserBillingAndSubsQuery } from "@/services/Api";
import { useSelector } from "react-redux";
import moment from "moment/moment";
import AvatarDropdown from "../avatardropdown/avatardropdown";

const Billing = () => {
  const [openBillingSection, setBillingSection] = useState(false);
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const auth = useSelector((data) => data?.auth);
  const [loader, setLoader] = useState(false);
  const [searchTerm, setSearchTerm] = useState("");
  const [userBillingData, setUserBillingData] = useState(null);
  const [userBillingFilterData, setUserBillingFilterData] = useState(null);

  const toggleBillingSection = () => {
    setBillingSection(!openBillingSection);
  };

  const { data: getUserBillingAndSubs, refetch: getUserBillingAndSubsRefetch } =
    useGetUserBillingAndSubsQuery({ id: auth?.userDetail?.id });

  const activeObject = getUserBillingAndSubs?.subscriptions?.find(
    (item) => item?.stripe_status == "active"
  );

  const tableData = [
    {
      billing_id: 23645,
      subscription_name: "Basic",
      subscription_id: 123423,
      perchase_detail: "202837 3242 3432523",
      payment: "$ 123,100",
      payment_date: "01/01/2000",
      status: "paid",
    },
    {
      billing_id: 2312645,
      subscription_name: "Premium",
      subscription_id: 13424,
      perchase_detail: "202837 312242 34332523",
      payment: "$ 133,100",
      payment_date: "01/01/2000",
      status: "Unpaid",
    },
    {
      billing_id: 232345,
      subscription_name: "Business",
      subscription_id: 1225,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 132,100",
      payment_date: "01/01/2000",
      status: "paid",
    },
    {
      billing_id: 23456,
      subscription_name: "Enterprise",
      subscription_id: 12326,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 333,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
    {
      billing_id: 23567,
      subscription_name: "Custom",
      subscription_id: 12337,
      perchase_detail: "202837 323242 3432523",
      payment: "$ 123,100",
      payment_date: "23/01/2022",
      status: "Unpaid",
    },
  ];

  useEffect(() => {
    getUserBillingAndSubsRefetch();
  }, []);

  useEffect(() => {
    if (getUserBillingAndSubs === undefined) {
      setLoader(true);
    } else {
      setLoader(false);

      setUserBillingData(getUserBillingAndSubs.subscriptions);
      setUserBillingFilterData(getUserBillingAndSubs.subscriptions);
    }
  }, [getUserBillingAndSubs]);

  useEffect(() => {
    if (searchTerm.length > 0) {
      const filteredData = userBillingData.filter((item) => {
        return (
          item.id.toString().includes(searchTerm) ||
          item.plan.toString().includes(searchTerm) ||
          item.price.toString().includes(searchTerm)
        );
      });
      setUserBillingFilterData(filteredData);
    }
    if (searchTerm.length <= 0) {
      setUserBillingFilterData(userBillingData);
    }
  }, [searchTerm]);

  const handleSearch = (event) => {
    setSearchTerm(event.target.value);
  };

  return (
    <div className=" lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
        <p class=" md:text-3xl text-2xl leading-10  font-bold ">Billing & Subscription</p>
        <div className="hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
          <AvatarDropdown />
        </div>
      </div>
      <div className="bg-white rounded-2xl md:py-4 lg:px-6 ">
        <div className=" flex gap-4 border-b">
          <button
            className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px]  ${
              openBillingSection
                ? "text-[#031926]"
                : "text-[#0689BE]  border-b-2 border-[#0689BE]"
            } `}
            onClick={toggleBillingSection}
          >
            Billing
          </button>
          <button
            className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px]  ${
              openBillingSection
                ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
                : "text-[#031926]"
            } `}
            onClick={toggleBillingSection}
          >
            Subscription
          </button>
        </div>
        {/* Billing Section */}

        <div
          className={`Billing Section ${
            openBillingSection ? "hidden" : "block"
          } `}
        >
          <div className="my-4">
            {/* <span className="text-[#667085] font-normal text-[12px]">
              Total 39 billings
            </span> */}
          </div>
          {loader && (
            <div className="h-[354px] flex items-center justify-center p-4 rounded-2xl mt-4">
              <div class="flex justify-center items-center bg-white">
                <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
              </div>
            </div>
          )}
          {userBillingData?.length <= 0 && (
            <div className="h-[354px] flex items-center justify-center">
              <div className="max-w-[800px] mx-auto">
                <p className="text-[18px] text-center mt-5">
                  You currently do not have any flights in your account. Forward
                  your flight booking details to us at
                  <a
                    href="mailto:trips@marvalist.com"
                    className="font-bold text-primary mx-1"
                  >
                    trips@marvalist.com
                  </a>
                  and we will add your flight details to your account.
                </p>
              </div>
            </div>
          )}
          {/* {userBillingFilterData?.length > 0 && (
            <div className="border border-[#E2E8F0] p-4 rounded-2xl">
              <div className="flex justify-between items-center mb-4">
                <span className="text-[#667085] font-normal text-[12px]">
                  Total {userBillingFilterData.length} Bills
                </span>
                <div className="flex gap-3">
                  <div className="relative">
                    <input
                      type="text"
                      className=" w-[272px] h-full  pl-8 bg-[#F6F9FB] rounded-md outline-none"
                      placeholder="Search"
                      value={searchTerm}
                      onChange={handleSearch}
                    />
                    <Image
                      src={search}
                      alt="search"
                      className=" absolute top-2 left-1"
                    />
                  </div>
                  <button className="bg-[#0689BE] p-2 rounded-md">
                    <Image src={download} alt="download" className="" />
                  </button>
                </div>
              </div>
              <div className="overflow-x-auto border border-[#E2E8F0] rounded-2xl h-[600px] overflow-y-auto ">
                <table className="table-auto w-full">
                  <thead className="text-md font-bold capitalize text-black bg-gray-50 sticky top-0 z-10">
                    <tr>
                      <th className="p-2 py-4 pl-4 whitespace-nowrap">
                        <div className="font-semibold text-left flex items-center gap-2">
                          <input
                            type="checkbox"
                            className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                          />
                          <span className="flex items-center gap-2">
                            billing id
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          <span className="flex items-center gap-2">
                            Subscription
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          <span className="flex items-center gap-2">
                            Payment
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">Status</div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          Payment Date
                        </div>
                      </th>
                    </tr>
                  </thead>

                  <tbody className="text-sm divide-y divide-gray-100">
                    {userBillingFilterData?.length
                      ? userBillingFilterData?.map((data, index) => (
                          <tr key={index}>
                            <td className="p-2 pl-4 whitespace-nowrap">
                              <div className="flex items-center">
                                <div className="font-medium text-gray-800 flex gap-2 items-center">
                                  <input
                                    type="checkbox"
                                    className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                                  />
                                  <span className="uppercase flex  items-center gap-2">
                                    #{data?.id}
                                  </span>
                                </div>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div>
                                <p className="text-[#1F2336] font-normal ">
                                  {data?.plan}
                                </p>
                                <p className="text-[#9A9EAD]">ID:{data?.id}</p>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div className="text-[#1F2336] font-normal ">
                                ${data?.price}
                              </div>
                            </td>
                            <td className=" whitespace-nowrap">
                              <div
                                className={`text-[#1F2336] font-normal text-[14px] text-left`}
                              >
                                <span
                                  className={`p-2 rounded-3xl text-white capitalize ${
                                    data?.stripe_status == "active"
                                      ? "bg-[#52B98E]"
                                      : "bg-[#FF3F3F]"
                                  }`}
                                >
                                  {data?.stripe_status}
                                </span>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div className="text-[#1F2336] font-normal">
                                {moment(data?.created_at).format("DD-MM-YYYY")}
                              </div>
                            </td>
                          </tr>
                        ))
                      : null}
                  </tbody>
                </table>
              </div>
            </div>
          )} */}
          {userBillingData?.length > 0 && (
            <div className="border border-[#E2E8F0] p-4 rounded-2xl">
              <div className="flex justify-between items-center mb-4 flex-wrap">
                <span className="text-[#667085] font-normal text-[12px]">
                  Total {userBillingFilterData?.length} Bills
                </span>
                <div className="flex gap-3">
                  <div className="relative">
                    <input
                      type="text"
                      className=" w-[200px] md:w-[272px] h-full  pl-8 bg-[#F6F9FB] rounded-md outline-none"
                      placeholder="Search"
                      value={searchTerm}
                      onChange={handleSearch}
                    />
                    <Image
                      src={search}
                      alt="search"
                      className=" absolute top-2 left-1"
                    />
                  </div>
                  <button className="bg-[#0689BE] p-2 rounded-md">
                    <Image src={download} alt="download" className="" />
                  </button>
                </div>
              </div>
              <div className="overflow-x-auto border border-[#E2E8F0] rounded-2xl h-[354px] md:h-[600px] overflow-y-auto">
                <table className="table-auto w-full min-w-[800px]">
                  <thead className="text-md font-bold capitalize text-black bg-gray-50 sticky top-0 z-10">
                    <tr>
                      <th className="p-2 py-4 pl-4 whitespace-nowrap">
                        <div className="font-semibold text-left flex items-center gap-2">
                          <input
                            type="checkbox"
                            className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                          />
                          <span className="flex items-center gap-2">
                            billing id
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          <span className="flex items-center gap-2">
                            Subscription
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          <span className="flex items-center gap-2">
                            Payment
                            <Image src={arrowUpDown} alt="" className="" />
                          </span>
                        </div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">Status</div>
                      </th>
                      <th className="p-2 whitespace-nowrap">
                        <div className="font-semibold text-left">
                          Payment Date
                        </div>
                      </th>
                    </tr>
                  </thead>

                  <tbody className="text-sm divide-y divide-gray-100">
                    {userBillingFilterData?.length
                      ? userBillingFilterData?.map((data, index) => (
                          <tr key={index}>
                            <td className="p-2 pl-4 whitespace-nowrap">
                              <div className="flex items-center">
                                <div className="font-medium text-gray-800 flex gap-2 items-center">
                                  <input
                                    type="checkbox"
                                    className="accent-[#0689BE] h-[12px] w-[12px] cursor-pointer"
                                  />
                                  <span className="uppercase flex  items-center gap-2">
                                    #{data?.id}
                                  </span>
                                </div>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div>
                                <p className="text-[#1F2336] font-normal ">
                                  {data?.plan}
                                </p>
                                <p className="text-[#9A9EAD]">ID:{data?.id}</p>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div className="text-[#1F2336] font-normal ">
                                ${data?.price}
                              </div>
                            </td>
                            <td className=" whitespace-nowrap">
                              <div
                                className={`text-[#1F2336] font-normal text-[14px] text-left`}
                              >
                                <span
                                  className={`p-2 rounded-3xl text-white capitalize ${
                                    data?.stripe_status == "active"
                                      ? "bg-[#52B98E]"
                                      : "bg-[#FF3F3F]"
                                  }`}
                                >
                                  {data?.stripe_status}
                                </span>
                              </div>
                            </td>
                            <td className="p-2 whitespace-nowrap">
                              <div className="text-[#1F2336] font-normal">
                                {moment(data?.created_at).format("DD-MM-YYYY")}
                              </div>
                            </td>
                          </tr>
                        ))
                      : null}
                  </tbody>
                </table>
              </div>
            </div>
          )}
        </div>
        {/* Subscription Section */}
        <div className={`${openBillingSection ? "block" : "hidden"}`}>
          <Subscription currentPlan={activeObject} />
        </div>
      </div>
    </div>
  );
};

export default Billing;
