import React, { useState } from "react";
import masterCard from "../../../../public/assets/subscription/Mastercard.png";
import visaCard from "../../../../public/assets/subscription/Visa.png";
import enterPrise from "../../../../public/assets/subscription/enterprise.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faXmark } from "@fortawesome/free-solid-svg-icons";
import { loadStripe } from '@stripe/stripe-js';
import {
  Elements,
  useStripe,
  useElements,
  CardNumberElement, CardExpiryElement, CardCvcElement
} from '@stripe/react-stripe-js';
import { useSavePaymentIntentMutation } from "@/services/Api";
import toast from "react-hot-toast";

const PaymentForm = ({ plan, close }) => {

  const stripe = useStripe();
  const elements = useElements();

  const [savePaymentIntent, { isLoading: savePaymentIntentIsLoading }] = useSavePaymentIntentMutation();

  const addSubscriptionApi = () => {

    if (!stripe || !elements) {
      toast.error("Stripe has not loaded yet. Please try again later.");
      return;
    };

    const data = {
      plan_id: plan?.id,
    };

    const cardNumberElement = elements.getElement(CardNumberElement);

    stripe
      .createToken(cardNumberElement)
      .then((result) => {
        if (result.error) {
          toast.error(result.error.message, {
            position: "top-center",
          });
          return;
        }

        data.token = result.token.id;

        savePaymentIntent({ data })
          .unwrap()
          .then(() => {
            close(false);
          })
          .catch(() => {
            toast.error("Error adding subscription. Please try again.", {
              position: "top-center",
            });
          });
      })
      .catch((error) => {
        console.error("Token creation error:", error);
        toast.error("An unexpected error occurred. Please try again.", {
          position: "top-center",
        });
      });
  };

  const cardElementOptions = {
    style: {
      base: {
        color: '#32325d',
        fontFamily: 'Arial, sans-serif',
        fontSmoothing: 'antialiased',
        fontSize: '16px',
        '::placeholder': {
          color: '#aab7c4',
        },
      },
      invalid: {
        color: '#fa755a',
        iconColor: '#fa755a',
      },
    },
  };

  return (
    <div
      className="fixed inset-0 bg-slate-400 flex items-center justify-center z-50 "
    >
      <div
        className="absolute right-8 top-6 cursor-pointer"
        onClick={() => close(false)}
      >
        <FontAwesomeIcon icon={faXmark} className="text-gray-900 text-[30px]" />
      </div>
      <div className="bg-white p-6 rounded-lg shadow-lg w-full max-w-md">
        <h3 className="text-lg font-medium leading-6 text-gray-900">
          New Payment Method
        </h3>
        <div className="mt-2">
          <form className="space-y-4">
            <div className=" border border-[#E2E8F0] rounded-lg p-3">
              <div className="flex justify-between items-center">
                <div className=" flex flex-col gap-2">
                  <Image src={enterPrise} alt="" className="" />
                  <p className="text-[14px] font-semibold">{plan?.name}</p>
                </div>
                <div className="flex flex-col">
                  <p className="text-[27px] font-extrabold">
                    ${plan?.amount_per_month}
                    <span className=" text-[18px]  text-[#9A9EAD] font-normal">
                      /month
                    </span>
                  </p>
                  <p className="w-[100px] text-[#B9BEC1] text-[10px] font-normal">
                    UNLIMITED FLIGHTS & OTHER PERKS
                  </p>
                </div>
              </div>
            </div>

            <div className=" border border-[#E2E8F0] rounded-lg ">
              <div className="flex items-center justify-between border-b border-[#E2E8F0]  px-3 py-3">
                <div className="">
                  <input
                    type="radio"
                    name="paymentMethod"
                    id="creditCard"
                    defaultChecked
                    className="mr-2"
                  />
                  <label htmlFor="creditCard">Credit/debit Card</label>
                </div>
                <div className="flex items-center mt-2">
                  <Image src={masterCard} alt="MasterCard" className="mr-2" />
                  <Image src={visaCard} alt="MasterCard" className="mr-2" />
                </div>
              </div>

              <div className="p-3 cardElem">
                <div>
                  <label>Card Number</label>
                  <div className="mt-2">
                    <CardNumberElement options={cardElementOptions} />
                  </div>

                  <div className="grid md:grid-cols-2 gap-x-4 mt-5">
                    <div>
                      <label>Expiration Date</label>
                      <div className="mt-2">
                        <CardExpiryElement options={cardElementOptions} />
                      </div>
                    </div>

                    <div>
                      <label>CVC</label>
                      <div className="mt-2">
                        <CardCvcElement options={cardElementOptions} />
                      </div>
                    </div>
                  </div>
                </div>
                {/* <div>
                  <label
                    htmlFor="cardholderName"
                    className="block text-sm font-medium text-[#484F61]"
                  >
                    Cardholder Name
                  </label>
                  <input
                    type="text"
                    id="cardholderName"
                    placeholder="Name"
                    className="mt-1 block w-full px-3 py-2 bg-[#F6F9FB]  rounded-md shadow-sm outline-none"
                  />
                </div>
                <div>
                  <label
                    htmlFor="cardNumber"
                    className="block text-sm font-medium text-[#484F61]"
                  >
                    Card Number
                  </label>
                  <input
                    type="text"
                    id="cardNumber"
                    placeholder="0000 0000 0000 0000"
                    className=" bg-[#F6F9FB] mt-1 block w-full px-3 py-2  rounded-md shadow-sm outline-none"
                  />
                </div>
                <div className="flex gap-4">
                  <div>
                    <label
                      htmlFor="expirationDate"
                      className="block text-sm font-medium text-[#484F61]"
                    >
                      Expiration Date
                    </label>
                    <input
                      type="text"
                      id="expirationDate"
                      placeholder="MM / YYYY"
                      className="mt-1 block w-full px-3 py-2 bg-[#F6F9FB]  rounded-md shadow-sm outline-none"
                    />
                  </div>
                  <div>
                    <label
                      htmlFor="cvc"
                      className="block text-sm font-medium text-[#484F61]"
                    >
                      CVC
                    </label>
                    <input
                      type="text"
                      id="cvc"
                      placeholder="000"
                      className="mt-1 block w-full px-3 py-2 rounded-md  bg-[#F6F9FB] shadow-sm outline-none"
                    />
                  </div>
                </div> */}
              </div>
            </div>

            {/* <div className="flex items-center">
              <input type="checkbox" id="setAsDefault" className="mr-2" />
              <label
                htmlFor="setAsDefault"
                className="text-sm font-medium text-[#484F61]"
              >
                Set as default
              </label>
            </div> */}
          </form>
        </div>
        <div className="mt-4 flex justify-end">
          <button
            type="button"
            onClick={() => close(false)}
            className="inline-flex justify-center ml-2 rounded-md border border-transparent bg-white px-4 py-2 text-sm font-medium text-[#484F61] hover:bg-gray-50 focus:outline-none focus-visible:ring-2 focus-visible:ring-offset-2 focus-visible:ring-gray-500"
          >
            Cancel
          </button>
          <button
            type="button"
            className="inline-flex justify-center rounded-md border border-transparent bg-[#0689BE] px-4 py-2 text-sm font-medium text-white hover:bg-[#007BB5] focus:outline-none focus-visible:ring-2 focus-visible:ring-offset-2 focus-visible:ring-[#0689BE]"
            disabled={savePaymentIntentIsLoading}
            onClick={addSubscriptionApi}
          >
            {savePaymentIntentIsLoading ? "Loading..." : "Confirm"}
          </button>
        </div>
      </div>
    </div>
  );
};

const STRIPE_KEY = "pk_test_51PgSLgRwIVX09hbmqml7OadOoX55xFWahlYIYreoaENXMCUBVM2EbhF08elgR3EFGYRVizqj5w4wJE5BG17FGsYs00AMFTNxkC";

const stripePromise = loadStripe(STRIPE_KEY);

const StripePaymentForm = ({ plan, secret, close }) => {

  const appearance = {
    theme: 'stripe',
  };

  const options = {
    clientSecret: secret,
    appearance,
  };

  return (
    <>
      <Elements options={options} stripe={stripePromise}>
        <PaymentForm
          plan={plan}
          secret={secret}
          close={close}
        />
      </Elements>
    </>
  )
}

export default StripePaymentForm;