"use client";
import React, { useEffect, useState } from "react";
import "slick-carousel/slick/slick.css";
import "slick-carousel/slick/slick-theme.css";
import Slider from "react-slick";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCheck } from "@fortawesome/free-solid-svg-icons";
import PaymentForm from "./Payment";
import {
  useCreatePaymentIntentMutation,
  useGetSubsPlansQuery,
} from "@/services/Api";
import toast from "react-hot-toast";
import moment from "moment/moment";

const Subscription = ({ currentPlan }) => {
  const [isOpen, setIsOpen] = useState(false);
  const [selectedPlan, setSelectedPlan] = useState(null);
  const [secret, setSecret] = useState(null);
  const [subscriptionPlans, setSubscriptionPlans] = useState([]);
  const togglePaymentComponent = (plan) => {
    setSelectedPlan(plan);
    // setIsOpen(true);
  };

  const { data: getSubsPlans, refetch: getSubsPlansRefetch } =
    useGetSubsPlansQuery();

  const [createPaymentIntent, { isLoading: createPaymentIntentIsLoading }] =
    useCreatePaymentIntentMutation();

  const addSubscriptionApi = (planId) => {
    const data = {
      plan_id: planId,
    };

    createPaymentIntent({ data: data })
      .unwrap()
      .then((payload) => {
        setIsOpen(true);
        setSecret(payload?.client_secret);
      })
      .catch((err) => {
        toast.error("Error...!!!", {
          position: "top-center",
        });
        toast.error(err?.data?.message, {
          position: "top-center",
        });
      });
  };

  useEffect(() => {
    if (getSubsPlans) {
      setSubscriptionPlans(getSubsPlans?.plans);
    }
  }, [getSubsPlans]);

  useEffect(() => {
    getSubsPlansRefetch();
  }, []);

  var settings = {
    infinite: false,
    speed: 500,
    slidesToShow: 4,
    slidesToScroll: 1,

    responsive: [
      {
        breakpoint: 1400,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          infinite: true,
          dots: true,
        },
      },
      {
        breakpoint: 1200,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true,
          dots: true,
        },
      },

      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };
  useEffect(() => {
    const slickList = document.querySelector(".slick-list");

    if (slickList) {
      slickList.style.paddingTop = "20px";
    }
  }, []);
  const paymentPlan = [
    {
      id: 1,
      name: "Basic Plan",
      price: 0,
      description: "per editor/month billed monthly",
      features: [
        "30h Fast generations",
        "Unlimited Relaxed generations",
        "General commercial terms",
        "Access to member gallery",
        "Optional credit top ups",
        "Access to member gallery",
        "12 concurrent fast jobs",
        "3 concurrent fast jobs",
        "Optional credit top ups",
      ],
    },
    {
      id: 2,
      name: "Standard Plan",
      price: 100,
      description: "per editor/month billed monthly",
      features: [
        "30h Fast generations",
        "Unlimited Relaxed generations",
        "General commercial terms",
        "Access to member gallery",
        "Optional credit top ups",
        "Access to member gallery",
        "12 concurrent fast jobs",
        "3 concurrent fast jobs",
        "Optional credit top ups",
        "24h Fast generations",
      ],
    },
    {
      id: 3,
      name: "Premium Plan",
      price: 250,
      description: "per editor/month billed monthly",
      features: [
        "30h Fast generations",
        "Unlimited Relaxed generations",
        "General commercial terms",
        "Access to member gallery",
        "Optional credit top ups",
        "Access to member gallery",
        "12 concurrent fast jobs",
        "3 concurrent fast jobs",
        "Optional credit top ups",
        "24h Fast generations",
        "36h Fast generations",
        "Unlimited slow generations",
      ],
    },
    {
      id: 4,
      name: "Unlimited Plan",
      price: 500,
      description: "per editor/month billed monthly",
      features: [
        "30h Fast generations",
        "Unlimited Relaxed generations",
        "General commercial terms",
        "Access to member gallery",
        "Optional credit top ups",
        "Access to member gallery",
        "12 concurrent fast jobs",
        "3 concurrent fast jobs",
        "Optional credit top ups",
        "24h Fast generations",
        "36h Fast generations",
        "Unlimited slow generations",
      ],
    },
  ];

  return (
    <>
      {/* {console.log(subscriptionPlans[0].id)}
    {console.log(currentPlan.plan_id)} */}
      <div>
        <style jsx>{`
          .plan-container {
            border: 1px solid #ccc;
            border-radius: 20px;
            min-height: 550px;
            width: 200px;
            padding: 16px;
            transition: all 0.3s ease-in-out;
          }

          .plan-container:hover {
            color: white;
            background-color: #0689be;
            transform: translateY(-20px); /* Moves the element up on hover */
          }
          .slick-list{
            overflow: visible;
          }
        `}</style>
        {/* {currentPlan ? (
          <div className="py-10 border-b border-[#F2F4F7]">
            <div className=" relative  shadow-custom rounded-3xl  min-w-[323px] max-w-[350px] ">
              <div className=" absolute -top-3 left-[35%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                <div className=" text-center z-10 py-1 text-[16px] font-semibold ">
                  <span className="mr-1">ID:</span>
                  <span className="">{currentPlan?.id}</span>
                </div>
              </div>
              <div className="flex items-center gap-2 text-[18px] font-medium py-8  justify-center border-b border-gray-300">
                <p className="">Type:</p>
                {currentPlan?.plan}
              </div>
              <div className="py-6">
                <div className="grid grid-cols-2 gap-x-2  gap-y-6 px-12 gap-2 mb-6">
                  <div className="">
                    <p className="text-[#667085] font-normal text-base">
                      Billing Date
                    </p>
                    <p className="text-[#1D2939] font-semibold text-base">
                      {moment(currentPlan?.created_at).format("DD-MM-YYYY")}
                    </p>
                  </div>
                  <div className="">
                    <p className="text-[#667085] font-normal text-base">
                      Expiry
                    </p>
                    <p className="text-[#1D2939] font-semibold text-base">
                      {moment(currentPlan?.end_date).format("DD-MM-YYYY")}
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        ) : null} */}
        {/* Slider Sections */}
        <div className="slider-container py-6 md:py-8">
          <Slider {...settings} className=" slick-slider-padding">
            {subscriptionPlans &&
              subscriptionPlans.map((plan) => (
                <div
                  key={plan?.id}
                  className={`group hover:text-white hover:bg-[#0689BE]  plan-container  border text-[#1D2127] border-gray-300 rounded-3xl min-h-[550px] w-[20px] py-4 px-4 group-hover:translate-y-[-20px] ${
                    currentPlan?.plan_id === plan?.id
                      ? "bg-[#0689BE] text-white"
                      : ""
                  }`}
                >
                  <div className="flex flex-col gap-2 justify-between min-h-[550px]">
                    <div className="">
                      <p className="text-[14px]  font-semibold">{plan?.name}</p>
                      <div className="flex justify-between">
                        <p className="flex flex-col  gap-2 my-4">
                          <span className="  text-[27px] font-extrabold">
                            ${plan?.amount_per_year}
                          </span>
                          <span className="w-[100px] text-[#B9BEC1] text-[10px] font-normal">
                            per editor/month billed monthly
                          </span>
                        </p>
                        <p className="flex flex-col  gap-2 my-4">
                          <span className="  text-[27px] font-extrabold">
                            ${plan?.amount_per_month}
                          </span>
                          <span className="w-[100px] text-[#B9BEC1] text-[10px] font-normal">
                            per editor/month billed monthly
                          </span>
                        </p>
                      </div>

                      <div className="">
                        {plan?.benefits && (
                          <p className="flex flex-col gap-2">
                            <span className="font-semibold">Benefits:</span>
                            {plan?.benefits
                              ?.split(",")
                              .map((feature, index) => (
                                <p
                                  key={index}
                                  className="flex items-center gap-2"
                                >
                                  <span
                                    className={`bg-[#EBEFF0] group-hover:bg-black rounded-full h-3 w-3 flex items-center justify-center  ${
                                      currentPlan?.plan_id === plan?.id
                                        ? "bg-black"
                                        : ""
                                    }`}
                                  >
                                    <FontAwesomeIcon
                                      icon={faCheck}
                                      className={`w-2 h-2 text-gray-400 group-hover:text-white  ${
                                        currentPlan?.plan_id === plan?.id
                                          ? "text-white"
                                          : ""
                                      }`}
                                    />
                                  </span>
                                  {feature?.trim()}
                                </p>
                              ))}
                          </p>
                        )}
                      </div>
                    </div>
                    <div className=" text-center">
                      {currentPlan?.plan_id === plan?.id ? (
                        <div className="bg-white py-2 text-[#0689BE] w-[200px] mx-auto rounded-xl text-center font-semibold">
                          Activated
                        </div>
                      ) : (
                        <button
                          onClick={() => {
                            togglePaymentComponent(plan);
                            addSubscriptionApi(plan?.id);
                          }}
                          className="bg-[#0689BE] py-2 text-center w-[200px] rounded-xl text-white group-hover:text-[#0689BE] group-hover:bg-white"
                          disabled={createPaymentIntentIsLoading}
                        >
                          Choose plan
                        </button>
                      )}
                    </div>
                  </div>
                </div>
              ))}
          </Slider>
        </div>
      </div>
      {isOpen && (
        <PaymentForm
          togglePaymentComponent={togglePaymentComponent}
          close={setIsOpen}
          plan={selectedPlan}
          secret={secret}
        />
      )}
    </>
  );
};

export default Subscription;
