import React from "react";
import Link from "next/link";
import { usePathname } from "next/navigation";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faGreaterThan } from "@fortawesome/free-solid-svg-icons";
const Breadcrumbs = () => {
  const path = usePathname();

  if (!path) {
    return null;
  }

  const pathnames = path.split("/").filter((x) => x);

  return (
    <ol className="list-reset flex">
      <li>
        <Link href="/" className="text-[#667085] ">
          Home
        </Link>
      </li>
      {pathnames.map((value, index) => {
        const isLast = index === pathnames.length - 1;
        const to = `/${pathnames.slice(0, index + 1).join("/")}`;

        return (
          <li key={to} className="flex gap-4 items-center">
            <FontAwesomeIcon
              icon={faGreaterThan}
              className="text-[#667085] ml-4 h-3 w-3"
            />
            {isLast ? (
              <span className="text-[#0689BE] capitalize">{value}</span>
            ) : (
              <Link href={to} className="text-[#667085]  capitalize">
                {value}
              </Link>
            )}
          </li>
        );
      })}
    </ol>
  );
};

export default Breadcrumbs;
