"use client";
import React, { useState, useEffect } from "react";
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import bellLogo from "../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../public/assets/profile/Avatar.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faAngleDown } from "@fortawesome/free-solid-svg-icons";
import Detail from "./detail/Detail";
import Breadcrumbs from "../breadcrumbs/Breadcrumbs";
import { useRouter } from "next/navigation";
import { useGetUserFlightsQuery } from "@/services/Api";
import { useSelector } from "react-redux";
import AvatarDropdown from "../avatardropdown/avatardropdown";
import { BASE_URL } from "@/services/ApiEndpoints";

const Flight = () => {
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const router = useRouter();
  const [flightsData, setFlightsData] = useState([]);
  const [startDate, setStartDate] = useState(new Date());
  const [yearPickerOpen, setYearPickerOpen] = useState(false);
  const [monthPickerOpen, setMonthPickerOpen] = useState(false);
  const auth = useSelector((data) => data?.auth);
  const [flights, setFlights] = useState([]);
  const [allFlights, setAllFlights] = useState([]);
  const [selectedFlightId, setSelectedFlightId] = useState(null);
  const [showFlights, setShowFlights] = useState(true);
  const [flightLoading, setFlightLoading] = useState(true);
  const [dateFilter, setDateFilter] = useState({
    startDate: "",
    endDate: "",
  });
  const [flightTab, setFlightTab] = useState("upcoming flight");
  const [upcomingFlights, setUpcomingFlights] = useState([]);
  const [previousFlights, setPreviousFlights] = useState([]);
  // const month = startDate.getMonth() + 1;
  // const year = startDate.getFullYear();
  // const day = startDate.getDate();
  // const { data: getUserFlights, refetch: getUserFlightsRefetch } =
  //   useGetUserFlightsQuery({ id: auth?.userDetail?.id, year, month, day });
  // useEffect(() => {
  //   console.log("Start date changed:", startDate);
  //   console.log("Month:", month);
  //   console.log("Year:", year);
  //   getUserFlightsRefetch();
  // }, [startDate, day, month, year, getUserFlightsRefetch]);

  // useEffect(() => {
  //   try {
  //     const response = fetch(
  //       `https://tracking.logoinnovators.com/backend/api/user/${auth?.userDetail?.id}/flights`,
  //       {
  //         method: "GET",
  //         headers: {
  //           "Content-Type": "application/json",
  //           Authorization: `Bearer ${auth.token}`,
  //         },
  //       }
  //     );
  //     response.then((item)=>{
  //       console.log(item);
  //     })
  //     if (response.length > 0){
  //       const formattedFlights = response.map((flight) => ({
  //         airline_name: flight.airline_name,
  //         arrival_airport: flight.arrival_airport,
  //         arrival_terminal: flight.arrival_terminal,
  //         arrival_time: flight.arrival_time,
  //         departure_airport: flight.departure_airport,
  //         departure_terminal: flight.departure_terminal,
  //         departure_time: flight.departure_time,
  //         duration: flight.duration,
  //         flight_number: flight.flight_number,
  //         leg_duration: flight.leg_duration,
  //         segment_duration: flight.segment_duration,
  //         status: flight.status,
  //         ticket_type: flight.ticket_type,
  //         user_id: flight.id,
  //       }));
  //       console.log(formattedFlights);
  //       setFlights(formattedFlights);
  //     }
  //   } catch (error) {}
  // }, []);

  const previousFlightGetHandler = (flightData) => {
    let previousFlightFilter = flightData.filter(
      (item) =>
        new Date().setHours(0, 0, 0, 0) >=
        new Date(item.arrival_time).setHours(23, 59, 59, 999)
    );

    setPreviousFlights(previousFlightFilter);
  };

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await fetch(
          `https://tracking.logoinnovators.com/backend/api/user/${auth?.userDetail?.id}/flights`,
          {
            method: "GET",
            headers: {
              "Content-Type": "application/json",
              Authorization: `Bearer ${auth.token}`,
            },
          }
        );

        if (!response.ok) {
          console.error("Failed to fetch data:", response.statusText);
          return;
        }

        const flightData = await response.json();
        flightData.map((flight) => ({
          airline_name: flight.airline_name,
          arrival_airport: flight.arrival_airport,
          arrival_terminal: flight.arrival_terminal,
          arrival_time: flight.arrival_time,
          departure_airport: flight.departure_airport,
          departure_terminal: flight.departure_terminal,
          departure_time: flight.departure_time,
          duration: flight.duration,
          flight_number: flight.flight_number,
          leg_duration: flight.leg_duration,
          segment_duration: flight.segment_duration,
          status: flight.status,
          ticket_type: flight.ticket_type,
          user_id: flight.id,
        }));

        setFlightLoading(false);

        setFlights(flightData);
        setAllFlights(flightData);

        // let previousFlightFilter = flightData.filter(
        //   (item) =>
        //     new Date().setHours(0, 0, 0, 0) >=
        //     new Date(item.arrival_time).setHours(23, 59, 59, 999)
        // );
        // setPreviousFlights(previousFlightFilter);

        previousFlightGetHandler(flightData);

        let upcomingFlightFilter = flightData.filter(
          (item) =>
            new Date().setHours(0, 0, 0, 0) <=
            new Date(item.arrival_time).setHours(23, 59, 59, 999)
        );
        setUpcomingFlights(upcomingFlightFilter);
      } catch (error) {
        setFlightLoading(false);
        console.error("Error fetching flight data:", error);
      }
    };

    fetchData();
  }, []); // empty dependency array so this runs only once on mount

  // useEffect(() => {
  //   if (getUserFlights && Array.isArray(getUserFlights)) {
  //     const formattedFlights = getUserFlights.map((flight) => ({
  //       airline_name: flight.airline_name,
  //       arrival_airport: flight.arrival_airport,
  //       arrival_terminal: flight.arrival_terminal,
  //       arrival_time: flight.arrival_time,
  //       departure_airport: flight.departure_airport,
  //       departure_terminal: flight.departure_terminal,
  //       departure_time: flight.departure_time,
  //       duration: flight.duration,
  //       flight_number: flight.flight_number,
  //       leg_duration: flight.leg_duration,
  //       segment_duration: flight.segment_duration,
  //       status: flight.status,
  //       ticket_type: flight.ticket_type,
  //       user_id: flight.id,
  //     }));
  //     setFlights(formattedFlights);
  //   }
  // }, [getUserFlights]);

  const formatMonth = (date) =>
    date.toLocaleString("default", { month: "long" });

  const formatYear = (date) => date.getFullYear();

  const handleFlightDetails = (flight) => {
    setFlightsData(flight);
    setShowFlights(false);
  };
  const handleGoBack = () => {
    setShowFlights(true);
    // setSelectedFlightId(null);
  };

  const handleDateFilter = () => {
    let start_date = new Date(dateFilter.startDate);
    let end_date = new Date(dateFilter.endDate);

    start_date.setHours(0, 0, 0, 0);
    end_date.setHours(23, 59, 59, 999);

    const filteredFlights = allFlights.filter((item) => {
      const arrivalDate = new Date(item.arrival_time);
      arrivalDate.setHours(0, 0, 0, 0);

      return arrivalDate >= start_date && arrivalDate <= end_date;
    });

    setPreviousFlights(filteredFlights);
  };

  return (
    <div className="lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      {showFlights ? (
        <div>
          <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
            <div className="text-[#0689BE] text-[20px] pl-4 sm:pl-0">
              {/* <Breadcrumbs /> */}
            </div>
            <div className="hidden lg:flex items-center gap-4">
              <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
              {/* <Image src={profilePic} alt="" className="h-11 w-11" /> */}
              <AvatarDropdown />
            </div>
          </div>
          <div className="bg-[#FFFFFF] p-4 md:p-6 rounded-2xl border">
            <h2 className="mb-4 text-xl md:text-2xl font-bold">Flights Details</h2>
            <div className="">
              <div className=" flex gap-4 border-b mb-6">
                <button
                  className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${
                    flightTab === "upcoming flight"
                      ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
                      : "text-[#031926]"
                  } `}
                  onClick={() => setFlightTab("upcoming flight")}
                >
                  Upcoming Flights
                </button>
                <button
                  className={`font-bold py-2 px-2 sm:px-4 text-[14px] md:text-[16px] ${
                    flightTab === "previous flight"
                      ? "text-[#0689BE]  border-b-2 border-[#0689BE]"
                      : "text-[#031926]"
                  } `}
                  onClick={() => setFlightTab("previous flight")}
                >
                  Previous Flights
                </button>
              </div>
              {flightTab === "previous flight" && (
                <div className="flex text-lg items-center font-semibold gap-4 py-2 mb-3 flex-wrap">
                  {/* <div className="text-[16px]">Select Date:</div>
                <div className="">
                  <button
                    className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[170px] justify-between font-medium"
                    onClick={() => setMonthPickerOpen(!monthPickerOpen)}
                  >
                    {formatMonth(startDate)}
                    <FontAwesomeIcon
                      icon={faAngleDown}
                      className="text-[14px]"
                    />
                  </button>
                  {monthPickerOpen && (
                    <div className="absolute z-20">
                      <DatePicker
                        selected={startDate}
                        onChange={(date) => {
                          setStartDate(date);
                          setMonthPickerOpen(false);
                          console.log(date);
                        }}
                        dateFormat="MM"
                        showFullMonthYearPicker
                        inline
                      />
                    </div>
                  )}
                </div>
                <div className="">
                  <button
                    className="relative flex items-center gap-1 border p-2 rounded-lg text-[14px] min-w-[140px] justify-between font-medium"
                    onClick={() => setYearPickerOpen(!yearPickerOpen)}
                  >
                    {formatYear(startDate)}
                    <FontAwesomeIcon icon={faAngleDown} className="h-4 w-4" />
                  </button>
                  {yearPickerOpen && (
                    <div className="absolute z-20">
                      <DatePicker
                        selected={startDate}
                        onChange={(date) => {
                          setStartDate(date);
                          setYearPickerOpen(false);
                        }}
                        showYearPicker
                        dateFormat="yyyy"
                        inline
                      />
                    </div>
                  )}
                </div> */}
                  <div>
                    <label className="form-label block">Start Date:</label>
                    <input
                      type="date"
                      name="startdate"
                      min={new Date().toISOString()}
                      max={new Date().toISOString().split("T")[0]}
                      onChange={(e) =>
                        setDateFilter((prev) => {
                          return {
                            ...prev,
                            startDate: e.target.value,
                          };
                        })
                      }
                      value={dateFilter.startDate}
                      className="relative border p-2 rounded-lg text-[14px] w-[150px] sm:w-[200px] font-medium"
                      required
                    />
                  </div>
                  <div>
                    <label className="form-label block">End Date:</label>
                    <input
                      type="date"
                      name="enddate"
                      // disabled={account.startdate === "" ? true: false}
                      min={new Date().toISOString()}
                      max={new Date().toISOString().split("T")[0]}
                      className="relative border p-2 rounded-lg text-[14px] w-[150px] sm:w-[200px] font-medium"
                      value={dateFilter.endDate}
                      onChange={(e) =>
                        setDateFilter((prev) => {
                          return {
                            ...prev,
                            endDate: e.target.value,
                          };
                        })
                      }
                      required
                    />
                  </div>
                  <div className="flex self-end">
                    <button
                      disabled={
                        dateFilter.startDate === "" || dateFilter.endDate === ""
                          ? true
                          : false
                      }
                      type="button"
                      className={`flex py-2 text-[14px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group ${
                        dateFilter.startDate === "" || dateFilter.endDate === ""
                          ? "opacity-75"
                          : ""
                      }`}
                      onClick={handleDateFilter}
                    >
                      Search
                    </button>
                  </div>
                  <div className="flex self-end">
                    <button
                      disabled={
                        dateFilter.startDate === "" && dateFilter.endDate === ""
                          ? true
                          : false
                      }
                      type="button"
                      className={`flex py-2 text-[14px] bg-[#0689BE] rounded-lg text-white flex items-center gap-2 px-4 hover:bg-[#0689BE] hover:rounded-lg hover:text-white group ${
                        dateFilter.startDate === "" && dateFilter.endDate === ""
                          ? "opacity-75"
                          : ""
                      }`}
                      onClick={() => {
                        setDateFilter({
                          endDate: "",
                          startDate: "",
                        });
                        previousFlightGetHandler(allFlights);
                      }}
                    >
                      Reset
                    </button>
                  </div>
                </div>
              )}
            </div>
            {flightLoading && (
              <div className="h-[354px] flex items-center justify-center p-4 rounded-2xl mt-4">
                <div class="flex justify-center items-center bg-white">
                  <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
                </div>
              </div>
            )}
            {!flightLoading && flightTab === "upcoming flight" && (
              <>
                {upcomingFlights.length <= 0 && (
                  <div className="h-[354px] flex items-center justify-center">
                    <div className="max-w-[800px] mx-auto">
                      <p className="text-[18px] text-center mt-5">
                        You currently do not have any flights in your account.
                        Forward your flight booking details to us at
                        <a
                          href="mailto:trips@marvalist.com"
                          className="font-bold text-primary mx-1"
                        >
                          trips@marvalist.com
                        </a>
                        and we will add your flight details to your account.
                      </p>
                    </div>
                  </div>
                )}
                <div className="grid xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 py-5">
                  {upcomingFlights.map((flight) => (
                    <div
                      onClick={() => handleFlightDetails(flight)}
                      key={flight.user_id}
                      className="relative shadow-custom rounded-3xl cursor-pointer transition ease-in-out hover:-translate-y-2"
                    >
                      <div className="absolute -top-3 left-[37%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                        <div className="text-center z-10 py-1 text-[16px] font-semibold">
                          <span className="mr-1">ID:</span>
                          <span>{flight.user_id}</span>
                        </div>
                      </div>
                      <div className="flex items-center gap-2 text-[18px] font-medium py-8 px-8 border-b border-gray-300">
                        <p className="text-[#667085] font-normal text-base">Flight From:</p>
                        {flight.departure_airport} to {flight.arrival_airport}
                      </div>
                      <div className="py-6">
                        <div className="grid grid-cols-2 gap-x-2 gap-y-6 px-8 gap-2 mb-6">
                          <div>
                            <p className="text-[#667085] font-normal text-base">
                              Date of Flight
                            </p>
                            <p className="text-[#1D2939] font-semibold text-base">
                              {new Date(
                                flight.arrival_time
                              ).toLocaleDateString()}
                            </p>
                          </div>
                          <div>
                            <p className="text-[#667085] font-normal text-base">
                              Airfield
                            </p>
                            <p className="text-[#1D2939] font-semibold text-base">
                              {flight.airline_name}
                            </p>
                          </div>
                          <div>
                            <p className="text-[#667085] font-normal text-base">
                              Departure time
                            </p>
                            <p className="text-[#1D2939] font-semibold text-base">
                              {new Date(
                                flight.departure_time
                              ).toLocaleTimeString([], {
                                hour: "2-digit",
                                minute: "2-digit",
                              })}
                            </p>
                          </div>
                          <div>
                            <p className="text-[#667085] font-normal text-base">
                              Flight duration
                            </p>
                            <p className="text-[#1D2939] font-semibold text-base">
                              {flight.duration}
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  ))}
                </div>
              </>
            )}
            {!flightLoading &&
              flightTab === "previous flight" &&
              previousFlights.length <= 0 &&
              dateFilter.startDate === "" &&
              dateFilter.endDate === "" && (
                <div className="h-[354px] flex items-center justify-center">
                  <p className="text-[18px] text-center mt-5">
                    Sorry, we don't have any previous flight data.
                  </p>
                </div>
              )}
            {!flightLoading && flightTab === "previous flight" && (
              <>
                {previousFlights.length <= 0 &&
                dateFilter.startDate !== "" &&
                dateFilter.endDate !== "" ? (
                  <div className="h-[354px] flex items-center justify-center">
                    <p className="text-[18px] text-center mt-5">
                      Sorry, no flights are available on the selected date.
                    </p>
                  </div>
                ) : (
                  <div className="grid xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 gap-x-6 gap-y-6 py-5">
                    {previousFlights.map((flight) => (
                      <div
                        onClick={() => handleFlightDetails(flight)}
                        key={flight.user_id}
                        className="relative shadow-custom rounded-3xl cursor-pointer transition ease-in-out hover:-translate-y-2"
                      >
                        <div className="absolute -top-3 left-[37%] rounded-3xl w-[117px] bg-[#0689BE] text-white">
                          <div className="text-center z-10 py-1 text-[16px] font-semibold">
                            <span className="mr-1">ID:</span>
                            <span>{flight.user_id}</span>
                          </div>
                        </div>
                        <div className="flex items-center gap-2 text-[18px] font-medium py-8 px-8 border-b border-gray-300">
                          <p className="text-[#667085] font-normal text-base">Flight From:</p>
                          {flight.departure_airport} to {flight.arrival_airport}
                        </div>
                        <div className="py-6">
                          <div className="grid grid-cols-2 gap-x-2 gap-y-6 px-8 gap-2 mb-6">
                            <div>
                              <p className="text-[#667085] font-normal text-base">
                                Date of Flight
                              </p>
                              <p className="text-[#1D2939] font-semibold text-base">
                                {new Date(
                                  flight.arrival_time
                                ).toLocaleDateString()}
                              </p>
                            </div>
                            <div>
                              <p className="text-[#667085] font-normal text-base">
                                Airfield
                              </p>
                              <p className="text-[#1D2939] font-semibold text-base">
                                {flight.airline_name}
                              </p>
                            </div>
                            <div>
                              <p className="text-[#667085] font-normal text-base">
                                Departure time
                              </p>
                              <p className="text-[#1D2939] font-semibold text-base">
                                {new Date(
                                  flight.departure_time
                                ).toLocaleTimeString([], {
                                  hour: "2-digit",
                                  minute: "2-digit",
                                })}
                              </p>
                            </div>
                            <div>
                              <p className="text-[#667085] font-normal text-base">
                                Flight duration
                              </p>
                              <p className="text-[#1D2939] font-semibold text-base">
                                {flight.duration}
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                    ))}
                  </div>
                )}
              </>
            )}
          </div>
        </div>
      ) : (
        <Detail flightData={flightsData} onGoBack={handleGoBack} />
      )}
    </div>
  );
};

export default Flight;
