"use client";
import React, { useState, useEffect } from "react";
import bellLogo from "../../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../../public/assets/profile/Avatar.png";
import locationLogo from "../../../../../public/assets/flights/location.png";
import clockLogo from "../../../../../public/assets/flights/clock.png";
import calendarLogo from "../../../../../public/assets/flights/calendar.png";
import takeOff from "../../../../../public/assets/flights/airplane-take-off.png";
import landing from "../../../../../public/assets/flights/airplane-landing.png";
import group from "../../../../../public/assets/flights/group.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faLessThan } from "@fortawesome/free-solid-svg-icons";
import Breadcrumbs from "../../breadcrumbs/Breadcrumbs";
import { useSelector } from "react-redux";  

function Detail({flightData , onGoBack}) {
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);   
  useEffect(() => {
    console.log("User ID:", flightData.arrival_airport); 

  }, [flightData]);
  return (
    <div className="lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      <div className="h-[100px] flex justify-between items-center">
        <div className="text-[#0689BE] text-[20px] pl-4 sm:pl-0">
          {/* <Breadcrumbs /> */}
        </div>
        <div className="hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />
          {/* <Image src={profilePic} alt="" className="h-11 w-11" /> */}
            <img
                          src={globalProfileImg
                            ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`
                            : profilePic}
                          alt=""
                          className="h-11 w-11 object-cover rounded-full"
          
                        />
        </div>
      </div>
         <div className="mb-3 flex justify-end">
              <button
                onClick={onGoBack}
                className="flex items-center justify-center gap-3 text-[#484F61] border border-[#484F61] p-2  rounded-md"
              >
                <FontAwesomeIcon icon={faLessThan} />
                Go Back
              </button>
            </div>
      <div className="bg-[#FFFFFF] p-6 rounded-2xl">
        <div className="grid md:grid-cols-2 md:gap-y-10 gap-x-10 gap-y-6">
          <div className="rounded-xl border max-w-[488px]">
            <div className="border-b px-4 py-4">
              <p className="bg-[#0689BE] w-[120px] text-center text-white rounded-2xl py-1">
                {/* ID: 3287982 */}
                {flightData?.user_id}
              </p>
            </div>
            <div className="py-4 px-4">
              <div className="pb-4 flex gap-4 justify-between border-dashed border-b">
                <div>
                  <h1 className="text-[36px] font-bold">{flightData?.departure_airport}</h1>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={locationLogo} alt="" className="h-4 w-4" />
                    <p>{flightData?.departure_airport}</p>
                  </div>
                </div>
                <div className=" flex flex-col items-center">
                  <Image src={group} alt="group" className="object-cover" />
                  <span className="text-xs font-normal text-[#8C8B92]">
                  <p>{flightData.duration}</p>
                  </span>
                </div>
                <div>
                  <h1 className="text-[36px] font-bold">{flightData?.arrival_airport }</h1>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={locationLogo} alt="" className="h-4 w-4" />
                    <p>{flightData?.arrival_airport }</p>
                  </div>
                </div>
              </div>
              <div className="flex justify-between items-center pt-4">
                <div className="flex flex-col gap-1">
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    Departure
                  </p>
                  <p className="text-[#1D2939] text-[18px] font-medium">
                  {new Date(flightData.departure_time).toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' })}
                  </p>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={clockLogo} alt="" className="h-4 w-4" />
                    <p className="text-[14px]">  {new Date(flightData.departure_time).toLocaleDateString()}</p>
                  </div>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={calendarLogo} alt="" className="h-4 w-4" />
                    <p className="text-[14px]">CDT (GMT -05:00)</p>
                  </div>
                </div>
                <div className="flex flex-col gap-1">
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                  {new Date(flightData.arrival_time).toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' })}
                  </p>
                  <p className="text-[#1D2939] text-[18px] font-medium">
                    07:51 AM
                  </p>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={clockLogo} alt="" className="h-4 w-4" />
                    <p className="text-[14px]">16 March 2024</p>
                  </div>
                  <div className="flex items-center gap-1 text-[#8C8B92]">
                    <Image src={calendarLogo} alt="" className="h-4 w-4" />
                    <p className="text-[14px]">EDT (GMT -05:00)</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="rounded-xl border max-w-[488px]">
            <div className="border-b px-4 py-4 text-[#1D2939] text-[18px] font-semibold">
              GENERAL INFO
            </div>
            <div className="flex justify-between py-3 px-4">
              <div className="flex flex-col gap-2">
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    flight number
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">{flightData.flight_number}</p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    booking reference
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">-</p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    airline
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    {flightData.airline_name}
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    class of service
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    Business
                  </p>
                </div>
              </div>
              {/* <div className="flex flex-col gap-2">
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    flight number
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">105-21</p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    booking reference
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">-</p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    airline
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    Fly Emirates
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    class of service
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    Business
                  </p>
                </div>
              </div> */}
            </div>
          </div>
          <div className="rounded-xl border max-w-[488px]">
            <div className="border-b flex items-center gap-2 px-4 py-4 text-[#1D2939] text-[18px] font-semibold">
              <Image src={takeOff} alt="" className="h-6 w-6" /> From
            </div>
            <div className="flex gap-8 py-3 px-4">
              <div className="flex flex-col gap-2">
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    DEPARTURE AIRPORT
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                  {flightData?.departure_airport}
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    off-block time
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    3:52 AM
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    off-block date
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    16 March, 2024
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    departure date
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                  {new Date(flightData.departure_time).toLocaleDateString()}
                  </p>
                </div>
              </div>
              <div className="flex flex-col gap-8">
                {/* <div className="flex items-center gap-1 text-[#8C8B92]">
                  <Image src={locationLogo} alt="" className="h-4 w-4" />
                  <p className="text-[14px]">Dellas Texas</p>
                </div> */}
                <div className="flex items-center gap-1 text-[#8C8B92]">
                  <Image src={clockLogo} alt="" className="h-4 w-4" />
                  <p className="text-[14px]">CDT (GMT -05:00)</p>
                </div>
              </div>
            </div>
          </div>
          <div className="rounded-xl border max-w-[488px]">
            <div className="border-b flex items-center gap-2 px-4 py-4 text-[#1D2939] text-[18px] font-semibold">
              <Image src={landing} alt="" className="h-6 w-6" /> To
            </div>
            <div className="flex gap-8 py-3 px-4">
              <div className="flex flex-col gap-2">
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    arrival airport
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                  {flightData?.arrival_airport }
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    arrival (touchdown) time
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    3:52 AM
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    arrival (touchdown) date
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                  {new Date(flightData.arrival_time).toLocaleDateString()}
                  </p>
                </div>
                <div>
                  <p className="text-[#8C8B92] text-[14px] uppercase">
                    on-block date
                  </p>
                  <p className="text-[#1D2939] text-[14px] font-bold">
                    16 March, 2024
                  </p>
                </div>
              </div>
              <div className="flex flex-col gap-8">
                {/* <div className="flex items-center gap-1 text-[#8C8B92]">
                  <Image src={locationLogo} alt="" className="h-4 w-4" />
                  <p className="text-[14px]">Dellas Texas</p>
                </div> */}
                <div className="flex items-center gap-1 text-[#8C8B92]">
                  <Image src={clockLogo} alt="" className="h-4 w-4" />
                  <p className="text-[14px]">CDT (GMT -05:00)</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default Detail;
