"use client";
import Image from "next/image";
import React, { useState, useEffect } from "react";
import leftbg from "../../../../public/assets/loginForm/left-bg.png";
import mLogo from "../../../../public/assets/loginForm/m-logo.png";
import loginSuccessIcon from "../../../../public/assets/loginForm/login-success.svg";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope } from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";
import { useFormik } from "formik";
import * as Yup from "yup";
import { useForgotPasswordMutation } from "@/services/Api";
import toast from "react-hot-toast";
const Modal = ({ isModalVisible, closeModal , response }) => {
  return (
    <div
    className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${isModalVisible ? 'opacity-100 pointer-events-auto' : 'opacity-0 pointer-events-none'} transition-opacity duration-500 z-50`}
  >
     <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
      <Image
            src={loginSuccessIcon}
            alt=""
            className=" max-w-[45px] "
          />
          <h2 className="text-xl font-bold mt-3 text-center" style={{ color: "#0689BE" }}>
             {response}
            </h2>
      </div>
    </div>
  );
};

const ForgotPassword = () => {

  const [forgotPassword, { isLoading: forgotPasswordIsLoading }] = useForgotPasswordMutation();
   const [error, setError] = useState("");
   const [response, setResponse] = useState("");
     const [isModalVisible, setIsModalVisible] = useState(false)
     useEffect(() => {
      const timer = setTimeout(() => {
        setIsModalVisible(false);
      }, 1000); // 1000ms delay
  
      return () => clearTimeout(timer); // Cleanup on component unmount
    }, [response])
   
     const closeModal = () => {
       setIsModalVisible(false);
     };
   

  const formik = useFormik({
    initialValues: {
      email: "",
    },

    validationSchema: Yup.object({
      email: Yup.string()
        .email("Invalid email address")
        .required("Email is required"),
    }),

    // onSubmit: async (values, { setSubmitting }) => {
    //   const res = await forgotPassword({ data: values });
    //   console.log("Error message: " + res?.error?.data?.message);

    //   toast.success(res?.data?.message);
    //   setSubmitting(false);
    // },
    onSubmit: async (values, { setSubmitting }) => {
      try {
        const res = await forgotPassword({ data: values });
        if (res?.error) {
          console.log("Error message: " + res?.error?.data?.message);
          // toast.error(res?.error?.data?.message);  
          setError(res?.error?.data?.message);
        } else {
          setError('');
          setResponse(res?.data?.message);
          setIsModalVisible(true);
          setTimeout(() => {
            setIsModalVisible(false);
          }, 2000);
          // toast.success(res?.data?.message); 
        }
      } catch (error) {
        console.error("Unexpected error: ", error);
        // toast.error("An error occurred while processing your request.");
        setError(error);
      } finally {
        setSubmitting(false);
      }
    }
    
  });

  return (
    <div className="flex flex-col md:flex-row justify-between  min-h-screen">
       <Modal isModalVisible={isModalVisible} closeModal={closeModal} response={response} />
       <div className="hidden md:block relative flex-grow-1">
        <div className="absolute inset-0 z-0">
          <Image
            src={leftbg}
            alt=""
            className="w-full object-cover h-full"
          />
        </div>
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="max-w-[250px] md:max-w-[300px] lg:max-w-[400px] xl:max-w-[500px]"
          />
        </div>
      </div>
      <div className="md:hidden  bg-[#0689BE] py-12 rounded-bl-[50px] rounded-br-[50px] ">
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="max-w-[250px]"
          />
        </div>
      </div>
      <div className="flex justify-center items-center my-auto md:min-h-screen w-full md:w-1/2 lg:w-[40%] bg-white py-8 py-md-10 px-8 md:px-6">
        <div className="bg-white w-full max-w-sm ">
          <div className="mb-10 text-center">
            <h1 className="text-3xl font-bold ">Forgot Your Password?</h1>
            <p className="">No problem, we’ve got you.</p>
          </div>

          <form className="flex flex-col gap-6" onSubmit={formik.handleSubmit}>
            <div>
              <div className="relative">
                <input
                  type="email"
                  id="email"
                  name="email"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${formik.touched.email && formik.errors.email
                    ? "border-red-500 border"
                    : ""
                    }`}
                  placeholder="Email Address"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.email}
                  disabled={forgotPasswordIsLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faEnvelope}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.email && formik.errors.email ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.email}
                </div>
              ) : null}
            </div>
            {error && (
            <div className="text-red-500 text-left text-sm">
              <p>{error}</p>
            </div>
              )}
            <div>
              <button
                type="submit"
                className=" rounded-lg w-full py-3 bg-[#0689BE] text-white font-semibold"
                disabled={forgotPasswordIsLoading}
              >
                {forgotPasswordIsLoading ? "Loading..." : "Forgot Password"}
              </button>
            </div>
          </form>

          <div className="mt-4 text-center">
            <p className="text-sm ">
              Already have an account?
              <Link
                href="/login"
                className="ml-2 text-sm font-normal text-blue-500 hover:underline"
              >
                Login
              </Link>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ForgotPassword;
