"use client";
import Image from "next/image";
import Cookies from "js-cookie";
import React, { useState , useEffect} from "react";
import leftbg from "../../../../public/assets/loginForm/left-bg.png";
import mLogo from "../../../../public/assets/loginForm/m-logo.png";
import loginSuccessIcon from "../../../../public/assets/loginForm/login-success.svg";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { setGlobalProfileImg } from "@/redux/authSlice";

import {
  faEnvelope,
  faLock,
  faEye,
  faEyeSlash,
} from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";
import { useFormik } from "formik";
import * as Yup from "yup";
import toast from "react-hot-toast";
import { useRouter } from "next/navigation";
import { useLoginUserMutation } from "@/services/Api";
import { loggedIn } from "@/redux/authSlice";
import { useDispatch } from "react-redux";

const Modal = ({ isModalVisible, closeModal }) => {
  return (
    <div
    className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${isModalVisible ? 'opacity-100 pointer-events-auto' : 'opacity-0 pointer-events-none'} transition-opacity duration-500 z-50`}
  >
     <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
      <Image
            src={loginSuccessIcon}
            alt=""
            className=" max-w-[45px] "
          />
          <h2 className="text-xl font-bold mt-3 text-center" style={{ color: "#0689BE" }}>
              Login Successful
            </h2>
      </div>
    </div>
  );
};
const Login = () => {
  const router = useRouter();
  const [passShow, setPassShow] = useState(false);
  const [error, setError] = useState("");
  const dispatch = useDispatch();
  const [response, setResponse] = useState(null);
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [loginSuccessfully, setLoginSuccessfully] = useState(false);

  useEffect(() => {
    const timer = setTimeout(() => {
      setIsModalVisible(false);
    }, 1000); // 500ms delay

    return () => clearTimeout(timer); // Cleanup on component unmount
  }, []);

  const closeModal = () => {
    setIsModalVisible(false);
  };

  const handlePassShow = () => {
    setPassShow(!passShow);
  };

  const [loginUser, { isLoading: loginUserIsLoading }] = useLoginUserMutation();

  

  const formik = useFormik({
    initialValues: {
      email: "",
      password: "",
    },

    validationSchema: Yup.object({
      email: Yup.string()
        .email("Invalid email address")
        .required("Email is required"),
      password: Yup.string()
        .min(4, "Password must be at least 6 characters long")
        .required("Password is required"),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      try {
        const res = await loginUser({ data: values });

        if (!res?.error) {
          const token = res?.data?.token;
          const role = res?.data?.role;
          Cookies.set("authToken", token, { path: "/" });
          Cookies.set("role", role, { path: "/" });

          const userDetail = {
            role: res?.data?.role,
            id: res?.data?.user?.id,
          };
          const response = {
            token: res?.data?.token,
            user: userDetail,
            name: res?.data?.user?.name, // Corrected the syntax here
          };
          console.log("check data" + JSON.stringify(res?.data?.user?.name));  // To get the name
          console.log("check data" + JSON.stringify(res?.data?.user?.email)); // To get the email
          
          // console.log("response:", JSON.stringify(res, null, 2) + res?.data?.user?.profile_photo_path);

          dispatch(loggedIn(response));
          dispatch(setGlobalProfileImg({
            profilePhoto: res?.data?.user?.profile_photo_path,
            name: res?.data?.user?.name,
            email: res?.data?.user?.email
          }));

          setLoginSuccessfully(true);
          setIsModalVisible(true);
          // console.log('userDetail' + JSON.stringify(userDetail));
          // toast.success("Login successful!");
          setTimeout(() => {
            setIsModalVisible(false);
            // Redirect after hiding the modal
            if (role === "admin") {
              router.push("/users");
            } else if (role === "user") {
              router.push("/flights");
            }
          }, 1000);
        } else {
          // alert(2);
          setLoginSuccessfully(false);
          console.log("=>" + res?.error?.data?.message);
          setResponse(res?.error?.data?.message);
          // toast.error(res?.error?.data?.message, {
          //   position: "top-center",
          //   autoClose: 5000,
          // });
        }
      } catch (error) {
        const errorMessage =
          error.response?.data?.message || error.message || "An error occurred";
        console.error("Login error:", errorMessage);
        // toast.error(errorMessage, {
        //   position: "top-center",
        //   autoClose: 5000,
        // });
        setError(errorMessage);
      } finally {
        setSubmitting(false);
      }
    },
  });

  return (
    <div className="flex flex-col md:flex-row justify-between min-h-screen">
      <Modal isModalVisible={isModalVisible} closeModal={closeModal} />
 
      <div className="hidden md:block relative flex-grow-1">
        <div className="absolute inset-0 z-0">
          <Image
            src={leftbg}
            alt=""
            className="w-full object-cover h-full"
          />
        </div>
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="max-w-[250px] md:max-w-[300px] lg:max-w-[400px] xl:max-w-[500px]"
          />
        </div>
      </div>
      <div className="md:hidden  bg-[#0689BE] py-12 rounded-bl-[50px] rounded-br-[50px] ">
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="max-w-[250px]"
          />
        </div>
      </div>

      <div className="flex justify-center items-center my-auto md:min-h-screen w-full md:w-1/2 lg:w-[40%] bg-white py-8 py-md-10 px-8 md:px-6">
        <div className="bg-white w-full max-w-sm ">
          <div className="mb-10">
            <h1 className="text-3xl text-center font-bold">Welcome to Marvalist!</h1>
            {/* <p>Welcome Back</p> */}
          </div>

          <form className="flex flex-col gap-6" onSubmit={formik.handleSubmit}>
            <div>
              <div className="relative">
                <input
                  type="email"
                  id="email"
                  name="email"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${formik.touched.email && formik.errors.email
                    ? "border-red-500 border"
                    : ""
                    }`}
                  placeholder="Email Address"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.email}
                  disabled={loginUserIsLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faEnvelope}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.email && formik.errors.email ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.email}
                </div>
              ) : null}
            </div>

            <div>
              <div className="relative">
                <input
                  type={passShow ? "text" : "password"}
                  id="password"
                  name="password"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${formik.touched.password && formik.errors.password
                    ? "border-red-500 border"
                    : ""
                    }`}
                  placeholder="Password"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.password}
                  disabled={loginUserIsLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faLock}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
                <div
                  className="absolute z-10 inset-y-0 right-4 flex items-center "
                  onClick={handlePassShow}
                >
                  {passShow ? (
                    <FontAwesomeIcon
                      icon={faEye}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handlePassShow}
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faEyeSlash}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handlePassShow}
                    />
                  )}
                </div>
              </div>
              {formik.touched.password && formik.errors.password ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.password}
                </div>
              ) : null}
            </div>

            {error && (
            <div className="text-red-500 text-center text-sm mt-4">
              <p>{error}</p>
            </div>
              )}
            {response && (
              <div className="text-red-500 text-left text-sm">
                <p>{response}</p>
              </div>
            )}





            <div>
              
              <button
                type="submit"
                className="rounded-lg w-full py-3 bg-[#0689BE] text-white font-semibold"
                disabled={loginUserIsLoading}
              >
                {loginUserIsLoading || loginSuccessfully ? "Loading..." : "Login"}
              </button>
            </div>
          </form>

          <div className="mt-4 text-center">
            <Link
              href="/forgot-password"
              className="text-sm font-normal text-blue-500 hover:underline"
            >
              Forgot Password
            </Link>
          </div>

          <div className="mt-4 text-center">
            <p className="text-sm">
              Don’t have an account?
              <Link
                href="/sign-up"
                className="ml-2 text-sm font-normal text-blue-500 hover:underline"
              >
                Sign Up
              </Link>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Login;
