"use client";
import React, { useEffect, useState } from "react";
import bellLogo from "../../../../public/assets/profile/bell-logo.png";
import profilePic from "../../../../public/assets/profile/Avatar.png";
import Image from "next/image";
import Breadcrumbs from "../breadcrumbs/Breadcrumbs";
import {
  useGetUserProfileQuery,
  useUpdateUserProfileMutation,
} from "@/services/Api";
import toast from "react-hot-toast";
import PhoneInput from "react-phone-input-2";
import "react-phone-input-2/lib/style.css";
import AvatarDropdown from "../avatardropdown/avatardropdown";
import { setGlobalProfileImg } from "@/redux/authSlice";
import { useDispatch } from "react-redux";

const Profile = () => {
  const dispatch = useDispatch();
  const [firstName, setFirstName] = useState("");
  const [lastName, setLastName] = useState("");
  const [email, setEmail] = useState("");
  const [phone, setPhone] = useState("");
  const [password, setPassword] = useState("");
  const [preferences, setPreferences] = useState({
    check_in_reminder_notification: { sms: false, email: false, in_app: false },
    gate_change_notification: { sms: false, email: false, in_app: false },
    flight_delay_notification: { sms: false, email: false, in_app: false },
    baggage_claim_notification: { sms: false, email: false, in_app: false },
  });
  const [loader, setLoader] = useState(true);

  const { data: getUserProfile, refetch: getUserProfileRefetch } =
    useGetUserProfileQuery();

  const [updateUserProfile, { isLoading: updateUserProfileIsLoading }] =
    useUpdateUserProfileMutation();

  const handleCheckboxChange = (notificationType, method) => {
    setPreferences((prevPreferences) => ({
      ...prevPreferences,
      [notificationType]: {
        ...prevPreferences[notificationType],
        [method]: !prevPreferences[notificationType][method],
      },
    }));
  };

  const updateProfileApiHandler = () => {
    let formData = new FormData();

    formData.append("profile_image", image);
    formData.append("first_name", firstName);
    formData.append("last_name", lastName);
    formData.append("email", email);
    formData.append("phone", phone);
    if (password) {
      formData.append("password", password);
    }

    Object.keys(preferences).forEach((notificationType) => {
      Object.keys(preferences[notificationType]).forEach((channel) => {
        const value = preferences[notificationType][channel];
        formData.append(
          `notifications[${notificationType}][${channel}]`,
          value
        );
      });
    });

    if (image) {
      updateUserProfile({ data: formData })
        .unwrap()
        .then((e) => {
          dispatch(
            setGlobalProfileImg({
              profilePhoto: e.user.profile_photo_path,
              name: e.user.name,
              email: e.user.email,
            })
          );
          getUserProfileRefetch();
          toast.success("Profile updated successfully", {
            position: "top-center",
          });
        })
        .catch((error) => {});
    } else {
      toast.error("Profile image required", {
        position: "top-center",
      });
    }
  };

  const normalizePreferences = (data) => {
    if (data !== undefined) {
      const normalized = {};
      Object.keys(data).forEach((notificationType) => {
        normalized[notificationType] = {};
        Object.keys(data[notificationType]).forEach((channel) => {
          normalized[notificationType][channel] =
            data[notificationType][channel] == "true";
        });
      });
      return normalized;
    }
  };

  useEffect(() => {
    if (getUserProfile === undefined) {
      setLoader(true);
      console.log("loader");
    }
    if (getUserProfile) {
      setLoader(false);
      console.log("loader remove");
      let {
        first_name,
        last_name,
        email,
        phone,
        notifications,
        profile_photo_path,
      } = getUserProfile?.user;
      setFirstName(first_name);
      setLastName(last_name);
      setEmail(email);
      setPhone(phone);
      setImage(profile_photo_path);
      const normalizedData = normalizePreferences(notifications);

      if (notifications) {
        setPreferences(normalizedData);
      } else {
        setPreferences({
          check_in_reminder_notification: {
            sms: false,
            email: false,
            in_app: false,
          },
          gate_change_notification: { sms: false, email: false, in_app: false },
          flight_delay_notification: {
            sms: false,
            email: false,
            in_app: false,
          },
          baggage_claim_notification: {
            sms: false,
            email: false,
            in_app: false,
          },
        });
      }
    }
  }, [getUserProfile]);

  useEffect(() => {
    getUserProfileRefetch();
  }, []);

  const [image, setImage] = useState(null);
  const [imagePreview, setImagePreview] = useState(null);

  const handleImageUpload = (e) => {
    console.log("File Uploaded:", e.target.files[0]);
    const file = e.target.files[0];
    if (file) {
      console.log(file);
      setImage(file);
      setImagePreview(URL.createObjectURL(file));
    }

    console.log(file);
    console.log(URL.createObjectURL(file));
  };

  const handleRemoveImage = () => {
    setImage(null);
    setImagePreview(null);
  };

  return (
    <div className="lg:bg-[#F8F9FC] min-h-screen px-3 md:px-8 overflow-x-hidden">
      <div className="lg:h-[100px] flex justify-between items-center pt-5 lg:pt-0">
        <div className="text-[#0689BE] text-[20px] pl-4 md:pl-0">
          {/* <Breadcrumbs /> */}
        </div>
        <div className="hidden lg:flex items-center gap-4">
          <Image src={bellLogo} alt="bell-logo" className="h-6 w-6" />

          <AvatarDropdown />
        </div>
      </div>
      {loader ? (
        <div className="h-[354px] flex items-center justify-center p-4 rounded-2xl mt-4 border bg-white">
          <div class="flex justify-center items-center bg-white">
            <div class="border-t-4 border-[#0689BE] border-solid w-16 h-16 rounded-full animate-spin"></div>
          </div>
        </div>
      ) : (
        <div className="bg-[#FFFFFF] p-4 md:p-6 rounded-2xl border">
          {/* <h1 className="text-[#1F2336] font-bold text-[20px]">Profile</h1> */}
          <h2 className="mb-4 text-xl md:text-2xl font-bold">Profile</h2>
          {/* <div className="mb-10">
          
          <p className="text-[#484F61] text-[14px] font-medium">
            Set your profile image
          </p>
        </div> */}

          <div className="w-full flex flex-wrap">
            <div className="flex flex-col md:flex-row gap-5 justify-center grow">
              <div className="flex flex-col items-center rounded-lg gap-5">
                <label className="form-label pt-1">
                  Set your profile image
                </label>
                <img
                  src={
                    imagePreview !== null
                      ? imagePreview
                      : image === null
                      ? "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"
                      : `https://tracking.logoinnovators.com/backend/public/${image}`
                  }
                  className="h-[100px] w-[100px] object-cover rounded-full"
                />
                {imagePreview ? (
                  <button
                    onClick={handleRemoveImage}
                    className="text-[#0689BE] border border-[#0689BE] rounded-lg py-2 px-3 ml-3"
                  >
                    Remove
                  </button>
                ) : (
                  <label className="text-[#0689BE] cursor-pointer border py-2 px-4 text-[14px] font-semibold rounded-lg border-[#0689be]">
                    <input
                      type="file"
                      onChange={handleImageUpload}
                      className="hidden"
                    />
                    Upload Image
                  </label>
                )}
              </div>
              {/* <div className="md:w-1/2"></div> */}
            </div>

            <div className="grid grid-cols-1 sm:grid-cols-2 w-full justify-between gap-x-6 user-profile-form">
              <div className="mb-3">
                <label className="form-label">First Name</label>
                <input
                  type="text"
                  className="w-full form-control"
                  placeholder="Enter first name"
                  onChange={(e) => setFirstName(e.target.value)}
                  value={firstName}
                />
              </div>
              <div className="mb-3">
                <label className="form-label">Last Name</label>
                <input
                  type="text"
                  className="w-full form-control"
                  placeholder="Enter last name"
                  onChange={(e) => setLastName(e.target.value)}
                  value={lastName}
                />
              </div>
              {/* </div>

          <div className="flex flex-col md:flex-row w-full justify-between md:gap-8 gap-3 my-3"> */}
              <div className="mb-3">
                <label className="form-label">Email</label>
                <input
                  type="email"
                  className="w-full form-control"
                  placeholder="Enter email"
                  onChange={(e) => setEmail(e.target.value)}
                  value={email}
                />
              </div>

              <div className="mb-3">
                <label className="form-label">Phone</label>
                <PhoneInput
                  country={"us"}
                  value={phone || "+1"}
                  onChange={(value) => setPhone(value)}
                  countryCodeEditable={false}
                  inputClass="w-full admin-phone-field-signup"
                />
                {/* <input
                type="text"
                className="bg-[#F6F9FB] w-full px-2 py-2 text-[14px] font-normal outline-none rounded-lg"
                placeholder="0000000000"
                onChange={(e) => setPhone(e.target.value)}
                value={phone}
              /> */}
              </div>

              <div className="mb-3">
                <label className="form-label">Password</label>
                <input
                  type="password"
                  className="w-full form-control"
                  placeholder="Password"
                  onChange={(e) => setPassword(e.target.value)}
                  value={password}
                />
              </div>
            </div>
          </div>
          <div className="my-4">
            <h2 className="text-xl md:text-2xl font-semibold mb-6">
              Notifications Preferences
            </h2>
            <div className="overflow-x-auto rounded-2xl overflow-y-auto">
              <table className="text-[14px] min-w-[500px]">
                <thead>
                  <tr>
                    <th className="text-left font-semibold text-[#9A9EAD] py-3 px-5">
                      NOTIFICATION TYPE
                    </th>
                    <th className="text-center text-[#9A9EAD] p-3 bg-[#F6F9FB] md:w-24">
                      IN-APP
                    </th>
                    <th className="text-center text-[#9A9EAD] sm:p-3 px-2 bg-[#F6F9FB] md:w-24">
                      EMAIL
                    </th>
                    <th className="text-center ml-3 text-[#9A9EAD] p-3 bg-[#F6F9FB] md:w-24">
                      SMS
                    </th>
                  </tr>
                </thead>
                <tbody>
                  {Object.keys(preferences).map((notificationType) => (
                    <tr key={notificationType}>
                      <td className="py-2 capitalize font-semibold px-5">
                        {notificationType
                          .replace(/_/g, " ")
                          .replace(/\b\w/g, (l) => l.toUpperCase())}
                      </td>
                      <td className="p-2 text-center bg-[#F6F9FB]">
                        <input
                          type="checkbox"
                          checked={preferences[notificationType].in_app}
                          onChange={() =>
                            handleCheckboxChange(notificationType, "in_app")
                          }
                          className="form-checkbox h-5 w-5 accent-[#0689BE]"
                        />
                      </td>
                      <td className="p-2 text-center bg-[#F6F9FB]">
                        <input
                          type="checkbox"
                          checked={preferences[notificationType].email}
                          onChange={() =>
                            handleCheckboxChange(notificationType, "email")
                          }
                          className="form-checkbox h-5 w-5 accent-[#0689BE]"
                        />
                      </td>
                      <td className="p-2 text-center bg-[#F6F9FB]">
                        <input
                          type="checkbox"
                          checked={preferences[notificationType].sms}
                          onChange={() =>
                            handleCheckboxChange(notificationType, "sms")
                          }
                          className="form-checkbox h-5 w-5 accent-[#0689BE]"
                        />
                      </td>
                    </tr>
                  ))}
                </tbody>
              </table>
            </div>
          </div>

          <div className="my-6 flex justify-end">
            <button
              type="submit"
              className="px-8 py-3 text-[14px] text-white bg-[#0689BE] rounded-lg"
              disabled={updateUserProfileIsLoading}
              onClick={updateProfileApiHandler}
            >
              {updateUserProfileIsLoading ? "Loading..." : "Save Changes"}
            </button>
          </div>
        </div>
      )}
    </div>
  );
};

export default Profile;
