"use client";
import Image from "next/image";
import React, { useEffect, useState } from "react";
import leftbg from "../../../../public/assets/loginForm/left-bg.png";
import mLogo from "../../../../public/assets/loginForm/m-logo.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope, faLock } from "@fortawesome/free-solid-svg-icons";
import Link from "next/link";
import { faEye, faEyeSlash } from "@fortawesome/free-solid-svg-icons";
import { useRouter, useSearchParams } from "next/navigation";
import { useResetPasswordMutation } from "@/services/Api";
import loginSuccessIcon from "../../../../public/assets/loginForm/login-success.svg";
import { useFormik } from "formik";
import * as Yup from "yup";
import toast from "react-hot-toast";
const Modal = ({ isModalVisible, closeModal }) => {
  return (
    <div
      className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${
        isModalVisible
          ? "opacity-100 pointer-events-auto"
          : "opacity-0 pointer-events-none"
      } transition-opacity duration-500 z-50`}
    >
      <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
        <Image src={loginSuccessIcon} alt="" className=" max-w-[45px] " />
        <h2
          className="text-xl font-bold mt-3 text-center"
          style={{ color: "#0689BE" }}
        >
          Password reset successful!
        </h2>
      </div>
    </div>
  );
};

const ResetPassword = () => {
  const searchParams = useSearchParams();
  const searchUrlToken = searchParams.get("token");
  const searchUrlEmail = searchParams.get("email");
  const [passShow, setPassShow] = useState(false);
  const [confirmPassShow, setConfirmPassShow] = useState(false);
  const [isModalVisible, setIsModalVisible] = useState(false);
  const router = useRouter();

  const [resetPassword, { isLoading: resetPasswordIsLoading }] =
    useResetPasswordMutation();
  useEffect(() => {
    const timer = setTimeout(() => {
      setIsModalVisible(false);
    }, 1000); // 500ms delay

    return () => clearTimeout(timer); // Cleanup on component unmount
  }, []);

  const closeModal = () => {
    setIsModalVisible(false);
  };
  const formik = useFormik({
    initialValues: {
      password: "",
      password_confirmation: "",
    },

    validationSchema: Yup.object({
      // password: Yup.string()
      //   .min(4, "Password must be at least 6 characters long")
      //   .required("Password is required"),
      // password_confirmation: Yup.string()
      //   .min(4, "Password must be at least 6 characters long")
      //   .required("Password is required"),
      password: Yup.string()
        .required("Password is required")
        .min(8, "Password is too short - should be 8 chars minimum.")
        .matches(/[a-zA-Z]/, "Password can only contain Latin letters.")
        .matches(
          /[!@#$%^&*(),.?":{}|<>]/,
          "Password must contain at least one special character."
        ),
      password_confirmation: Yup.string()
        .oneOf([Yup.ref("password"), null], "Passwords must match")
        .required("Confirm Password is required"),
    }),

    onSubmit: async (values, { setSubmitting }) => {
      values.email = searchUrlEmail;
      values.token = searchUrlToken;

      try {
        const res = await resetPassword({ data: values });

        if (res) {
          setIsModalVisible(true);
          setTimeout(() => {
            setIsModalVisible(false);
            router.push("/login"); // Redirect after 500ms
          }, 1500);
          // toast.success("Password reset successful!");
        }
      } catch (error) {
        const errorMessage =
          error.response?.data?.message || error.message || "An error occurred";
        console.error("Login error:", errorMessage);
        toast.error(errorMessage, {
          position: "top-center",
          autoClose: 5000,
        });
      } finally {
        setSubmitting(false);
      }
    },
  });

  return (
    <div className="flex flex-col gap-8 md:gap-0 md:flex-row justify-between max-h-screen md:min-h-screen">
      <Modal isModalVisible={isModalVisible} closeModal={closeModal} />
      <div className="max-h-screen hidden md:block  w-1/2 lg:w-[60%] relative">
        <div className="absolute inset-0 z-0">
          <Image
            src={leftbg}
            alt=""
            className=" min-h-screen max-h-screen w-full object-cover"
          />
        </div>
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="lgh-[183px]  h-[150px] max-w-[300px]  lg:max-w-[590px]"
          />
        </div>
      </div>
      <div className="md:hidden  bg-[#0689BE] h-[322px] rounded-bl-[50px] rounded-br-[50px] ">
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="lgh-[183px]  h-[100px] max-w-[300px]  lg:max-w-[590px]"
          />
        </div>
      </div>

      <div className="flex justify-center items-center my-auto md:min-h-screen w-full md:w-1/2 lg:w-[40%] bg-white px-8 md:px-0">
        <div className="bg-white w-full max-w-sm">
          <div className="  mb-10">
            <h1 className="text-3xl font-bold  mb-2">Reset Password</h1>
            <p className="">
              Add a new password to continue. After clicking “Save Password”.
              You will be redirected to the login page.
            </p>
          </div>

          <form className="flex flex-col gap-6" onSubmit={formik.handleSubmit}>
            <div>
              <div className="relative">
                <input
                  type={!passShow ? "password" : "text"}
                  id="password"
                  className={`w-full px-4 pl-10 py-3 outline-none shadow-custom rounded-3xl focus:outline-none ${
                    formik.touched.password && formik.errors.password
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Password"
                  name="password"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.password}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faLock}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
                <div
                  className="absolute z-10 inset-y-0 right-4 flex items-center "
                  // onClick={handlePassShow}
                >
                  {!passShow ? (
                    <FontAwesomeIcon
                      icon={faEyeSlash}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={()=> setPassShow(!passShow)}
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faEye}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={()=> setPassShow(!passShow)}
                    />
                  )}
                </div>
              </div>
              {formik.touched.password && formik.errors.password ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.password}
                </div>
              ) : null}
            </div>

            {/* Confirm Password Field */}
            <div>
              <div className="relative">
                <input
                  type={!confirmPassShow ? "password" : "text"}
                  id="password_confirmation"
                  className={`w-full px-4 pl-10 py-3 outline-none shadow-custom rounded-3xl focus:outline-none ${
                    formik.touched.password_confirmation &&
                    formik.errors.password_confirmation
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Confirm Password"
                  name="password_confirmation"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.password_confirmation}
                />
                <div className="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faLock}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
                <div
                  className="absolute z-10 inset-y-0 right-4 flex items-center "
                  // onClick={handlePassShow}
                >
                  {!confirmPassShow ? (
                    <FontAwesomeIcon
                      icon={faEyeSlash}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={()=> setConfirmPassShow(!confirmPassShow)}
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faEye}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={()=> setConfirmPassShow(!confirmPassShow)}
                    />
                  )}
                </div>
              </div>
              {formik.touched.password_confirmation &&
              formik.errors.password_confirmation ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.password_confirmation}
                </div>
              ) : null}
            </div>

            <div>
              <button
                type="submit"
                className="rounded-3xl w-full py-3 bg-[#0689BE] text-white font-semibold"
                disabled={resetPasswordIsLoading}
              >
                {resetPasswordIsLoading ? "Loading..." : "Reset Password"}
              </button>
            </div>
          </form>

          <div className="mt-4 text-center">
            <p className="text-sm ">
              Already have an account?
              <Link
                href="/login"
                className="ml-2 text-sm font-normal text-blue-500 hover:underline"
              >
                login
              </Link>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ResetPassword;
