"use client";
import Image from "next/image";
import React, { useState, useEffect } from "react";
import leftbg from "../../../../public/assets/loginForm/left-bg.png";
import mLogo from "../../../../public/assets/loginForm/m-logo.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import loginSuccessIcon from "../../../../public/assets/loginForm/login-success.svg";
import {
  faEnvelope,
  faLock,
  faUser,
  faEyeSlash,
  faEye,
  faIdCard,
} from "@fortawesome/free-solid-svg-icons";
import InputMask from "react-input-mask";
import Link from "next/link";
import { useFormik } from "formik";
import * as Yup from "yup";
import toast from "react-hot-toast";
import { PostLoginAndSignup } from "@/app/axios/axiosRequests";
import { useRouter } from "next/navigation";
import PhoneInput from "react-phone-input-2";
import "react-phone-input-2/lib/style.css";
import validator from "validator";
import { parsePhoneNumberFromString, PhoneNumber } from "libphonenumber-js";
import { useSendOtpQuery } from "@/services/Api";
import { GetRequest, PostRequest } from "@/app/axios/axiosRequests";

const Modal = ({ isModalVisible, closeModal }) => {
  return (
    <div
      className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${
        isModalVisible
          ? "opacity-100 pointer-events-auto"
          : "opacity-0 pointer-events-none"
      } transition-opacity duration-500 z-50`}
    >
      <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
        <Image src={loginSuccessIcon} alt="" className=" max-w-[45px] " />
        <h2
          className="text-xl font-bold mt-3 text-center"
          style={{ color: "#0689BE" }}
        >
          Registration successful. Verification link sent to your email.
        </h2>
      </div>
    </div>
  );
};
const SignUp = () => {
  const [isModalVisible, setIsModalVisible] = useState(false);
  const [isLoading, loginUserIsLoading] = useState(false);
  const router = useRouter();
  const [error, setError] = useState("");
  const [phone, setPhone] = useState("");
  const [passShow, setPassShow] = useState(false);
  const [confirmPassShow, setConfirmPassShow] = useState(false);
  const [isSidebarOpen, setIsSidebarOpen] = useState(false);
  const [isPhoneValid, setIsPhoneValid] = useState(false);
  const [country, setCountry] = useState("us");
  const [showOTPInput, setShowOTPInput] = useState(false);
  const [otp, setOtp] = useState(["", "", "", "", "", ""]);
  const [otpResponse, setOtpResponse] = useState(null);
  const [errorMessage, setErrorMessage] = useState("");
  const [errorMessageOtp, setErrorMessageOtp] = useState("");
  const [signUpBtnDisable, setSignUpBtnDisable] = useState(true);
  const [isChecked, setIsChecked] = useState(false);
  useEffect(() => {
    const timer = setTimeout(() => {
      setIsModalVisible(false);
    }, 2000);

    return () => clearTimeout(timer);
  }, []);

  useEffect(() => {
    if (isChecked && isPhoneValid) {
      setSignUpBtnDisable(false);
    } else {
      setSignUpBtnDisable(true);
    }
  }, [isChecked, showOTPInput]);
  const handleOtpChange = (e, index) => {
    let newOtp = [...otp];
    newOtp[index] = e.target.value;

    if (e.target.value.length === 1 && index < 5) {
      document.getElementById(`otp-input-${index + 1}`).focus();
    }

    setOtp(newOtp);

    if (newOtp.join("").length === 6) {
      handleVerifyOtp(newOtp.join(""));
    }
  };

  const handleKeyDown = (e, index) => {
    if (e.key === "Backspace" && otp[index] === "") {
      if (index > 0) {
        document.getElementById(`otp-input-${index - 1}`).focus();
      }
    }
  };

  const handleVerifyOtp = async (otp) => {
    try {
      const url = "/verify-otp";

      const response = await PostRequest(url, {
        otp: otp,
      });

      if (response?.success) {
        console.log("OTP Verified successfully");
        errorMessageOtp("");
      } else {
        console.error("OTP verification failed");
      }
    } catch (error) {
      console.log("Error verifying OTP:", error.response.data.message);
      setErrorMessageOtp(error.response.data.message);
    }
  };

  const handlePhoneChange = (value) => {
    setPhone(value);
    const cleanedPhone = value.replace(/\D/g, "");
    let isValid = false;
    if (country === "US" || country === "CA") {
      isValid = cleanedPhone.length === 11;
    } else {
      isValid = cleanedPhone.length >= 11;
    }
    setIsPhoneValid(isValid);
  };

  const formik = useFormik({
    initialValues: {
      first_name: "",
      last_name: "",
      name: "",
      email: "",
      ssn: "",
      phone: "",
      password: "",
      password_confirmation: "",
    },
    validationSchema: Yup.object({
      first_name: Yup.string()
        .min(2, "Too Short!")
        .max(50, "Too Long!")
        .required("First Name is Required"),
      last_name: Yup.string()
        .min(2, "Too Short!")
        .max(50, "Too Long!")
        .required("Last Name is Required"),
      // name: Yup.string()
      //   .min(2, "Too Short!")
      //   .max(50, "Too Long!")
      //   .required("Name is Required"),
      email: Yup.string()
        .email("Invalid email address")
        .required("Email is required"),
      ssn: Yup.string()
        .nullable()
        .matches(
          /^\d{3}-\d{2}-\d{4}$/,
          "SSN must be in the format 123-45-6789"
        ),
      password: Yup.string()
        .required("Password is required")
        .min(8, "Password is too short - should be 8 chars minimum.")
        .matches(/[a-zA-Z]/, "Password can only contain Latin letters.")
        .matches(
          /[!@#$%^&*(),.?":{}|<>]/,
          "Password must contain at least one special character."
        ),
      password_confirmation: Yup.string()
        .oneOf([Yup.ref("password"), null], "Passwords must match")
        .required("Confirm Password is required"),
      phone: Yup.string()
        .required("Phone number is required")
        .matches(/^\d{10,}$/, "The phone number is not correct"),
    }),
    onSubmit: async (values, { setSubmitting }) => {
      try {
        loginUserIsLoading(true);
        // let payloadDataUpdate = values.first_name + values.last_name;
        let payloadDataUpdate = {
          ...values,
          name: values.first_name + " " + values.last_name,
          consent: 1,
        };
        console.log(payloadDataUpdate);
        const res = await PostLoginAndSignup("register", payloadDataUpdate);
        setIsModalVisible(true);
        setTimeout(() => {
          setIsModalVisible(false);
        }, 2000);
        loginUserIsLoading(false);
        // alert(1);
        // toast.success("signup successful!");
        setTimeout(() => {
          setIsModalVisible(false);
          router.push("/login");
        }, 1500);
      } catch (error) {
        loginUserIsLoading(false);
        console.error(
          "signUp error:",
          error.response?.data?.errors || error.message
        );
        setError(error.response?.data?.errors || "An error occurred");
      } finally {
        loginUserIsLoading(false);

        setSubmitting(false);
      }
    },
  });
  const handlePassShow = () => {
    setPassShow(!passShow);
  };
  const closeModal = () => {
    setIsModalVisible(false);
  };
  const handleConfirmPassShow = () => {
    setConfirmPassShow(!confirmPassShow);
  };
  const handleCheckboxChange = (e) => {
    setIsChecked(e.target.checked);
  };

  // const { data, refetch } = useSendOtpQuery(
  //   { phoneNumber: phone },
  //   { skip: true } // Prevent the query from running automatically
  // );
  const showOtpField = async () => {
    setShowOTPInput(true);
    try {
      // Define the URL for OTP verification
      const url = "/send-otp";

      // Send the request to verify OTP with the phone number
      const response = await PostRequest(url, {
        phone: "+923254020190", // Send phone number for verification
      });

      // Log the actual response object to check it
      console.log("Response:", response);

      // Optionally trigger the OTP request with refetch (if needed)
      // const otpResponse = await refetch();

      // Handle the OTP response, if needed
      if (response?.data?.otp) {
        setOtpResponse(response.data.otp);
        setShowOTPInput(true); // Show OTP input field
        setErrorMessage(""); // Clear previous error messages
      } else {
        setErrorMessage("Failed to send OTP. Please try again.");
      }
    } catch (error) {
      // Handle any errors
      console.error("Error sending OTP:", error);
      setErrorMessage("Failed to send OTP. Please try again.");
    }
  };

  return (
    // <div className="flex flex-col gap-8 md:gap-0 md:flex-row justify-between max-h-screen md:min-h-screen">
    <div className="flex flex-col md:flex-row justify-between  min-h-screen">
      <Modal isModalVisible={isModalVisible} closeModal={closeModal} />
      {/* <div className="max-h-screen hidden md:block  w-1/2 lg:w-[60%] relative"> */}
      <div className="hidden md:block relative flex-grow-1">
        <div className="absolute inset-0 z-0">
          <Image src={leftbg} alt="" className="w-full object-cover h-full" />
        </div>
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image
            src={mLogo}
            alt=""
            className="max-w-[250px] md:max-w-[300px] lg:max-w-[400px] xl:max-w-[500px]"
          />
        </div>
      </div>
      <div className="md:hidden  bg-[#0689BE] py-12 rounded-bl-[50px] rounded-br-[50px] ">
        <div className="flex justify-center items-center z-10 h-full w-full relative">
          <Image src={mLogo} alt="" className="max-w-[250px]" />
        </div>
      </div>
      <div className="flex justify-center items-center my-auto md:min-h-screen w-full md:w-1/2 lg:w-[40%] bg-white py-8 py-md-10 px-8 md:px-6">
        <div className="bg-white w-full max-w-sm">
          <div className=" text-center mb-10">
            <h1 className="text-3xl font-bold mb-2">Get Started with Us</h1>
            <p className="">Create Your Account</p>
          </div>

          <form className="flex flex-col gap-6" onSubmit={formik.handleSubmit}>
            <div>
              <div className="relative">
                <input
                  type="text"
                  id="first_name"
                  name="first_name"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.first_name && formik.errors.first_name
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="First Name"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.first_name}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faUser}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.first_name && formik.errors.first_name ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.first_name}
                </div>
              ) : null}
            </div>
            <div>
              <div className="relative">
                <input
                  type="text"
                  id="last_name"
                  name="last_name"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.last_name && formik.errors.last_name
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Last Name"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.last_name}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faUser}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.last_name && formik.errors.last_name ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.last_name}
                </div>
              ) : null}
            </div>
            {/* <div>
              <div className="relative">
                <input
                  type="text"
                  id="name"
                  name="name"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${formik.touched.name && formik.errors.name
                    ? "border-red-500 border"
                    : ""
                    }`}
                  placeholder="Full Name"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.name}
                  disabled={isLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faUser}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.name && formik.errors.name ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.name}
                </div>
              ) : null}
            </div> */}

            <div>
              <div className="relative">
                <input
                  type="email"
                  id="email"
                  name="email"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.email && formik.errors.email
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Email Address"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.email}
                  disabled={isLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faEnvelope}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.email && formik.errors.email ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.email}
                </div>
              ) : null}
            </div>

            <div>
              <div className="relative phone-field-signup-main">
                {/* <input
                  type="email"
                  id="email"
                  name="email"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.email && formik.errors.email
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Email Address"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.email}
                /> */}
                <div className="relative">
                  <PhoneInput
                    country={"us"}
                    value={phone}
                    countryCodeEditable={false}
                    onChange={(value) => {
                      setPhone(value);
                      formik.setFieldValue("phone", value);
                      formik.setFieldTouched("phone", true); // Mark the phone field as touched
                      handlePhoneChange(value);
                    }}
                    disabled={isLoading ? true : false}
                    inputClass="w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none h-10 phone-field-signup"
                  />

                  {formik.touched.phone && formik.errors.phone ? (
                    <div className="text-red-500 text-sm mt-1">
                      {formik.errors.phone}
                    </div>
                  ) : null}

                  {/* <div className="flex justify-end">
                    <a
                      className={`verify-button ${isPhoneValid ? 'bg-[#0688be] opacity-100 cursor-pointer' : 'bg-[#0688be] opacity-50 cursor-not-allowed'} text-white text-xs rounded-lg p-1 inline-block`}
                      disabled={!isPhoneValid}
                      onClick={showOtpField}
                      style={{
                        position: 'absolute',
                        top: '12px',
                        right: '10px',
                        padding: '5px 8px',
                        borderRadius: '30px',
                        fontSize: '10px',
                      }}
                    >
                      Verify Mobile Number
                    </a>
                  </div> */}
                </div>
                {false && (
                  <div>
                    <div className="mt-4 flex space-x-2 justify-between">
                      {otp.map((digit, index) => (
                        <input
                          key={index}
                          id={`otp-input-${index}`}
                          type="text"
                          value={digit}
                          onChange={(e) => handleOtpChange(e, index)}
                          onKeyDown={(e) => handleKeyDown(e, index)}
                          maxLength="1"
                          className="w-12 h-12 text-center border rounded-lg otp-sign-up"
                          inputMode="numeric"
                          disabled={isLoading ? true : false}
                        />
                      ))}
                    </div>
                    {errorMessageOtp && (
                      <p className="text-red-500 text-sm mt-2">
                        {errorMessageOtp}
                      </p>
                    )}
                  </div>
                )}
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  {/* <FontAwesomeIcon
                    icon={faEnvelope}
                    className="w-5 h-5 text-gray-400"
                  /> */}
                </div>
              </div>
            </div>
            <div>
              <div className="relative">
                <InputMask
                  mask="999-99-9999" // Specify the SSN mask format
                  id="ssn"
                  name="ssn"
                  value={formik.values.ssn}
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  disabled={isLoading ? true : false}
                >
                  {(inputProps) => (
                    <input
                      {...inputProps}
                      type="text"
                      className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                        formik.touched.ssn && formik.errors.ssn
                          ? "border-red-500 border"
                          : ""
                      }`}
                      placeholder="SSN"
                    />
                  )}
                </InputMask>
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faIdCard}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.ssn && formik.errors.ssn ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.ssn}
                </div>
              ) : null}
            </div>
            {/* <div>
              <div className="relative">
                <input
                  type="number"
                  id="ssn"
                  name="ssn"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.ssn && formik.errors.ssn
                      ? "border-red-500 border"
                      : ""
                  }`}
                  mask="999-99-9999"
                  placeholder="SSN"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.ssn}
                  disabled={isLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-3 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faIdCard}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
              </div>
              {formik.touched.ssn && formik.errors.ssn ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.ssn}
                </div>
              ) : null}
            </div> */}

            <div className="">
              <div className="relative">
                <input
                  type={passShow ? "text" : "password"}
                  id="password"
                  name="password"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.password && formik.errors.password
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Password"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.password}
                  disabled={isLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faLock}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
                <div
                  className="absolute z-10 inset-y-0 right-4 flex items-center "
                  onClick={handlePassShow}
                >
                  {passShow ? (
                    <FontAwesomeIcon
                      icon={faEyeSlash}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handlePassShow}
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faEye}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handlePassShow}
                    />
                  )}
                </div>
              </div>
              {formik.touched.password && formik.errors.password ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.password}
                </div>
              ) : null}
            </div>
            <div className="">
              <div className="relative">
                <input
                  type={confirmPassShow ? "text" : "password"}
                  id="password"
                  name="password_confirmation"
                  className={`w-full px-4 pl-10 py-3 outline-none border-[#ACACAC] border rounded-lg focus:outline-none ${
                    formik.touched.password_confirmation &&
                    formik.errors.password_confirmation
                      ? "border-red-500 border"
                      : ""
                  }`}
                  placeholder="Confirm Password"
                  onChange={formik.handleChange}
                  onBlur={formik.handleBlur}
                  value={formik.values.password_confirmation}
                  disabled={isLoading ? true : false}
                />
                <div className="absolute inset-y-0 left-4 flex items-center pointer-events-none">
                  <FontAwesomeIcon
                    icon={faLock}
                    className="w-5 h-5 text-gray-400"
                  />
                </div>
                <div
                  className="absolute z-10 inset-y-0 right-4 flex items-center "
                  onClick={handleConfirmPassShow}
                >
                  {confirmPassShow ? (
                    <FontAwesomeIcon
                      icon={faEyeSlash}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handleConfirmPassShow}
                    />
                  ) : (
                    <FontAwesomeIcon
                      icon={faEye}
                      className="w-5 h-5 text-gray-400 cursor-pointer"
                      onClick={handleConfirmPassShow}
                    />
                  )}
                </div>
              </div>
              {formik.touched.password_confirmation &&
              formik.errors.password_confirmation ? (
                <div className="text-red-500 text-sm mt-1">
                  {formik.errors.password_confirmation}
                </div>
              ) : null}
            </div>
            <div class="flex items-start">
              <input
                type="checkbox"
                checked={isChecked}
                disabled={isLoading ? true : false}
                onChange={handleCheckboxChange}
                id="checkbox"
                class="mr-2 h-3 w-3 text-blue-600 border-gray-300 rounded focus:ring-blue-500 relative"
                style={{ top: "4px" }}
              />

              <label for="checkbox" class="text-sm text-gray-700">
                By pressing "Sign Up", you are confirming that you have read and
                agree to Marvalist's Terms of Use and Privacy Policy and also
                agree to receive reminders and notifications via text messages
                and emails.
              </label>
            </div>
            {error && typeof error === "object" ? (
              <div className="text-red-500 text-left text-sm">
                {Object.values(error)
                  .flat()
                  .map((errMsg, index) => (
                    <div key={index}>{errMsg}</div>
                  ))}
              </div>
            ) : (
              <div className="text-red-500 text-left text-sm mt-2">{error}</div>
            )}

            <div>
              <button
                type="submit"
                className={`rounded-3xl w-full py-3 bg-[#0689BE] text-white font-semibold focus:outline-none focus:ring-2 ${
                  signUpBtnDisable ? "opacity-50 cursor-not-allowed" : ""
                }`}
                disabled={isLoading || signUpBtnDisable}
              >
                {isLoading ? "Loading..." : "Sign Up"}
              </button>
            </div>
          </form>

          <div className="mt-4 text-center">
            <p className="text-sm ">
              Already have an account?
              <Link
                href="/login"
                className="ml-2 text-sm font-normal text-blue-500 hover:underline"
              >
                Login
              </Link>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SignUp;
