import Image from "next/image";
import React from "react";
import footerlogo from "../../../../../public/assets/userLayouts/appLogo.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faFacebook,
  faXTwitter,
  faInstagram,
} from "@fortawesome/free-brands-svg-icons";
import Link from "next/link";
const LayoutFooter = () => {
  return (
    <div className="">
      <div className="max-w-7xl md:px-5 mx-auto py-12 md:py-15 lg:py-20 bg-white">
        <div className="flex flex-col md:flex-row md:justify-between md:gap-28 gap-5 px-3 md:px-0">
          <div className="md:w-[25%]">
            <div className="w-[200px] md:w-[270px] flex flex-col gap-6">
              <Image src={footerlogo} alt="" className=" object-contain" />
              <div className="text-[16px] md:text-[18px] font-normal text-[#19182580]">
                All-In-One Tracking, All-In-One Peace of Mind.
              </div>
              <div className=" flex gap-3">
                <Link href="#" className="">
                  <FontAwesomeIcon
                    icon={faFacebook}
                    className="h-6 w-6 text-[#0689BE]"
                  />
                </Link>
                <Link href="#" className="">
                  <FontAwesomeIcon
                    icon={faInstagram}
                    className="h-6 w-6 text-[#0689BE]"
                  />
                </Link>
                <Link href="#" className="">
                  <FontAwesomeIcon
                    icon={faXTwitter}
                    className="h-6 w-6 text-[#0689BE]"
                  />
                </Link>
              </div>
            </div>
          </div>
          <div className="flex flex-wrap sm:flex-row md:items-start md:gap-8 justify-between md:w-[75%] pt-6">
            <div className="flex flex-col gap-3 md:gap-4 min-w-[150px] mb-3">
              <span href="#" className="text-[18px] md:text-[23px] font-bold text-[#191825]">
                Company
              </span>
              <Link
                href="/"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                Home
              </Link>
              <Link
                href="/about-us"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                About
              </Link>
              <Link
                href="/discover"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                Discover
              </Link>
            </div>
            <div className="flex flex-col gap-3 md:gap-4 min-w-[150px] mb-3">
              <span className="text-[18px] md:text-[23px] font-bold text-[#191825]">
                Contact
              </span>
              <Link
                href="/contact-us"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                Contact
              </Link>
            </div>
            <div className="flex flex-col gap-3 md:gap-4 min-w-[150px] mb-3">
              <span className="text-[18px] md:text-[23px] font-bold text-[#191825]">
                Meet Us
              </span>
              <Link
                href="tel:+1 234 567 8900"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                +1 234 567 8900
              </Link>
              <Link
                href="mailto:info@marvalist.com"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                info@marvalist.com
              </Link>
              <Link
                href="#"
                className="text-[#191825BF] text-[16px] md:text-[18px] font-normal"
              >
                205. R Street, New York 11001
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default LayoutFooter;
