import Link from "next/link";
import React from "react";
import card1 from "../../../../../public/assets/userLayouts/card1.png";
import card2 from "../../../../../public/assets/userLayouts/card2.png";
import card3 from "../../../../../public/assets/userLayouts/card3.png";
import background from "../../../../../public/assets/userLayouts/backgroundImage.png";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope, faArrowRight } from "@fortawesome/free-solid-svg-icons";
const Blog = () => {
  const cardsData = [
    {
      image: card1,
      date: "June 20, 2022",
      comments: "1",
      author: "admin",
      title: "Designers are meant to be loved, not to be understood.",
      link: "#",
    },
    {
      image: card2,
      date: "June 20, 2022",
      comments: "2",
      author: "user1",
      title: "The future of fashion is now.",
      link: "#",
    },
    {
      image: card3,
      date: "June 20, 2022",
      comments: "3",
      author: "user2",
      title: "The impact of technology on fashion.",
      link: "#",
    },
  ];

  return (
    <div className="pt-10">
      <div className="max-w-7xl mx-auto px-5 pb-10">
        <div className="text-center mb-10">
          <p className="text-primary font-bold text-2xl uppercase mb-3">
            Our Blogs
          </p>
          <p className="text-secondary font-bold text-4xl">
            Our Latest Posts
          </p>
        </div>
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 ">
          {cardsData.map((card, index) => (
            <div
              key={index}
              className="bg-white rounded-lg shadow-lg overflow-hidden"
            >
              <div className="relative">
                <Image
                  className="w-full h-48 object-cover"
                  src={card.image}
                  alt="Blog Image"
                />
                <div className="absolute bottom-0 right-0 bg-blue-500 text-white text-xs px-2 py-3 ">
                  {card.date}
                </div>
              </div>
              <div className="p-6">
                <p className="text-gray-500 text-xs mb-2 flex gap-6">
                  {card.comments} Comments<span>• by {card.author}</span>
                </p>
                <div className="font-bold text-xl mb-2">{card.title}</div>
                <Link
                  href={card.link}
                  className="text-[#9F9F9F] hover:underline flex gap-2 items-center"
                >
                  Read More
                  <FontAwesomeIcon icon={faArrowRight} />
                </Link>
              </div>
            </div>
          ))}
        </div>
      </div>
      <div className="  md:h-[641px] bg-secondary  pb-16 mt-10">
        <div className="relative mx-auto  max-w-7xl md:h-[641px]">
          <Image
            className=" absolute z-0  top-0 bottom-0 left-0  object-cover md:h-[641px]"
            src={background}
            alt="Background-Image"
          />
          <div className="md:h-[641px] flex flex-col gap-10 justify-center  px-8 relative z-1">
            <div className="text-center flex flex-col items-center">
              <p className="text-primary text-2xl  py-7 font-normal ">
                Subscribe to our Newsletter
              </p>
              <p className="text-white md:text-5xl text-3xl pb-7  max-w-[900px]">
                Prepare yourself & let’s explore the beauty of the world
              </p>
            </div>
            <div className=" flex md:flex-row flex-col md:gap-4 gap-4 justify-center">
              <div className="relative w-full lg:w-[60%]">
                <input
                  type="text"
                  placeholder="Your Email"
                  className="bg-white px-10 py-3 rounded-3xl w-full outline-none h-[50px]"
                />
                <FontAwesomeIcon
                  icon={faEnvelope}
                  className=" absolute left-3 md:top-4 top-[16px] h-[19px] w-[19px]"
                />
              </div>
              <button className="bg-primary rounded-3xl py-2 px-5 font-semibold text-[14px] text-white md:min-w-[170px] h-[50px]">
                Subscribe
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Blog;
