"use client";
import Image from "next/image";
import React from "react";
import bookingImage1 from "../../../../../public/assets/userLayouts/booking-image1.png";
import bookingImage2 from "../../../../../public/assets/userLayouts/booking-image2.png";
import bookingImage3 from "../../../../../public/assets/userLayouts/booking-image3.png";
import Link from "next/link"
import arrow1 from "../../../../../public/assets/userLayouts/arrow1.png";
import arrow2 from "../../../../../public/assets/userLayouts/arrow2.png";
import { useSelector } from "react-redux"; 

const BookingCard = () => {
  const userDetail = useSelector((state) => state.auth.userDetail);
  return (
    <div className="max-w-7xl px-5 mx-auto">
      <div className="py-10 flex flex-col-reverse md:flex-row md:gap-4 gap-10 items-center  justify-between px-4 md:px-0">
        <div className="">
          <Image
            src={bookingImage1}
            alt=""
            className="w-[344px] h-[164px] sm:w-[370px] sm:h-[170px]  md:w-[950px] md:h-[250px] lg:w-[600px] lg:h-[370px] object-contain"
          />
        </div>
        <div className="md:max-w-[450px]">
          <div className=" ">
            <p className="uppercase md:text-2xl text-lg font-bold text-primary mb-3 lg:mb-5">
              booking
            </p>
          </div>
          <p className="lg:text-5xl text-4xl font-bold">Your Booking, Our</p>
          <p className="lg:text-5xl text-4xl  font-bold text-primary mb-5">
            Expertise
          </p>
          <p className="text-[#838189] text-lg ">
            Distinct from other travel apps, Marvalist streamlines your travel
            arrangements regardless of where you make your reservations. Just
            forward your confirmation emails to us and within seconds, Marvalist
            will generate a detailed itinerary for each journey.
          </p>
          <div className="pt-10 ">
            <Link href="/discover"  passHref>
            <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold">
              Learn How it Works
            </button>
            </Link>
          </div>
        </div>
      </div>
      <div className="hidden md:block  px-28 xl:px-0">
        <Image
          src={arrow1}
          alt="arrow1"
          className="xl:max-w-[853px] lg:max-w-[700px] mx-auto"
        />
      </div>
      <div className="mb-10 flex flex-col md:flex-row md:gap-4 gap-10 items-center justify-between px-4 md:px-0">
        <div className="md:max-w-[400px] lg:max-w-[450px] max-w-full">
          <div className=" ">
            <p className="uppercase md:text-2xl text-lg font-bold text-primary mb-3 lg:mb-5">
              reminders
            </p>
          </div>
          <p className=" lg:text-5xl text-4xl leading-10  font-bold mb-4">
            Stay Informed with Timely
            <label className=" ml-2 text-primary lg:text-5xl text-4xl leading-10  font-bold">
              Reminders and Alerts
            </label>
          </p>

          <p className="text-[#838189] text-lg ">
            Loaded with game-changing features that keep you ahead of the curve
            and help you get the most out of every adventure, Marvalist Pro is
            where the magic comes to life.
          </p>
          <div className="pt-10 ">
            <Link href="/discover">
            <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold">
              Learn More
            </button>
            </Link>
          </div>
        </div>
        <div className="">
          <Image
            src={bookingImage2}
            alt=""
            className="w-[344px] h-[164px] sm:w-[370px] sm:h-[170px]  md:w-[700px] md:h-[250px] lg:w-[600px] lg:h-[370px]  object-contain"
          />
        </div>
      </div>
      <div className="hidden md:block  px-28 xl:px-0">
        <Image
          src={arrow2}
          alt="arrow1"
          className="xl:max-w-[853px] lg:max-w-[700px] mx-auto"
        />
      </div>
      <div className="mb-10 flex flex-col-reverse md:flex-row md:gap-4 gap-10 items-center  justify-between px-4 md:px-0">
        <div className="">
          <Image
            src={bookingImage3}
            alt=""
            className="w-[344px] h-[164px] sm:w-[370px] sm:h-[170px]  md:w-[700px] md:h-[250px] lg:w-[650px] lg:h-[370px]  object-contain"
          />
        </div>
        <div className="md:max-w-[400px] lg:max-w-[450px]">
          <div className=" ">
            <p className="uppercase md:text-2xl text-lg font-bold text-primary mb-3 lg:mb-5">
              location
            </p>
          </div>
          <p className="mb-4 md:text-3xl lg:text-4xl xl:text-5xl text-2xl font-bold">
            Navigate Your
            <span className="mx-3 md:text-3xl lg:text-4xl xl:text-5xl text-2xl font-bold text-primary mb-5">
              Travels with Precision
            </span>
            and Ease
          </p>

          <p className="text-[#838189] text-lg ">
            In need of a nudge when the clock ticks closer to your airport
            departure? Unsure about the best dining spots, whether within the
            terminal or near your lodging? Fear not, for Marvalist has all your
            travel queries sorted!
          </p>
          <div className="pt-10 ">
          <Link  href={userDetail?.role === 'user' ? '/flights' : '/sign-up'}>
            <button className="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold">
              Start Now
            </button>
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
};

export default BookingCard;
