"use client";
import Image from "next/image";
import Link from "next/link";
import React, { useState, useEffect } from "react";
import { useSelector } from "react-redux";
import appLogo from "../../../.././../public/assets/userLayouts/appLogo.png";
import dashboardIcon from "../../../.././../public/assets/sidebar/dashboard.svg";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faBars, faXmark } from "@fortawesome/free-solid-svg-icons";
import logoutLogo from "../../../.././../public/assets/sidebar/logout.svg";
import { useDispatch } from "react-redux";
import { userLogout } from "@/redux/authSlice";
import Cookies from "js-cookie";
import { useRouter } from 'next/navigation' 
import loginSuccessIcon from "../../../../../public/assets/loginForm/login-success.svg";
const Modal = ({ isModalVisible, closeModal }) => {
  return (
    <div
      className={`fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center ${isModalVisible ? 'opacity-100 pointer-events-auto' : 'opacity-0 pointer-events-none'} transition-opacity duration-500 z-50`}
    >
      <div className="bg-white rounded-lg shadow-lg p-6 w-[350px] text-center flex flex-col items-center relative">
        <Image
          src={loginSuccessIcon}
          alt=""
          className=" max-w-[45px] "
        />
        <h2 className="text-xl font-bold mt-3 text-center" style={{ color: "#0689BE" }}>
          Log out Successful
        </h2>
      </div>
    </div>
  );
};

const LayoutNavbar = () => {
  const dispatch = useDispatch();
  const [openSideBar, setOpenSideBar] = useState(false);
  const globalProfileImg = useSelector((state) => state.auth.globalProfileImg);
  const name = useSelector((state) => state.auth.name);
  const email = useSelector((state) => state.auth.email);
  const [isModalVisible, setIsModalVisible] = useState(false)
  const isLoggedIn = useSelector((state) => state.auth.isLoggedIn);
  const userDetail = useSelector((state) => state.auth.userDetail);
  const router = useRouter();
  const currentPath = router;
  const handleSideBar = () => {
    setOpenSideBar(!openSideBar);
  };
  const [activeLink, setActiveLink] = useState("");
  const handleLinkClick = (link) => {
    setActiveLink(link); 
  };
  const [currentUrl, setCurrentUrl] = useState('');

  useEffect(() => {
    console.log('Current Pathsss:', router.asPath   );
    if(window.location.pathname === "/"){
      handleLinkClick("/")
    }
    if(window.location.pathname === "/discover"){
      handleLinkClick("/discover")
    }
    if(window.location.pathname === "/about-us"){
      handleLinkClick("/about-us")
    }
    if(window.location.pathname === "/contact-us"){
      handleLinkClick("/contact-us")
    }
    if (router.pathname) {
      console.log('Current Path:', router.pathname);
      setActiveLink(router.pathname); // Initialize active link
    }
  }, [router]);

  const handleLogout = () => {
    // Clear the cookies
    dispatch(userLogout(null));
    Cookies.remove("authToken");
    Cookies.remove("role");
    localStorage.clear();
    setIsModalVisible(true);
    setTimeout(() => {
      setIsModalVisible(false);
    }, 2000);

  };
  const [isOpen, setIsOpen] = useState(false);

  const toggleDropdown = () => {
    setIsOpen(!isOpen);
    console.log(userDetail.role);
  };
  const closeModal = () => {
    setIsModalVisible(false);
  };

  return (
    <>
      <div className=" fixed z-10 top-0 left-0 w-full border-b border-[#D6D6D6] bg-white">
        <Modal isModalVisible={isModalVisible} closeModal={closeModal} />
        <div className="max-w-7xl md:px-5 mx-auto md:h-[120px] h-[100px] ">
          <div className="flex items-center justify-between md:h-[120px] h-[100px]  px-6 md:px-0 gap-2">
            <Link 
            href="/"
            onClick={() => handleLinkClick("/")}>
              <Image
                src={appLogo}
                alt="applogo"
                className="h-[60px] w-[170px]  md:w-[200px]  md:h-[70px] xl:h-[70px] xl:w-[250px] object-contain"
              />
            </Link>
            {/*Tesktop view  */}
            <div className="   lg:hidden " onClick={handleSideBar}>
              <FontAwesomeIcon icon={faBars} className="h-5 w-5" />
            </div>
            {/*Tesktop view  */}

            <div className=" hidden  lg:flex lg:gap-10 md:gap-0 text-[18px] font-bold">
              <Link
                href="/"
                onClick={() => handleLinkClick("/")}
                className={`${activeLink === "/" ? "text-[#0689BE]" : "text-gray-900"}`}
              >
                Home
              </Link>
              <Link
                href="/discover"
                onClick={() => handleLinkClick("/discover")}
                className={`${activeLink === "/discover" ? "text-[#0689BE]" : "text-gray-900"} md:ml-3 ml-4`}
              >
                Discover
              </Link>

              <Link
                href="/about-us"
                onClick={() => handleLinkClick("/about-us")}
                className={`${activeLink === "/about-us" ? "text-[#0689BE]" : "text-gray-900"} md:ml-3 ml-4`}
              >
                About
              </Link>
              <Link
                href="/contact-us"
                onClick={() => handleLinkClick("/contact-us")}
                className={`${activeLink === "/contact-us" ? "text-[#0689BE]" : "text-gray-900"} md:ml-3 ml-4`}
              >
                Contact
              </Link>
            </div>
            <div className="hidden  lg:flex items-center gap-3 text-[18px] font-bold">
              {!isLoggedIn && (
                <div className="flex gap-2 items-center gap-[20px]">
                  <Link href="/login" className="text-blue-500 text-gray-900  hover:underline">
                    Log In
                  </Link>
                  <Link
                    href="/sign-up"
                    className="bg-[#0689BE] min-w-[140px] text-base font-semibold text-center text-white px-3 py-2 rounded-full"
                  >
                    Sign Up
                  </Link>
                </div>
              )}
              {/* {isLoggedIn && globalProfileImg && (
                <img
                  src={`https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`}
                  alt="Profile"
                  style={{
                    width: "50px",
                    height: "50px",
                    objectFit: "cover",
                  }}
                  className="rounded-full"
                />

              )} */}

              {/* {isLoggedIn && (
             
                <Link
                  href="#"
                  className="bg-[#0689BE] text-white px-3 py-2 rounded-full md:flex items-center gap-[10px]" onClick={handleLogout}>
                  <Image src={logoutLogo} alt="logout-logo" className="h-5 w-5 filter brightness-0 invert" /> LogOut
                </Link>
              )} */}
              {isLoggedIn && (
                <div className="relative">
                  <button
                    onClick={toggleDropdown}
                    className="flex items-center gap-2 px-3 py-2 bg-white border border-gray-300 rounded hover:bg-gray-50"
                  >
                    <img
                    src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
                    alt="Profile Picture"
                    className="w-10 h-10 rounded-full object-cover"
                  />
                    <span>{name}</span>
                    <svg className="w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                      <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
                    </svg>
                  </button>
                  {isOpen && (
                    <div className="absolute right-0 mt-2 w-64 bg-white border border-gray-200 rounded shadow-lg w-full">
                      {/* <div className="flex items-center gap-2 px-4 py-3">
                        <img
                         src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
                          alt="Profile Picture"
                          className="w-10 h-10 rounded-full object-cover"
                        />
                        <div>
                          <p className="font-medium text-gray-900">{name}</p>
                        </div>
                      </div> */}
                      <hr className="border-gray-200" />
                      <ul className="py-1 text-sm text-gray-700">
                        <li>

                          <Link
                            href={userDetail?.role === 'admin' ? '/users' : '/flights'}
                            className="flex items-center gap-2 px-4 py-2 hover:bg-gray-50"
                          >
                            <Image
                              src={dashboardIcon}
                              alt="appLogo"
                              className="w-[20px] h-[20px]"
                            />
                            Dashboard
                          </Link>
                        </li>
                        <li>
                          <a href="#" className="flex items-center gap-2 px-4 py-2 hover:bg-gray-50" onClick={handleLogout}>
                            <Image
                              src={logoutLogo}
                              alt="appLogo"
                              className="w-[20px] h-[20px] "
                            />
                            Log Out
                          </a>
                        </li>
                      </ul>
                    </div>
                  )}
                </div>
              )}

            </div>
          </div>
        </div>
      </div>
      {openSideBar && (
        <div className=" z-20 fixed lg:hidden   right-0 top-0 h-screen bg-slate-400 bg-opacity-50 w-full flex justify-end ">
          <div className="  bg-white text-black w-[300px] max-h-screen">
            <div className="flex justify-between h-[100px] items-center px-6 border-b border-[#D6D6D6] ">
              <Image
                src={appLogo}
                alt="appLogo"
                className="w-[170px] h-[50px] "
              />
              <FontAwesomeIcon
                icon={faXmark}
                onClick={handleSideBar}
                className="h-5 w-5"
              />
            </div>
            <div className="h-[700px] flex flex-col justify-between ">
              <div className=" pl-6 pr-6 pt-6 flex flex-col gap-8  text-[18px] font-bold">
                {isLoggedIn && (
                  <div className="relative">
                    {/* <button
                      onClick={toggleDropdown}
                      className="flex items-center gap-2 px-3 py-2 bg-white border border-gray-300 rounded hover:bg-gray-50"
                    >
                      <img
                        src={`https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`}
                        alt="Profile Picture"
                        className="w-10 h-10 rounded-full"
                      />
                      <span>{name}</span>
                      <svg className="w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fillRule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clipRule="evenodd" />
                      </svg>
                    </button>

                    {isOpen && (
                      <div className="absolute right-0 mt-2 w-64 bg-white border border-gray-200 rounded shadow-lg">
                        <div className="flex items-center gap-2 px-4 py-3">
                          <img
                            src={`https://tracking.logoinnovators.com/backend/public/${globalProfileImg}`}
                            alt="Profile Picture"
                            className="w-10 h-10 rounded-full"
                          />
                          <div>
                            <p className="font-medium text-gray-900">{name}</p>
                          </div>
                        </div>
                        <hr className="border-gray-200" />
                        <ul className="py-1 text-sm text-gray-700">
                          <li>
                            <Link href="/users" className="flex items-center gap-2 px-4 py-2 hover:bg-gray-50">
                              <Image
                                src={dashboardIcon}
                                alt="appLogo"
                                className="w-[20px] h-[20px] "
                              />
                              Dashboard
                            </Link>
                          </li>
                          <li>
                            <a href="#" className="flex items-center gap-2 px-4 py-2 hover:bg-gray-50" onClick={handleLogout}>
                              <Image
                                src={logoutLogo}
                                alt="appLogo"
                                className="w-[20px] h-[20px] "
                              />
                              LogOut
                            </a>
                          </li>
                        </ul>
                      </div>
                    )} */}
                    <div className="flex items-center gap-2">
                      <img
                       src={globalProfileImg ? `https://tracking.logoinnovators.com/backend/public/${globalProfileImg}` : "https://m.media-amazon.com/images/I/5170BeVp0kL._AC_UL800_QL65_.jpg"}
                        alt="Profile Picture"
                        className="w-12 h-12 rounded-full object-cover"
                      />
                      <div>
                        <p className="font-medium text-gray-900 text-18px] pl-3">{name}</p>
                      </div>
                    </div>
                  </div>
                )}
                <Link href="/" className="text-[#0689BE] ">
                  Home
                </Link>
                <Link href="/discover" className=" text-gray-900 ">
                  Discover
                </Link>
                <Link href="/about-us" className=" text-gray-900 ">
                  About
                </Link>
                {isLoggedIn && (
                  <>
                    <Link href={userDetail?.role === 'admin' ? '/users' : '/flights'} className="text-gray-900">
                      Dashboard
                    </Link>
                    <Link href="#" className="text-gray-900" onClick={handleLogout}>
                      Log Out
                    </Link>
                  </>
                )}

              </div>
              {!isLoggedIn && (
                <div className="pl-6 pt-3 flex gap-4 items-center text-[18px] font-bold  ">
                  <Link href="/login">
                    Log In
                  </Link>
                  <Link
                    href="/sign-up"
                    className=" bg-[#0689BE] text-white px-3  py-2 rounded-full "
                  >
                    Sign Up
                  </Link>

                </div>
              )}
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default LayoutNavbar;
