import React from "react";
import LayoutNavbar from "../components/userLayouts/navbar/LayoutNavbar";
import LayoutFooter from "../components/userLayouts/footer/LayoutFooter";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faEnvelope, faPhone, faMapMarkerAlt } from "@fortawesome/free-solid-svg-icons";
import background from "../../../public/assets/userLayouts/backgroundImage.png";
import Image from "next/image";
const Contact = () => {
  return (
    <div className="overflow-x-hidden">
      <LayoutNavbar />
      <div className="pt-[120px] z-0">
        <div>
          {/* First Section */}
          <div class="bg-[#F2F2F2] h-[354px] flex items-center justify-center">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 ">
              <div className="text-center">
                <h2 className="md:text-7xl text-5xl font-bold py-8">Contact  <span className="text-[#0689BE] ml-2">Us</span></h2>
              </div>
            </div>
          </div>
          <div class="max-w-7xl px-5 mx-auto">

          </div>
        </div>
        <div className="max-w-7xl px-5 mx-auto grid grid-cols-1 md:grid-cols-2 gap-10 pt-20 pb-20">

          <div className="flex flex-col space-y-6">
            <h2 className=" text-[45px] font-bold">Get in Touch <span className="text-[#0689BE]">with Us </span></h2>
            <div className="flex items-center pt-2">
              <FontAwesomeIcon icon={faEnvelope} className="text-gray-700 mr-3" style={{
                backgroundColor: '#0689be',
                padding: '10px',
                borderRadius: '100px',
                color: '#fff',
                width: '16px',
                height: '16px'
              }} />
              <p className="text-[#838189] text-lg "><a href="mailto:info@marvalist.com">info@marvalist.com</a></p>
            </div>
            <div className="flex items-center">
              <FontAwesomeIcon icon={faPhone} className="text-gray-700 mr-3" style={{
                backgroundColor: '#0689be',
                padding: '10px',
                borderRadius: '100px',
                color: '#fff',
                width: '16px',
                height: '16px'
              }} />
              <p className="text-[#838189] text-lg "><a href="tel:+1 234 567 8900">+1 234 567 8900</a></p>
            </div>
            <div className="flex items-center">
              <FontAwesomeIcon
                icon={faMapMarkerAlt}
                className="text-gray-700 mr-3"
                style={{
                  backgroundColor: '#0689be',
                  padding: '10px',
                  borderRadius: '100px',
                  color: '#fff',
                  width: '16px',
                  height: '16px'
                }}
/>
              <p className="text-[#838189] text-lg ">205. R Street, New York 11001</p>
            </div>


          </div>


          <div>

            <form action="#" method="POST">
              <div className="mb-4">
                <label htmlFor="name" className="block text-gray-700 text-sm font-bold mb-2">
                  Name
                </label>
                <input
                  type="text"
                  id="name"
                  name="name"
                  className="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                  placeholder="Your Name"
                  required
                />
              </div>
              <div className="mb-4">
                <label htmlFor="email" className="block text-gray-700 text-sm font-bold mb-2">
                  Email
                </label>
                <input
                  type="email"
                  id="email"
                  name="email"
                  className="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                  placeholder="Your Email"
                  required
                />
              </div>
              <div className="mb-4">
                <label htmlFor="message" className="block text-gray-700 text-sm font-bold mb-2">
                  Message
                </label>
                <textarea
                  id="message"
                  name="message"
                  rows="4"
                  className="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                  placeholder="Your Message"
                  required
                ></textarea>
              </div>
              <div className="text-left">
                <button type="submit" class="capitalize shadow-custom_blue py-1 leading-10 px-5 min-w-[170px] text-center text-white rounded-full  bg-[#0689BE] text-base font-semibold"> Send Message</button>
              </div>
            </form>
          </div>
        </div>

        <div className="  md:h-[641px] bg-secondary  pb-16">
          <div className="relative mx-auto  max-w-7xl md:h-[641px]">
            <Image
              className=" absolute z-0  top-0 bottom-0 left-0  object-cover  xl:max-w-7xl lg:max-w-[1000px]  md:max-w-[800px] sm:max-w-[600px]  max-w-[350px] md:h-[641px]"
              src={background}
              alt="Background-Image"
            />
            <div className="md:h-[641px] flex flex-col gap-10 justify-center  px-8 relative z-1">
              <div className="text-center flex flex-col items-center">
                <p className="text-primary text-2xl  py-7 font-normal ">
                  Subscribe to our Newsletter
                </p>
                <p className="text-white md:text-5xl text-3xl pb-7  max-w-[900px]">
                  Prepare yourself & let’s explore the beauty of the world
                </p>
              </div>
              <div className=" flex md:flex-row flex-col md:gap-4 gap-4 justify-center">
                <div className="relative w-full lg:w-[60%]">
                  <input
                    type="text"
                    placeholder="Your Email"
                    className="bg-white px-10 py-3 rounded-3xl w-full outline-none h-[50px]"
                  />
                  <FontAwesomeIcon
                    icon={faEnvelope}
                    className=" absolute left-3 md:top-4 top-3 h-[19px] w-[19px]"
                  />
                </div>
                <button className="bg-primary rounded-3xl py-2 px-5 font-semibold text-[14px] text-white md:min-w-[170px]">
                  Subscribe
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
      <LayoutFooter />
    </div>
  );
};

export default Contact;
