"use client";
import { DM_Sans } from "next/font/google";
import { Toaster } from "react-hot-toast";

const dmSans = DM_Sans({ subsets: ["latin"] });

import { Providers } from "../redux/providers";
import { Suspense } from "react";
import "./globals.css";

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <head>
        <meta name="title" content="Marvalist" />
        <meta name="description" content="Generated by create next app" />
      </head>
      <body className={`${dmSans.className}`}>
        <Providers>
          <Suspense fallback={<div>Loading...</div>}>
            <Toaster />
            {children}
          </Suspense>
        </Providers>
      </body>
    </html>
  );
};