import { createSlice } from "@reduxjs/toolkit";
import { persistReducer } from "redux-persist";
import createWebStorage from "redux-persist/lib/storage/createWebStorage";

const createNoopStorage = () => {
  return {
    getItem(_key) {
      return Promise.resolve(null);
    },
    setItem(_key, value) {
      return Promise.resolve(value);
    },
    removeItem(_key) {
      return Promise.resolve();
    },
  };
};

const storage =
  typeof window !== "undefined"
    ? createWebStorage("local")
    : createNoopStorage();

const persistConfig = {
  key: "authSlice",
  version: 1,
  storage,
  blacklist: [],
};

const initialState = {
  isLoggedIn: false,
  token: null,
  userDetail: null,
  globalProfileImg: null,
  name: null,       
  email: null
};

export const authSlice = createSlice({
  name: "auth",
  initialState,
  reducers: {
    loggedIn: (state, data) => {
      state.isLoggedIn = true;
      state.token = data.payload.token;
      state.userDetail = data.payload.user;
    },

    userLogout: (state) => {
      state.isLoggedIn = false;
      state.token = null;
      state.userDetail = null;
    },
    setGlobalProfileImg: (state, action) => {
      const { profilePhoto, name, email } = action.payload;
      state.globalProfileImg = profilePhoto;
      state.name = name;
      state.email = email;
    },
    
    updateUserProfile: (state, data) => {
      state.userDetail = { ...state.userDetail, ...data.payload };
    },
  },
});

export const { loggedIn, userLogout, updateUserProfile , setGlobalProfileImg} = authSlice.actions;

export default persistReducer(persistConfig, authSlice.reducer);