import { SplitApiSettings } from "./SplitApiSetting";
import { API_END_POINTS } from "./ApiEndpoints";

export const api = SplitApiSettings.injectEndpoints({
  reducerPath: "api",
  refetchOnMountOrArgChange: true,

  endpoints: (builder) => ({
    /////////////////////////////<===MUTATIONS===>//////////////////////

    loginUser: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.loginUser,
          method: "POST",
          body: data,
        };
      },
    }),


    forgotPassword: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.forgotPassword,
          method: "POST",
          body: data,
        };
      },
    }),

    resetPassword: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.resetPassword,
          method: "POST",
          body: data,
        };
      },
    }),

    createPaymentIntent: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.createPaymentIntent,
          method: "POST",
          body: data,
        };
      },
    }),

    savePaymentIntent: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.savePaymentIntent,
          method: "POST",
          body: data,
        };
      },
    }),

    updateSubscriptionPlan: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.updateSubscriptionPlan,
          method: "POST",
          body: data,
        };
      },
    }),

    updateUserProfile: builder.mutation({
      query: ({ data }) => {
        return {
          url: API_END_POINTS.updateUserProfile,
          method: "POST",
          body: data,
        };
      },
    }),

    /////////////////////////////<===QUERIES===>////////////////////////

    getUserProfile: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getUserProfile,
          method: "GET",
        };
      },
    }),

    getAllUser: builder.query({
      query: (search) => {
        return {
          url: `${API_END_POINTS.getAllUser}${search}`, 
          method: "GET",
        };
      },
    }),
    

    getFlightDetails: builder.query({
      query: ({ carrier_code, flight_number, departure_date, user_id }) => ({
        url: API_END_POINTS.getFlightDetail,
        method: 'GET',
        params: {
          carrier_code,
          flight_number,
          departure_date,
          user_id,
        },
      }),
    }),

    getFlightInfo: builder.query({
      query: ({ user_id }) => ({
        url: API_END_POINTS.getFlightInfo.replace("{user}", user_id),  
        method: 'GET',
        params: {
          user_id,
        },
      }),
    }),

    
    getUserFlights: builder.query({
      query: ({ id , year , month , day }) => {
        return {
          url: `${API_END_POINTS.getUserFlights}/${id}/flights?year=${year}&month=${month}&day=${day}`,
          method: "GET",
        };
      },
    }),

    getUserBillingAndSubs: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getUserBillingAndSubs}/${id}/subscriptions`,
          method: "GET",
        };
      },
    }),

    getUserDetail: builder.query({
      query: ({ id }) => {
        return {
          url: `${API_END_POINTS.getUserDetail}/${id}`,
          method: "GET",
        };
      },
    }),

    getSubsPlans: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getSubsPlans,
          method: "GET",
        };
      },
    }),

    getAdminSubs: builder.query({
      query: () => {
        return {
          url: API_END_POINTS.getAdminSubs,
          method: "GET",
        };
      },
    }),

    searchUsersInfo: builder.query({
      query: ({ parameter }) => {
        return {
          url: `${API_END_POINTS. searchUsersInfo}${parameter}`,
          method: "GET",
        };
      },
    }), 

sendOtp: builder.query({
  query: ({ phoneNumber }) => ({
    url: `${API_END_POINTS.sendOtp}${phoneNumber}`,
    method: "POST",
  }),
}),



  }),

  overrideExisting: true,
});

export const {
  /////////////////////////////<===WEBSITE MUTATIONS===>//////////////////////
  useLoginUserMutation,
  useForgotPasswordMutation,
  useResetPasswordMutation,
  useUpdateUserProfileMutation,
  useCreatePaymentIntentMutation,
  useSavePaymentIntentMutation,
  useUpdateSubscriptionPlanMutation,
  /////////////////////////////<===WEBSITE QUERIES===>////////////////////////
  useGetUserProfileQuery,
  useGetAllUserQuery,
  useGetUserFlightsQuery,
  useGetUserBillingAndSubsQuery,
  useGetUserDetailQuery,
  useGetSubsPlansQuery,
  useGetAdminSubsQuery,
  useGetSubsPlanByIdQuery,
  useSearchUsersInfoQuery,
  useSendOtpQuery,
} = api;